/*
 * Decompiled with CFR 0.152.
 */
package rblocks.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import rblocks.network.IPacketHandler;
import rblocks.network.RBClientPacketHandler;
import rblocks.network.RBPacket;
import rblocks.network.RBServerPacketHandler;

public class NetworkHandler {
    public static NetworkHandler instance;
    final FMLEventChannel ec;
    final String myChannelName;
    final IPacketHandler clientHandler;
    final IPacketHandler serveHandler;

    public NetworkHandler(String channelName) {
        FMLCommonHandler.instance().bus().register((Object)this);
        this.myChannelName = channelName;
        this.ec = NetworkRegistry.INSTANCE.newEventDrivenChannel(this.myChannelName);
        this.ec.register((Object)this);
        this.clientHandler = this.createClientSide();
        this.serveHandler = this.createServerSide();
    }

    private IPacketHandler createServerSide() {
        try {
            return new RBServerPacketHandler();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private IPacketHandler createClientSide() {
        try {
            return new RBClientPacketHandler();
        }
        catch (Throwable t) {
            return null;
        }
    }

    @SubscribeEvent
    public void serverPacket(FMLNetworkEvent.ServerCustomPacketEvent ev) {
        NetHandlerPlayServer srv = (NetHandlerPlayServer)ev.packet.handler();
        if (this.serveHandler != null) {
            this.serveHandler.onPacketData(ev.packet, (EntityPlayer)srv.field_147369_b);
        }
    }

    @SubscribeEvent
    public void clientPacket(FMLNetworkEvent.ClientCustomPacketEvent ev) {
        if (this.clientHandler != null) {
            this.clientHandler.onPacketData(ev.packet, null);
        }
    }

    public String getChannel() {
        return this.myChannelName;
    }

    public void sendToAll(RBPacket message) {
        this.ec.sendToAll(message.getProxy());
    }

    public void sendTo(RBPacket message, EntityPlayerMP player) {
        this.ec.sendTo(message.getProxy(), player);
    }

    public void sendToAllAround(RBPacket message, NetworkRegistry.TargetPoint point) {
        this.ec.sendToAllAround(message.getProxy(), point);
    }

    public void sendToDimension(RBPacket message, int dimensionId) {
        this.ec.sendToDimension(message.getProxy(), dimensionId);
    }

    public void sendToServer(RBPacket message) {
        this.ec.sendToServer(message.getProxy());
    }
}

