/*
 * Decompiled with CFR 0.152.
 */
package rblocks.network;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import rblocks.core.RBLog;
import rblocks.network.RBPacket;
import rblocks.network.packets.PacketOrientation;

public class RBPacketHandlerBase {
    public static Map<Class, PacketTypes> reverseLookup = new HashMap<Class, PacketTypes>();

    public static enum PacketTypes {
        PACKET_TILE_DETAILS(PacketOrientation.class);

        public final Class pc;
        public final Constructor con;

        private PacketTypes(Class c) {
            this.pc = c;
            Constructor x = null;
            try {
                x = this.pc.getConstructor(ByteBuf.class);
            }
            catch (NoSuchMethodException e) {
                RBLog.error(e);
            }
            catch (SecurityException e) {
                RBLog.error(e);
            }
            this.con = x;
            reverseLookup.put(this.pc, this);
            if (this.con == null) {
                throw new RuntimeException("Invalid Packet Class, must be constructable on DataInputStream");
            }
        }

        public RBPacket parsePacket(ByteBuf in) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return (RBPacket)this.con.newInstance(in);
        }

        public static PacketTypes getPacket(int id) {
            return PacketTypes.values()[id];
        }

        public static PacketTypes getID(Class<? extends RBPacket> c) {
            return reverseLookup.get(c);
        }
    }
}

