/*
 * Decompiled with CFR 0.152.
 */
package rblocks.core;

import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import rblocks.core.RBLog;
import rblocks.network.packets.PacketOrientation;
import rblocks.util.IOrientable;

public class TileRotatableBlock
extends TileEntity
implements IOrientable {
    private ForgeDirection forward = ForgeDirection.SOUTH;
    private ForgeDirection up = ForgeDirection.UP;

    public boolean canUpdate() {
        return false;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        byte orientation = data.func_74771_c("orientation");
        this.forward = ForgeDirection.getOrientation((int)(orientation & 7));
        this.up = ForgeDirection.getOrientation((int)(orientation >> 3));
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        byte orientation = (byte)(this.up.ordinal() << 3 | this.forward.ordinal());
        data.func_74774_a("orientation", orientation);
    }

    @Override
    public ForgeDirection getForward() {
        return this.forward;
    }

    @Override
    public ForgeDirection getUp() {
        return this.up;
    }

    @Override
    public void setOrientation(ForgeDirection inForward, ForgeDirection inUp) {
        this.forward = inForward;
        this.up = inUp;
        this.func_70296_d();
        this.markForUpdate();
    }

    public byte getOrientationByte() {
        return (byte)(this.up.ordinal() << 3 | this.forward.ordinal());
    }

    public void setOrientationByte(byte orientation) {
        ForgeDirection old_Forward = this.forward;
        ForgeDirection old_Up = this.up;
        this.forward = ForgeDirection.getOrientation((int)(orientation & 7));
        this.up = ForgeDirection.getOrientation((int)(orientation >> 3));
        if (!this.forward.equals((Object)old_Forward) || !this.up.equals((Object)old_Up)) {
            this.markForUpdate();
        }
    }

    public Packet func_145844_m() {
        try {
            return new PacketOrientation(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getOrientationByte()).getProxy();
        }
        catch (IOException e) {
            RBLog.error(e);
            return null;
        }
    }

    public void markForUpdate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Block getBlock() {
        return this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getMeta() {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

