/*
 * Decompiled with CFR 0.152.
 */
package rblocks.transformer;

import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.Side;
import java.io.InputStream;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import rblocks.core.RBLog;
import rblocks.transformer.annotations.RBClientMethod;
import rblocks.transformer.annotations.RBCoreCopy;

public class RBCoreASMTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        try {
            if (transformedName != null && transformedName.equals("net.minecraft.client.renderer.RenderBlocks")) {
                this.log("Found RenderBlocks.");
                ClassNode classNode = new ClassNode();
                ClassReader classReader = new ClassReader(basicClass);
                classReader.accept((ClassVisitor)classNode, 0);
                block2: for (MethodNode mn : classNode.methods) {
                    boolean signatureMatch = mn.desc.equals("(Lahu;III)Z") || mn.desc.equals("(Lnet/minecraft/block/Block;III)Z");
                    boolean nameMatch = mn.name.equals("renderBlockByRenderType") || mn.name.equals("b") || mn.name.equals("func_147805_b");
                    if (!nameMatch || !signatureMatch) continue;
                    this.log(" Found renderBlockByRenderType.");
                    for (AbstractInsnNode node : mn.instructions) {
                        if (!(node instanceof MethodInsnNode)) continue;
                        this.log(" Replaced " + ((MethodInsnNode)node).name);
                        ((MethodInsnNode)node).name = "getRealRenderType";
                        continue block2;
                    }
                }
                ClassWriter writer = new ClassWriter(1);
                classNode.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
            if (transformedName != null && transformedName.equals("net.minecraft.block.Block")) {
                this.log("Found Block.");
                ClassNode srcNode = new ClassNode();
                InputStream is = this.getClass().getResourceAsStream("/rblocks/transformer/template/BlockChange.class");
                ClassReader srcReader = new ClassReader(is);
                srcReader.accept((ClassVisitor)srcNode, 0);
                ClassNode classNode = new ClassNode();
                ClassReader classReader = new ClassReader(basicClass);
                classReader.accept((ClassVisitor)classNode, 0);
                for (MethodNode mn : srcNode.methods) {
                    if (!this.hasAnnotation(mn.visibleAnnotations, RBCoreCopy.class)) continue;
                    this.log("Found " + mn.name);
                    this.handleMethod(classNode, srcNode.name, mn);
                }
                ClassWriter writer = new ClassWriter(1);
                classNode.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return basicClass;
    }

    private void handleMethod(ClassNode classNode, String from, MethodNode mn) {
        if (FMLLaunchHandler.side() == Side.SERVER && this.hasAnnotation(mn.visibleAnnotations, RBClientMethod.class)) {
            RBLog.info("Skipping, method client only.", new Object[0]);
            return;
        }
        ListIterator i = mn.instructions.iterator();
        while (i.hasNext()) {
            this.processNode((AbstractInsnNode)i.next(), from, classNode.name);
        }
        for (MethodNode tmn : classNode.methods) {
            if (!tmn.name.equals(mn.name) || !tmn.desc.equals(mn.desc)) continue;
            RBLog.info("Found " + tmn.name + " : Appending", new Object[0]);
            AbstractInsnNode finalReturn = mn.instructions.getLast();
            while (!this.isReturn(finalReturn.getOpcode())) {
                mn.instructions.remove(finalReturn);
                finalReturn = mn.instructions.getLast();
            }
            mn.instructions.remove(finalReturn);
            tmn.instructions.insert(mn.instructions);
            return;
        }
        RBLog.info("No Such Method " + mn.name + " : Adding", new Object[0]);
        classNode.methods.add(mn);
    }

    private boolean hasAnnotation(List<AnnotationNode> anns, Class anno) {
        if (anns == null) {
            return false;
        }
        for (AnnotationNode ann : anns) {
            if (!ann.desc.equals(Type.getDescriptor((Class)anno))) continue;
            return true;
        }
        return false;
    }

    private boolean isReturn(int opcode) {
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                return true;
            }
        }
        return false;
    }

    private void processNode(AbstractInsnNode next, String from, String nePar) {
        if (next instanceof MethodInsnNode) {
            MethodInsnNode min = (MethodInsnNode)next;
            if (min.owner.equals(from)) {
                min.owner = nePar;
            }
        }
    }

    private void log(String string) {
        FMLRelaunchLog.log((String)"RBCore-CORE", (Level)Level.INFO, (String)string, (Object[])new Object[0]);
    }
}

