package scouter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.Frustrum;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

import org.lwjgl.opengl.GL11;

import cpw.mods.fml.client.FMLClientHandler;

public class RenderScouter extends Render
{
	private final Scouter mod;
	private MovingObjectPosition movingObjectPosition;
	public Map<String, String> entityAImap = new HashMap<String, String>();
	{
		entityAImap.put("kk", "ArrowAttack");
		entityAImap.put("kl", "AvoidEntity");
		entityAImap.put("km", "Beg");
		entityAImap.put("kn", "BreakDoor");
		entityAImap.put("ko", "Mate");
		entityAImap.put("kp", "DoorInteract");
		entityAImap.put("kq", "EatGrass");
		entityAImap.put("kr", "FleeSun");
		entityAImap.put("ks", "Swimming");
		entityAImap.put("kt", "FollowOwner");
		entityAImap.put("ku", "FollowParent");
		entityAImap.put("kv", "Base");
		entityAImap.put("kw", "Tasks");
		entityAImap.put("kx", "TaskEntry");
		entityAImap.put("ky", "WatchClosest2");
		entityAImap.put("kz", "LeapAtTarget");
		entityAImap.put("la", "WatchClosest");
		entityAImap.put("lb", "LookAtTradePlayer");
		entityAImap.put("lc", "VillagerMate");
		entityAImap.put("ld", "AttackOnCollide");
		entityAImap.put("le", "MoveIndoors");
		entityAImap.put("lf", "MoveThroughVillage");
		entityAImap.put("lg", "MoveTwardsRestriction");
		entityAImap.put("lh", "MoveTowardsTarget");
		entityAImap.put("li", "OcelotSit");
		entityAImap.put("lj", "LookAtVillager");
		entityAImap.put("lk", "OpenDoor");
		entityAImap.put("ll", "OcelotAttack");
		entityAImap.put("lm", "Panic");
		entityAImap.put("ln", "Play");
		entityAImap.put("lo", "LookIdle");
		entityAImap.put("lp", "Wander");
		entityAImap.put("lq", "RestrictOpenDoor");
		entityAImap.put("lr", "RestrictSun");
		entityAImap.put("ls", "Sit");
		entityAImap.put("lt", "CreeperSwell");
		entityAImap.put("lu", "FollowGolem");
		entityAImap.put("lv", "Tempt");
		entityAImap.put("lw", "TradePlayer");
		entityAImap.put("lx", "DefendVillage");
		entityAImap.put("ly", "HurtByTarget");
		entityAImap.put("lz", "NearestAttackableTarget");
		entityAImap.put("ma", "NearestAttackableTargetSorter");
		entityAImap.put("mb", "TargetNonTamed");
		entityAImap.put("mc", "OwnerHurtByTarget");
		entityAImap.put("md", "OwnerHurtTarget");
		entityAImap.put("me", "Target");
	}

	public RenderScouter(Scouter mod)
	{
		this.mod = mod;
	}

	private void drawScouter(double x, double y, double z)
	{
		Minecraft minecraft = mod.entity.minecraft;
		if(minecraft.gameSettings.hideGUI)
		{
			return;
		}
		List list;
		if(minecraft.isSingleplayer())
		{
			list = minecraft.getIntegratedServer().worldServerForDimension(minecraft.thePlayer.dimension).loadedEntityList;
		} else
		{
			list = minecraft.theWorld.loadedEntityList;
		}
//		mod.entityCountAll = list.size();
		mod.entityCountMob = 0;
		mod.entityCountAnimal = 0;
		mod.entityCountItem = 0;
		mod.enemy = null;
		mod.looking = false;
		if(!mod.lockonBlockList.isEmpty())
		{
			Block block;
			for(int i = 0; i < mod.lockonBlockList.size(); i++)
			{
				block = minecraft.theWorld.getBlock(mod.lockonBlockList.get(i).blockX, mod.lockonBlockList.get(i).blockY, mod.lockonBlockList.get(i).blockZ);
				if(block == null)
				{
					if(mod.lockonBlockList.size() >= 2)
					{
						mod.lockonBlockList.remove(i);
						i--;
						if(mod.lockonBlockIndex > 0)
						{
							mod.lockonBlockIndex--;
						} else
						{
							mod.lockonBlockIndex = 0;
						}
					} else
					{
						mod.lockonBlockList.clear();
						break;
					}
				}
			}
		}
		if(!mod.lockonEntityList.isEmpty())
		{
			for(int i = 0; i < mod.lockonEntityList.size(); i++)
			{
				if(mod.lockonId == mod.lockonEntityList.get(i).getEntityId())
				{
					mod.targetEntity = mod.lockonEntityList.get(i);
				}
				if(mod.lockonEntityList.get(i).isDead)
				{
					int j = mod.lockonEntityList.get(i).getEntityId();
					if(mod.lockonEntityList.size() >= 2)
					{
						mod.lockonEntityList.remove(i);
						i--;
					} else
					{
						mod.lockonEntityList.clear();
						break;
					}
					if(mod.lockonId == j)
					{
						mod.lockonId = mod.lockonEntityList.get(0).getEntityId();
						mod.targetEntity = mod.lockonEntityList.get(0);
					}
				}
			}
		}
		if(mod.lockonBlockList.isEmpty())
		{
			mod.lockonBlockIndex = 0;
		}
		if(mod.lockonEntityList.isEmpty())
		{
			mod.lockonId = 0;
			mod.targetEntity = null;
		}
		OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, 240.0F, 240.0F);
		for(int listIndex = 0; listIndex < list.size(); listIndex++)
		{
			try
			{
				Entity entity = (Entity)list.get(listIndex);
				if(entity instanceof EntityPlayer)
				{
					continue;
				}
				float dis = entity.getDistanceToEntity(renderManager.livingPlayer) - 1.0F;
				if(dis <= mod_Scouter.range)
				{
					if(entity instanceof EntityLiving)
					{
						if(mod_Scouter.lockon && !mod_Scouter.lockonBlock)
						{
							lookingEntity(minecraft.thePlayer, (EntityLiving)entity, minecraft);
						}
					}
				}
				if(mod.targetEntity != null)
				{
					if(mod.targetEntity.getEntityId() == entity.getEntityId())
					{
						if(mod_Scouter.lockon)
						{
							drawScouterTargetSight(minecraft, entity, dis);
						}
					}
				}
				if(!mod.lockonEntityList.isEmpty())
				{
					if(mod.lockonEntityList.contains(entity))
					{
						if(mod_Scouter.lockon)
						{
							drawScouterTargetSight(minecraft, entity, dis);
							drawScouterTargetLabel(minecraft, (EntityLiving)entity);
						}
						if(mod_Scouter.lockon && mod.lockonId == entity.getEntityId())
						{
							long now = (System.currentTimeMillis() - mod.timer) / 10L;
							drawScouterTargetSightSub(minecraft, entity, dis, now * 2L, 8);
							drawScouterTargetSightSub(minecraft, entity, dis, -now * 4L, 7);
						}
					}
				}
				if(mod_Scouter.alert)
				{
					if(entity instanceof IMob)
					{
						if(renderManager.livingPlayer.canEntityBeSeen(entity))
						{
							if(entity instanceof EntityGhast && dis <= 64.0F)
							{
								mod.enemy = EntityList.getEntityString(entity);
							}
							else if(dis <= 16.0F)
							{
								mod.enemy = EntityList.getEntityString(entity);
							}
						}
					}
				}
				if(dis > mod_Scouter.range)
				{
					continue;
				}
				Frustrum frustrum = new Frustrum();
				frustrum.setPosition(x, y, z);
				if(!entity.ignoreFrustumCheck && !frustrum.isBoundingBoxInFrustum(entity.boundingBox))
				{
					continue;
				}
				if(entity instanceof EntityLiving)
				{
					if(entity instanceof EntityAnimal)
					{
						mod.entityCountAnimal++;
					} else
					{
						mod.entityCountMob++;
					}
				} else
				if(entity instanceof EntityItem)
				{
					mod.entityCountItem++;
				}
				switch(mod_Scouter.mode)
				{
				case 0://Item
					if(!(entity instanceof EntityItem))
					{
						continue;
					}
					break;
				case 1://Animal
					if(!(entity instanceof EntityAnimal))
					{
						continue;
					}
					break;
				case 2://ID
				case 3://Type
					if(!(entity instanceof EntityLiving))
					{
						continue;
					}
					break;
				case 4://Scouter
					if(!(entity instanceof EntityLiving) && !(entity instanceof EntityItem))
					{
						continue;
					}
					break;
				}
				FontRenderer fontRenderer = getFontRendererFromRenderManager();
				List<String> label = new ArrayList<String>();
				List<Double> data = new ArrayList<Double>();
				Double[] rgba = getMobColor(entity);
				double d = -(x - entity.posX);
				double d1 = -(y - entity.posY);
				double d2 = -(z - entity.posZ);
				switch(mod_Scouter.mode)
				{
				case 1://Animal
					EntityAnimal entityAnimal = (EntityAnimal)entity;
					if(entityAnimal instanceof EntitySheep)
					{
						EntitySheep entitySheep = (EntitySheep)entityAnimal;
						rgba[0] = (double)EntitySheep.fleeceColorTable[entitySheep.getFleeceColor()][0];
						rgba[1] = (double)EntitySheep.fleeceColorTable[entitySheep.getFleeceColor()][1];
						rgba[2] = (double)EntitySheep.fleeceColorTable[entitySheep.getFleeceColor()][2];
						rgba[3] = 0.6D;
						label.add(EntityList.getEntityString(entityAnimal) + "[" + ItemDye.field_150923_a[BlockColored.func_150031_c(entitySheep.getFleeceColor())] + "]");
//						if(entitySheep.getSheared())
//						{
//							label.add(Integer.toString((Integer)ModLoader.getPrivateValue(EntitySheep.class, entitySheep, "sheepTimer")));
//						}
					} else
					if(entityAnimal instanceof EntityTameable)
					{
						EntityTameable entityTameable = (EntityTameable)entityAnimal;
						if(entityTameable.isTamed())
						{
							String s = "";
							if(entityTameable instanceof EntityOcelot)
							{
								switch(((EntityOcelot)entityTameable).getTameSkin())
								{
								case 0:
									s = "Ocelot";
									break;
								case 1:
									s = "BlackCat";
									break;
								case 2:
									s = "RedCat";
									break;
								case 3:
									s = "SiameseCat";
									break;
								}
							} else
							{
								s = EntityList.getEntityString(entityTameable);
							}
							if(entityTameable.isSitting())
							{
								s += "[Sitting]";
							}
							label.add(s);
							label.add("Owner:" + entityTameable.getOwnerName());
						} else
						{
							String s = "";
							if(entityTameable instanceof EntityWolf)
							{
								if(((EntityWolf)entityTameable).isAngry())
								{
									s = "Angry";
								} else
								{
									s = "Wild";
								}
							}
							label.add(s + EntityList.getEntityString(entityAnimal));
						}
					} else
					{
						label.add(EntityList.getEntityString(entityAnimal));
					}
					if(entityAnimal instanceof EntityChicken)
					{
						label.add("Egg:" + ((EntityChicken)entityAnimal).timeUntilNextEgg / 20 + "sec");
					}
					label.add("HP:" + entityAnimal.getHealth() / 2);
					data.add(d);//x
					data.add(d1 + entityAnimal.height + 0.8D);//y
					data.add(d2);//z
					data.add(rgba[0]);//red
					data.add(rgba[1]);//green
					data.add(rgba[2]);//blue
					data.add(rgba[3]);//alpha
					data.add(calcLabelWidth(label));//width
					data.add(2.0D + (9.0D * (label.size() - 1)));//height
					break;
				case 2://ID
					label.add(Integer.toString(entity.getEntityId()));
					data.add(d);//x
					data.add(d1 + entity.height + 0.8D);//y
					data.add(d2);//z
					data.add(0.0D);//red
					data.add(0.0D);//green
					data.add(0.0D);//blue
					data.add(0.25D);//alpha
					data.add((double)(fontRenderer.getStringWidth(label.get(0)) / 2));//width
					data.add(2.0D);//height
					break;
				case 3://Type
					EntityLiving entityLiving = (EntityLiving)entity;
					label.add(EntityList.getEntityString(entityLiving));
					if(entityLiving instanceof EntityCreature)
					{
						EntityCreature entitycreature = (EntityCreature)entityLiving;
						if(entitycreature.getEntityToAttack() != null)
						{
							if(entitycreature.getEntityToAttack() instanceof EntityPlayer)
							{
								if(entitycreature.getEntityToAttack() != null || (minecraft.theWorld.getWorldInfo().getGameType().getID() != 1 && dis <= 16.0F))
								{
									EntityPlayer entityplayer = (EntityPlayer)entitycreature.getEntityToAttack();
									label.add("Target:" + entityplayer.getCommandSenderName());
								}
							} else
							{
								label.add("Target:" + EntityList.getEntityString(entitycreature.getEntityToAttack()));
							}
						}
					} else
					if(entityLiving instanceof EntitySlime)
					{
						if(minecraft.theWorld.getClosestPlayerToEntity(entityLiving, 16.0D) != null)
						{
							label.add("Target:" + minecraft.theWorld.getClosestPlayerToEntity(entityLiving, 16.0D).getCommandSenderName());
						}
					}
					label.add("HP:" + entityLiving.getHealth() / 2);
					data.add(d);//x
					data.add(d1 + entityLiving.height + 0.8D);//y
					data.add(d2);//z
					data.add(rgba[0]);//red
					data.add(rgba[1]);//green
					data.add(rgba[2]);//blue
					data.add(rgba[3]);//alpha
					data.add(calcLabelWidth(label));//width
					data.add(2.0D + (9.0D * (label.size() - 1)));//height
					break;
				case 4://Scouter
					if(entity instanceof EntityLiving)
					{
						EntityLiving entityLiving1 = (EntityLiving)entity;
						label.add("<" + EntityList.getEntityString(entityLiving1) + ">");
						if(EntityList.getEntityString(entityLiving1) == null)
						{
							label.add(entityLiving1.getEntityId() + "[null]");
						} else
						{
							label.add(entityLiving1.getEntityId() + "[" + EntityList.getEntityID(entityLiving1) + "]");
						}
						label.add("HP:" + entityLiving1.getHealth() / 2 + "/" + entityLiving1.getMaxHealth() / 2);
						label.add("X:" + (int)Math.floor(entityLiving1.posX));
						label.add("Z:" + (int)Math.floor(entityLiving1.posZ));
						label.add("Y:" + (int)Math.floor(entityLiving1.posY));
/*
						List<String> ai = mod.mod.getEntityAItasks(entityLiving1);
						int size = ai.size();
						for(int i = 0; i < size; i++)
						{
							label.add("AI:" + ai.get(i));
						}
*/
						data.add(d);//x
						data.add(d1);//y
						data.add(d2);//z
						data.add(rgba[0]);//red
						data.add(rgba[1]);//green
						data.add(rgba[2]);//blue
						data.add(rgba[3]);//alpha
						data.add(((entityLiving1.boundingBox.maxX - entityLiving1.boundingBox.minX) * 50));//width
						data.add(((entityLiving1.boundingBox.maxY - entityLiving1.boundingBox.minY) * 50));//height
						break;
					}
				case 0://Item
					EntityItem entityitem = (EntityItem)entity;
                    ItemStack itemStack = entityitem.getEntityItem();

					String s;
                    int itemID = Item.itemRegistry.getIDForObject(itemStack.getItem());
					if(entityitem.getEntityItem().getItem().getHasSubtypes())
					{
						if(entityitem.getEntityItem().stackSize > 1)
						{
							s = "[" + itemID + ":" + entityitem.getEntityItem().getItemDamage() + "] " + entityitem.getEntityItem().getItem().getItemStackDisplayName(entityitem.getEntityItem()) + " x" + entityitem.getEntityItem().stackSize;
						} else
						{
							s = "[" + itemID + ":" + entityitem.getEntityItem().getItemDamage() + "] " + entityitem.getEntityItem().getItem().getItemStackDisplayName(entityitem.getEntityItem());
						}
					} else
					{
						if(entityitem.getEntityItem().stackSize > 1)
						{
							s = "[" + itemID + "] " + entityitem.getEntityItem().getItem().getItemStackDisplayName(entityitem.getEntityItem()) + " x" + entityitem.getEntityItem().stackSize;
						} else
						{
							s = "[" + itemID + "] " + entityitem.getEntityItem().getItem().getItemStackDisplayName(entityitem.getEntityItem());
						}
					}
					label.add(s);
					label.add((6000 - entityitem.age) / 20 + "sec");
					data.add(d);//x
					data.add(d1 + 0.8D);//y
					data.add(d2);//z
					data.add(0.0D);//red
					data.add(0.0D);//green
					data.add(0.0D);//blue
					data.add(0.25D);//alpha
					data.add(calcLabelWidth(label));//width
					data.add(2.0D + (9.0D * (label.size() - 1)));//height
					break;
				}
				drawScouterSub(minecraft, data, label, dis);
			}
			catch(Exception exception)
			{
				exception.printStackTrace();
			}
		}
		if(mod_Scouter.lockonBlock)
		{
			drawCustomSelectionBox(minecraft);
		}
		if(mod_Scouter.lockon && mod.lockonBlockList != null)
		{
			for(MovingObjectPosition temp : mod.lockonBlockList)
			{
				drawCustomOutlinedBoundingBox(minecraft, true, temp);
			}
		}
	}

	private Double[] getMobColor(Entity entity)
	{
		String entityName = EntityList.getEntityString(entity);
		if(entityName == null)
		{
			return new Double[]{1.0D, 1.0D, 1.0D, 0.2D};
		}
		int entityId = EntityList.getEntityID(entity);
		switch(entityId)
		{
		case 50://Creeper
			return new Double[]{1.0D, 0.0D, 0.0D, 0.5D};
		case 51://Skeleton
			return new Double[]{1.0D, 1.0D, 1.0D, 0.5D};
		case 52://Spider
			return new Double[]{0.0D, 0.0D, 0.0D, 0.5D};
		case 54://Zombie
			return new Double[]{0.0D, 1.0D, 1.0D, 0.5D};
		case 55://Slime
			return new Double[]{0.0D, 1.0D, 0.0D, 0.5D};
		case 56://Ghast
			return new Double[]{1.0D, 0.0D, 0.0D, 0.5D};
		case 57://PigZombie
			return new Double[]{1.0D, 0.5D, 0.5D, 0.5D};
		case 58://Enderman
			return new Double[]{1.0D, 0.0D, 1.0D, 0.5D};
		case 59://CaveSpider
			return new Double[]{1.0D, 0.5D, 0.0D, 0.5D};
		case 60://Silverfish
			return new Double[]{0.5D, 0.5D, 0.5D, 0.5D};
		case 61://Blaze
			return new Double[]{1.0D, 1.0D, 0.0D, 0.5D};
		case 62://LavaSlime
			return new Double[]{0.0D, 0.0D, 0.0D, 0.5D};
		case 63://EnderDragon
			return new Double[]{Math.random(), Math.random(), Math.random(), 0.5D};
		case 94://Squid
			return new Double[]{0.0D, 0.0D, 1.0D, 0.5D};
		case 90://Pig
			if(mod_Scouter.mode == 1)
			{
				return new Double[]{1.0D, 0.5D, 0.5D, 0.4D};
			}
		case 91://Sheep
			if(mod_Scouter.mode == 1)
			{
				return new Double[]{1.0D, 1.0D, 1.0D, 0.4D};
			}
		case 92://Cow
			if(mod_Scouter.mode == 1)
			{
				return new Double[]{0.0D, 0.0D, 0.0D, 0.4D};
			}
		case 93://Chicken
			if(mod_Scouter.mode == 1)
			{
				return new Double[]{1.0D, 1.0D, 1.0D, 0.4D};
			}
		case 95://Wolf
			if(mod_Scouter.mode == 1)
			{
				return new Double[]{1.0D, 0.0D, 0.0D, 0.4D};
			}
		case 96://MushroomCow
			if(mod_Scouter.mode == 1)
			{
				return new Double[]{0.5D, 0.5D, 0.5D, 0.4D};
			}
		case 98://Ozelot
			if(mod_Scouter.mode == 1)
			{
				return new Double[]{1.0D, 1.0D, 0.0D, 0.4D};
			}
		case 97://SnowMan
		case 99://VillagerGolem
		case 120://Villager
		default:
			if(entityName == "LittleMaid"){
				return new Double[]{Math.random(), Math.random(), Math.random(), 0.5D};
			} else if(entity instanceof EntityMob)
			{
				return new Double[]{1.0D, 0.0D, 0.0D, 0.5D};
			} else
			{
				return new Double[]{1.0D, 1.0D, 1.0D, 0.2D};
			}
		}
	}

	private double calcLabelWidth(List<String> label)
	{
		FontRenderer fontRenderer = getFontRendererFromRenderManager();
		int[] line;
		line = new int[label.size()];
		for(int i = 0; i < line.length; i++)
		{
			line[i] = fontRenderer.getStringWidth(label.get(i)) / 2;
			if(line[0] < line[i])
			{
				line[0] = line[i];
			}
		}
		return line[0];
	}

	private void lookingEntity(EntityPlayer entityplayer, EntityLiving entityLiving, Minecraft minecraft)
	{
		Vec3 vec3d = entityplayer.getLook(1.0F).normalize();
		Vec3 vec3d1;
		if(minecraft.gameSettings.thirdPersonView == 2)
		{
			vec3d1 = Vec3.createVectorHelper(-entityLiving.posX - -entityplayer.posX, -(entityLiving.boundingBox.minY + (entityLiving.height / 2.0D)) - -(entityplayer.posY + entityplayer.getEyeHeight()), -entityLiving.posZ - -entityplayer.posZ);
		} else
		{
			vec3d1 = Vec3.createVectorHelper(entityLiving.posX - entityplayer.posX, (entityLiving.boundingBox.minY + (entityLiving.height / 2.0D)) - (entityplayer.posY + entityplayer.getEyeHeight()), entityLiving.posZ - entityplayer.posZ);
		}
		double d = vec3d1.lengthVector();
		vec3d1 = vec3d1.normalize();
		double d1 = vec3d.dotProduct(vec3d1);
		if(d1 > 1.0D - 0.05D / d)
		{
			if(!mod_Scouter.lockonBlock)
			{
				mod.targetEntity = entityLiving;
			}
			if(mod_Scouter.lockon)
			{
				drawScouterTargetLabel(minecraft, entityLiving);
			}
			mod.looking = true;
		}
	}

	private void drawCustomSelectionBox(Minecraft minecraft)
	{
		Vec3 vec3d = renderManager.livingPlayer.getPosition(mod.tick);
		Vec3 vec3d1 = renderManager.livingPlayer.getLook(mod.tick);
		Vec3 vec3d2;
		if(minecraft.gameSettings.thirdPersonView == 2)
		{
			vec3d2 = vec3d.addVector(-vec3d1.xCoord * mod_Scouter.range, -vec3d1.yCoord * mod_Scouter.range, -vec3d1.zCoord * mod_Scouter.range);
		} else
		{
			vec3d2 = vec3d.addVector(vec3d1.xCoord * mod_Scouter.range, vec3d1.yCoord * mod_Scouter.range, vec3d1.zCoord * mod_Scouter.range);
		}
		movingObjectPosition = minecraft.theWorld.rayTraceBlocks(vec3d, vec3d2);
//		movingObjectPosition = minecraft.renderViewEntity.rayTrace(mod.range, mod.tick);
//		movingObjectPosition = minecraft.renderViewEntity.rayTrace(minecraft.playerController.getBlockReachDistance(), mod.tick);
		if(movingObjectPosition == null)
		{
			mod.targetBlock = null;
			return;
		}
		if(movingObjectPosition.typeOfHit != MovingObjectPosition.MovingObjectType.BLOCK)
		{
			return;
		}
		mod.targetBlock = movingObjectPosition;
		drawCustomOutlinedBoundingBox(minecraft, false, null);
		drawScouterBlockStatus(minecraft);
	}

	private void drawCustomOutlinedBoundingBox(Minecraft minecraft, boolean flag, MovingObjectPosition temp)
	{
		float f1;
		GL11.glPushMatrix();
		GL11.glEnable(3042 /*GL_BLEND*/);
		if(flag)
		{
			GL11.glDisable(2896 /*GL_LIGHTING*/);
			GL11.glDisable(2929 /*GL_DEPTH_TEST*/);
			if(mod.lockonBlockList.get(mod.lockonBlockIndex) == temp)
			{
				GL11.glColor4f(1.0F, 0.0F, 0.0F, 1.0F);
				f1 = 0.0F;
				GL11.glLineWidth(1.5F);
			} else
			{
				GL11.glColor4f(1.0F, 0.0F, 0.0F, 0.5F);
				f1 = 0.0F;
				GL11.glLineWidth(1.0F);
			}
		} else
		{
			if(movingObjectPosition.hitVec.distanceTo(minecraft.renderViewEntity.getPosition(mod.tick)) > minecraft.playerController.getBlockReachDistance())
			{
				GL11.glColor4f(0.0F, 1.0F, 0.0F, 1.0F);
			} else
			{
				GL11.glColor4f(0.0F, 0.0F, 1.0F, 1.0F);
			}
			f1 = 0.004F;
			GL11.glLineWidth(2.0F);
			temp = movingObjectPosition;
		}
		GL11.glBlendFunc(770, 771);
		GL11.glDisable(3553 /*GL_TEXTURE_2D*/);
		GL11.glDepthMask(false);
		int j = 0;
        Block block = minecraft.theWorld.getBlock(temp.blockX, temp.blockY, temp.blockZ);
		if(Block.blockRegistry.getIDForObject(block) > 0)
		{
			double d = renderManager.viewerPosX;
			double d1 = renderManager.viewerPosY;
			double d2 = renderManager.viewerPosZ;
			AxisAlignedBB axisAlignedBB = block.getSelectedBoundingBoxFromPool(minecraft.theWorld, temp.blockX, temp.blockY, temp.blockZ).expand(f1, f1, f1).getOffsetBoundingBox(-d, -d1, -d2);
			Tessellator tessellator = Tessellator.instance;
			tessellator.startDrawing(3);
			tessellator.addVertex(axisAlignedBB.minX, axisAlignedBB.minY, axisAlignedBB.minZ);
			tessellator.addVertex(axisAlignedBB.maxX, axisAlignedBB.minY, axisAlignedBB.minZ);
			tessellator.addVertex(axisAlignedBB.maxX, axisAlignedBB.minY, axisAlignedBB.maxZ);
			tessellator.addVertex(axisAlignedBB.minX, axisAlignedBB.minY, axisAlignedBB.maxZ);
			tessellator.addVertex(axisAlignedBB.minX, axisAlignedBB.minY, axisAlignedBB.minZ);
			tessellator.draw();
			tessellator.startDrawing(3);
			tessellator.addVertex(axisAlignedBB.minX, axisAlignedBB.maxY, axisAlignedBB.minZ);
			tessellator.addVertex(axisAlignedBB.maxX, axisAlignedBB.maxY, axisAlignedBB.minZ);
			tessellator.addVertex(axisAlignedBB.maxX, axisAlignedBB.maxY, axisAlignedBB.maxZ);
			tessellator.addVertex(axisAlignedBB.minX, axisAlignedBB.maxY, axisAlignedBB.maxZ);
			tessellator.addVertex(axisAlignedBB.minX, axisAlignedBB.maxY, axisAlignedBB.minZ);
			tessellator.draw();
			tessellator.startDrawing(1);
			tessellator.addVertex(axisAlignedBB.minX, axisAlignedBB.minY, axisAlignedBB.minZ);
			tessellator.addVertex(axisAlignedBB.minX, axisAlignedBB.maxY, axisAlignedBB.minZ);
			tessellator.addVertex(axisAlignedBB.maxX, axisAlignedBB.minY, axisAlignedBB.minZ);
			tessellator.addVertex(axisAlignedBB.maxX, axisAlignedBB.maxY, axisAlignedBB.minZ);
			tessellator.addVertex(axisAlignedBB.maxX, axisAlignedBB.minY, axisAlignedBB.maxZ);
			tessellator.addVertex(axisAlignedBB.maxX, axisAlignedBB.maxY, axisAlignedBB.maxZ);
			tessellator.addVertex(axisAlignedBB.minX, axisAlignedBB.minY, axisAlignedBB.maxZ);
			tessellator.addVertex(axisAlignedBB.minX, axisAlignedBB.maxY, axisAlignedBB.maxZ);
			tessellator.draw();
		}
		GL11.glDepthMask(true);
		GL11.glEnable(3553 /*GL_TEXTURE_2D*/);
		if(flag)
		{
			GL11.glEnable(2929 /*GL_DEPTH_TEST*/);
			GL11.glEnable(2896 /*GL_LIGHTING*/);
		}
		GL11.glDisable(3042 /*GL_BLEND*/);
		GL11.glPopMatrix();
	}

	private void drawScouterSub(Minecraft minecraft, List<Double> data, List<String> label, float dis)
	{
		FontRenderer fontRenderer = getFontRendererFromRenderManager();
		float f1 = 1.6F;
		float f2 = 0.01666667F * f1;
		GL11.glPushMatrix();
		GL11.glTranslated(data.get(0), data.get(1), data.get(2));
		GL11.glNormal3f(0.0F, 1.0F, 0.0F);
		GL11.glRotatef(-renderManager.playerViewY, 0.0F, 1.0F, 0.0F);
		if(minecraft.gameSettings.thirdPersonView == 2)
		{
			GL11.glRotatef(-renderManager.playerViewX, 1.0F, 0.0F, 0.0F);
		} else
		{
			GL11.glRotatef(renderManager.playerViewX, 1.0F, 0.0F, 0.0F);
		}
		GL11.glScalef(-f2, -f2, f2);
		GL11.glEnable(3042 /*GL_BLEND*/);
		GL11.glDisable(2896 /*GL_LIGHTING*/);
		GL11.glDisable(2929 /*GL_DEPTH_TEST*/);
		GL11.glDepthMask(false);
		GL11.glBlendFunc(770, 771);
		GL11.glDisable(3553 /*GL_TEXTURE_2D*/);
		Tessellator tessellator = Tessellator.instance;
		tessellator.startDrawingQuads();
		tessellator.setColorRGBA_F(data.get(3).floatValue(), data.get(4).floatValue(), data.get(5).floatValue(), data.get(6).floatValue());
		tessellator.addVertex(-data.get(7) - 1.0D, -data.get(8) + 1.0D, 0.0D);
		tessellator.addVertex(-data.get(7) - 1.0D, 8.0D, 0.0D);
		tessellator.addVertex(data.get(7) + 1.0D, 8.0D, 0.0D);
		tessellator.addVertex(data.get(7) + 1.0D, -data.get(8) + 1.0D, 0.0D);
		tessellator.draw();
		GL11.glEnable(3553 /*GL_TEXTURE_2D*/);
		if(dis <= mod_Scouter.stringDisplayRange)
		{
			int h = 0;
			if(label.size() > 1)
			{
				h = -(int)Math.floor(data.get(8)) + 2;
			}
			for(String temp : label)
			{
				if(label.size() > 3)
				{
					fontRenderer.drawString(temp, (int)Math.floor(data.get(7)), h, 0xffffff);
				} else
				{
					fontRenderer.drawString(temp, -fontRenderer.getStringWidth(temp) / 2, h, 0xffffff);
				}
				h += 9;
			}
		}
		GL11.glDepthMask(true);
		GL11.glEnable(2929 /*GL_DEPTH_TEST*/);
		GL11.glEnable(2896 /*GL_LIGHTING*/);
		GL11.glDisable(3042 /*GL_BLEND*/);
		GL11.glPopMatrix();
	}

	private void drawScouterTargetLabel(Minecraft minecraft, EntityLiving entityLiving)
	{
		FontRenderer fontRenderer = getFontRendererFromRenderManager();
		String s;
		if(mod.lockonEntityList.indexOf(entityLiving) == -1)
		{
			s = EntityList.getEntityString(entityLiving);
		} else
		{
			s = "[" + (mod.lockonEntityList.indexOf(entityLiving) + 1) + "/" + mod.lockonEntityList.size() + "]" + EntityList.getEntityString(entityLiving);
		}
		int j = fontRenderer.getStringWidth(s) / 2;
		float dis = entityLiving.getDistanceToEntity(renderManager.livingPlayer) - 1.0F;
		float f1 = 1.6F;
		float f2 = 0.01666667F * f1;
		float f3 = (dis * 0.7F) / 5.0F;
		double d = -(renderManager.viewerPosX - entityLiving.posX);
		double d1 = -(renderManager.viewerPosY - entityLiving.posY);
		double d2 = -(renderManager.viewerPosZ - entityLiving.posZ);
		double fx = entityLiving.posX - minecraft.thePlayer.posX + dis + (200.0D / dis);
		double fy = entityLiving.posY - minecraft.thePlayer.posY + dis + (200.0D / dis);
		if(fx < dis)
		{
			fx -= dis;
		}
		GL11.glPushMatrix();
		GL11.glTranslated(d, d1 + (entityLiving.height / 1.6D), d2);
		GL11.glNormal3f(0.0F, 1.0F, 0.0F);
		GL11.glRotatef(-renderManager.playerViewY, 0.0F, 1.0F, 0.0F);
		if(minecraft.gameSettings.thirdPersonView == 2)
		{
			GL11.glRotatef(-renderManager.playerViewX, 1.0F, 0.0F, 0.0F);
		} else
		{
			GL11.glRotatef(renderManager.playerViewX, 1.0F, 0.0F, 0.0F);
		}
		GL11.glScalef(-f2, -f2, f2);
		GL11.glTranslatef(-(float)(fx * f3), -(float)(fy * f3), 0.0F);
		GL11.glScalef(f3, f3, f3);
		GL11.glEnable(3042 /*GL_BLEND*/);
		GL11.glDisable(2896 /*GL_LIGHTING*/);
		GL11.glDisable(2929 /*GL_DEPTH_TEST*/);
		GL11.glDepthMask(false);
		GL11.glLineWidth(1.0F);
		GL11.glBlendFunc(770, 771);
		GL11.glDisable(3553 /*GL_TEXTURE_2D*/);
		if(mod.lockonId == entityLiving.getEntityId())
		{
			GL11.glColor4f(mod.lockonColor_R, mod.lockonColor_G, mod.lockonColor_B, mod.lockonColor_A);
		} else
		{
			GL11.glColor4f(1.0F, 1.0F, 1.0F, mod.lockonColor_A);
		}
		Tessellator tessellator = Tessellator.instance;
		tessellator.startDrawing(2);
		tessellator.addVertex(-j - 2.0D, -2.0D, 0.0D);
		tessellator.addVertex(-j - 2.0D, 9.0D, 0.0D);
		tessellator.addVertex(j + 2.0D, 9.0D, 0.0D);
		tessellator.addVertex(j + 2.0D, -2.0D, 0.0D);
		tessellator.draw();
		tessellator.startDrawing(1);
		if(fx < 0)
		{
			tessellator.addVertex(-j - 2.0D, 9.0D, 0.0D);
		} else
		{
			tessellator.addVertex(j + 2.0D, 9.0D, 0.0D);
		}
		tessellator.addVertex(fx, fy, 0.0D);
		tessellator.draw();
		GL11.glEnable(3553 /*GL_TEXTURE_2D*/);
		if(mod.lockonId == entityLiving.getEntityId())
		{
			fontRenderer.drawString(s, -j, 0, mod.lockonColorInt);
		} else
		{
			fontRenderer.drawString(s, -j, 0, 0xccffffff);
		}
		GL11.glDepthMask(true);
		GL11.glEnable(2929 /*GL_DEPTH_TEST*/);
		GL11.glEnable(2896 /*GL_LIGHTING*/);
		GL11.glDisable(3042 /*GL_BLEND*/);
		GL11.glPopMatrix();
	}

	private void drawScouterTargetSight(Minecraft minecraft, Entity entity, float dis)
	{
		float f1 = 1.6F;
		float f2 = 0.01666667F * f1;
		double d = -(renderManager.viewerPosX - entity.posX);
		double d1 = -(renderManager.viewerPosY - entity.posY);
		double d2 = -(renderManager.viewerPosZ - entity.posZ);
		double size;
		if(mod.lockonId == entity.getEntityId() || mod.targetEntity.getEntityId() == entity.getEntityId())
		{
			size = 10.0D + dis * 5.0D;
		} else
		{
			size = 10.0D + dis * 2.5D;
		}
		GL11.glPushMatrix();
		GL11.glTranslated(d, d1 + (entity.height / 1.6D), d2);
		GL11.glNormal3f(0.0F, 1.0F, 0.0F);
		GL11.glRotatef(-renderManager.playerViewY, 0.0F, 1.0F, 0.0F);
		if(minecraft.gameSettings.thirdPersonView == 2)
		{
			GL11.glRotatef(-renderManager.playerViewX, 1.0F, 0.0F, 0.0F);
		} else
		{
			GL11.glRotatef(renderManager.playerViewX, 1.0F, 0.0F, 0.0F);
		}
		GL11.glScalef(-f2, -f2, f2);
		GL11.glEnable(3042 /*GL_BLEND*/);
		GL11.glDisable(2896 /*GL_LIGHTING*/);
		GL11.glDisable(2929 /*GL_DEPTH_TEST*/);
		GL11.glDepthMask(false);
		GL11.glBlendFunc(770, 771);
        Minecraft mc = FMLClientHandler.instance().getClient();
		mc.getTextureManager().bindTexture(mod.sightTexturePass);
		if(mod.lockonId == entity.getEntityId())
		{
			GL11.glColor4f(mod.lockonColor_R, mod.lockonColor_G, mod.lockonColor_B, mod.lockonColor_A);
		} else
		{
			GL11.glColor4f(1.0F, 1.0F, 1.0F, mod.lockonColor_A);
		}
		Tessellator tessellator = Tessellator.instance;
		tessellator.startDrawingQuads();
		tessellator.addVertexWithUV(-size, -size, 0.0D, 0.0D, 1.0D);
		tessellator.addVertexWithUV(-size, size, 0.0D, 1.0D, 1.0D);
		tessellator.addVertexWithUV(size, size, 0.0D, 1.0D, 0.0D);
		tessellator.addVertexWithUV(size, -size, 0.0D, 0.0D, 0.0D);
		tessellator.draw();
		GL11.glDepthMask(true);
		GL11.glEnable(2929 /*GL_DEPTH_TEST*/);
		GL11.glEnable(2896 /*GL_LIGHTING*/);
		GL11.glDisable(3042 /*GL_BLEND*/);
		GL11.glPopMatrix();
	}

	private void drawScouterTargetSightSub(Minecraft minecraft, Entity entity, float dis, long time, int i)
	{
		float f1 = 1.6F;
		float f2 = 0.01666667F * f1;
		double d = -(renderManager.viewerPosX - entity.posX);
		double d1 = -(renderManager.viewerPosY - entity.posY);
		double d2 = -(renderManager.viewerPosZ - entity.posZ);
		double size = 10.0D + dis * i;
		GL11.glPushMatrix();
		GL11.glTranslated(d, d1 + (entity.height / 1.6F), d2);
		GL11.glNormal3f(0.0F, 1.0F, 0.0F);
		GL11.glRotatef(-renderManager.playerViewY, 0.0F, 1.0F, 0.0F);
		if(minecraft.gameSettings.thirdPersonView == 2)
		{
			GL11.glRotatef(-renderManager.playerViewX, 1.0F, 0.0F, 0.0F);
		} else
		{
			GL11.glRotatef(renderManager.playerViewX, 1.0F, 0.0F, 0.0F);
		}
		GL11.glRotatef(time, 0.0F, 0.0F, 1.0F);
		GL11.glScalef(-f2, -f2, f2);
		GL11.glEnable(3042 /*GL_BLEND*/);
		GL11.glDisable(2896 /*GL_LIGHTING*/);
		GL11.glDisable(2929 /*GL_DEPTH_TEST*/);
		GL11.glDepthMask(false);
		GL11.glBlendFunc(770, 771);
        Minecraft mc = FMLClientHandler.instance().getClient();
		mc.getTextureManager().bindTexture(mod.circleTexturePass);
		if(mod.lockonId == entity.getEntityId())
		{
			GL11.glColor4f(mod.lockonColor_R, mod.lockonColor_G, mod.lockonColor_B, mod.lockonColor_A);
		} else
		{
			GL11.glColor4f(1.0F, 1.0F, 1.0F, mod.lockonColor_A);
		}
		Tessellator tessellator = Tessellator.instance;
		tessellator.startDrawingQuads();
		tessellator.addVertexWithUV(-size, -size, 0.0D, 0.0D, 1.0D);
		tessellator.addVertexWithUV(-size, size, 0.0D, 1.0D, 1.0D);
		tessellator.addVertexWithUV(size, size, 0.0D, 1.0D, 0.0D);
		tessellator.addVertexWithUV(size, -size, 0.0D, 0.0D, 0.0D);
		tessellator.draw();
		GL11.glDepthMask(true);
		GL11.glEnable(2929 /*GL_DEPTH_TEST*/);
		GL11.glEnable(2896 /*GL_LIGHTING*/);
		GL11.glDisable(3042 /*GL_BLEND*/);
		GL11.glPopMatrix();
	}

	private void drawScouterBlockStatus(Minecraft minecraft)
	{
		FontRenderer fontRenderer = getFontRendererFromRenderManager();
        Block block = minecraft.theWorld.getBlock(movingObjectPosition.blockX, movingObjectPosition.blockY, movingObjectPosition.blockZ);
		int metadata = minecraft.theWorld.getBlockMetadata(movingObjectPosition.blockX, movingObjectPosition.blockY, movingObjectPosition.blockZ);
        int blockID = Block.blockRegistry.getIDForObject(block);
		//Block block = Block.blocksList[blockId];
		ItemStack itemStack = new ItemStack(block, 1, metadata);
		List<String> label = new ArrayList<String>();
		if(metadata == 0)
		{
			label.add("[" + blockID + "]" + itemStack.getDisplayName());
		} else
		{
			label.add("[" + blockID + ":" + metadata + "]" + itemStack.getDisplayName());
		}
		label.add(movingObjectPosition.blockX + ":" + movingObjectPosition.blockZ + ":" + movingObjectPosition.blockY);
		double width = calcLabelWidth(label);
		double height = 2.0D + (9.0D * (label.size() - 1));
		int color;
		if(block.getMaterial() == Material.snow)
		{
			color = 0x000000;
		} else
		{
			color = 0xffffff;
		}
		float f1 = 1.6F;
		float f2 = 0.01666667F * f1;
		float d = -(float)(renderManager.viewerPosX - movingObjectPosition.blockX - block.getBlockBoundsMaxX() / 2.0D);
		float d1 = -(float)(renderManager.viewerPosY - movingObjectPosition.blockY - block.getBlockBoundsMaxY() / 2.0D);
		float d2 = -(float)(renderManager.viewerPosZ - movingObjectPosition.blockZ - block.getBlockBoundsMaxZ() / 2.0D);
		GL11.glPushMatrix();
		GL11.glTranslatef(d, d1, d2);
		GL11.glNormal3f(0.0F, 1.0F, 0.0F);
		GL11.glRotatef(-renderManager.playerViewY, 0.0F, 1.0F, 0.0F);
		if(minecraft.gameSettings.thirdPersonView == 2)
		{
			GL11.glRotatef(-renderManager.playerViewX, 1.0F, 0.0F, 0.0F);
		} else
		{
			GL11.glRotatef(renderManager.playerViewX, 1.0F, 0.0F, 0.0F);
		}
		GL11.glScalef(-f2, -f2, f2);
		GL11.glEnable(3042 /*GL_BLEND*/);
		GL11.glDisable(2896 /*GL_LIGHTING*/);
		GL11.glDisable(2929 /*GL_DEPTH_TEST*/);
		GL11.glDepthMask(false);
		GL11.glBlendFunc(770, 771);
		GL11.glDisable(3553 /*GL_TEXTURE_2D*/);
		Tessellator tessellator = Tessellator.instance;
		tessellator.startDrawingQuads();
		tessellator.setColorRGBA_I(block.getMaterial().getMaterialMapColor().colorValue, 100);
		tessellator.addVertex(-width - 1.0D, -height + 1.0D, 0.0D);
		tessellator.addVertex(-width - 1.0D, 8.0D, 0.0D);
		tessellator.addVertex(width + 1.0D, 8.0D, 0.0D);
		tessellator.addVertex(width + 1.0D, -height + 1.0D, 0.0D);
		tessellator.draw();
		GL11.glEnable(3553 /*GL_TEXTURE_2D*/);
		int h = -(int)Math.floor(height) + 2;
		for(String temp : label)
		{
			fontRenderer.drawString(temp, -fontRenderer.getStringWidth(temp) / 2, h, color);
			h += 9;
		}
		GL11.glDepthMask(true);
		GL11.glEnable(2929 /*GL_DEPTH_TEST*/);
		GL11.glEnable(2896 /*GL_LIGHTING*/);
		GL11.glDisable(3042 /*GL_BLEND*/);
		GL11.glPopMatrix();
	}

	public void drawScouterTargetStatus(Minecraft minecraft)
	{
		String[] s;
		boolean flag = false;
		if(mod_Scouter.lockonBlock)
		{
			int index = 0;
			if(mod.targetBlock == null)
			{
				if(!mod.lockonBlockList.isEmpty())
				{
					mod.targetBlock = mod.lockonBlockList.get(mod.lockonBlockIndex);
				}
			}
			if(!mod.lockonBlockList.isEmpty())
			{
				for(int i = 0; i < mod.lockonBlockList.size(); i++)
				{
					if(mod.lockonBlockList.get(i).blockX == mod.targetBlock.blockX && mod.lockonBlockList.get(i).blockY == mod.targetBlock.blockY && mod.lockonBlockList.get(i).blockZ == mod.targetBlock.blockZ)
					{
						index = i;
						flag = true;
						break;
					}
				}
			}
			Block block = minecraft.theWorld.getBlock(mod.targetBlock.blockX, mod.targetBlock.blockY, mod.targetBlock.blockZ);
            int blockID = Block.blockRegistry.getIDForObject(block);
            int metadata = minecraft.theWorld.getBlockMetadata(mod.targetBlock.blockX, mod.targetBlock.blockY, mod.targetBlock.blockZ);
			ItemStack itemStack = new ItemStack(block, 1, metadata);
			if(block == null) return;
			String localizedName = block.getLocalizedName();
			s = new String[9];
			if(!flag)
			{
				s[0] = "[NoLocked]";
			} else
			{
				s[0] = "[" + (index + 1) + "/" + mod.lockonBlockList.size() + "]";
			}
			s[1] = "<" + ((itemStack != null && itemStack.getItem() != null) ?  itemStack.getDisplayName() : localizedName) + ">";
			if(metadata == 0)
			{
				s[2] = "BlockID:" + blockID;
			} else
			{
				s[2] = "BlockID:" + blockID + "[" + metadata + "]";
			}
			s[3] = "LightValue:" + block.getLightValue();
//			s[3] = "Brightness:" + minecraft.theWorld.getBlockLightValue(mod.targetBlock.blockX, mod.targetBlock.blockY, mod.targetBlock.blockZ);
			s[4] = "GettingPower:" + minecraft.theWorld.isBlockIndirectlyGettingPowered(mod.targetBlock.blockX, mod.targetBlock.blockY, mod.targetBlock.blockZ);
//			s[4] = "BlastResist:" + (int)block.getExplosionResistance(minecraft.thePlayer) * 5;
			s[5] = String.format("MiningSpeed:%.2fsec", 1.0F / block.getPlayerRelativeBlockHardness(minecraft.thePlayer, minecraft.theWorld, mod.targetBlock.blockX, mod.targetBlock.blockY, mod.targetBlock.blockZ) / 20.0F);
			s[6] = String.format("%.4fx%.4fx%.4f", block.getBlockBoundsMaxX() - block.getBlockBoundsMinX(), block.getBlockBoundsMaxZ() - block.getBlockBoundsMinZ(), block.getBlockBoundsMaxY() - block.getBlockBoundsMinY());
			s[7] = String.format("X:%d Z:%d Y:%d", mod.targetBlock.blockX, mod.targetBlock.blockZ, mod.targetBlock.blockY);
			double rx = minecraft.thePlayer.posX - mod.targetBlock.blockX - block.getBlockBoundsMaxX() / 2.0D;
			double ry = minecraft.thePlayer.posY + minecraft.thePlayer.getEyeHeight() - minecraft.thePlayer.yOffset - mod.targetBlock.blockY - block.getBlockBoundsMaxY() / 2.0D;
			double rz = minecraft.thePlayer.posZ - mod.targetBlock.blockZ - block.getBlockBoundsMaxZ() / 2.0D;
			s[8] = "Distance:" + (int)Math.floor(Math.sqrt(rx * rx + ry * ry + rz * rz));
		} else
		{
			EntityLiving entityLiving = mod.targetEntity;
			if(mod.lockonEntityList.contains(entityLiving))
			{
				flag = true;
			}
			s = new String[9];
			if(mod.lockonEntityList.isEmpty() || !flag)
			{
				s[0] = "[NoLocked]";
			} else
			{
				s[0] = "[" + (mod.lockonEntityList.indexOf(entityLiving) + 1) + "/" + mod.lockonEntityList.size() + "]";
			}
			s[1] = "<" + EntityList.getEntityString(entityLiving) + ">";
			if(EntityList.getEntityString(entityLiving) == null)
			{
				s[2] = entityLiving.getEntityId() + "[null]";
			} else
			{
				s[2] = entityLiving.getEntityId() + "[" + EntityList.getEntityID(entityLiving) + "]";
			}
			s[3] = "HP:" + entityLiving.getHealth() / 2 + "/" + entityLiving.getMaxHealth() / 2;
			s[4] = "Exp:" + mod.mod.getExperiencePoints(entityLiving, minecraft.thePlayer);
			s[5] = "Drop:none";
			Item dropItem = mod.mod.getDropItem(entityLiving);
			if(dropItem !=null)
			{
                ItemStack itemStack = new ItemStack(dropItem);
                String theName = itemStack.getDisplayName();
                s[5] = "Drop:" + theName + "[" +Item.itemRegistry.getIDForObject(dropItem) + "]";
			}
			s[6] = String.format("X:%d Z:%d Y:%d", (int)Math.floor(entityLiving.posX), (int)Math.floor(entityLiving.posZ), (int)Math.floor(entityLiving.posY));
			s[7] = String.format("Yaw:%d Pitch:%d", (int)Math.floor(entityLiving.rotationYaw), (int)Math.floor(entityLiving.rotationPitch));
			s[8] = "Distance:" + (int)Math.floor(entityLiving.getDistanceToEntity(minecraft.thePlayer));
		}
		FontRenderer fontRenderer = minecraft.fontRenderer;
		ScaledResolution scaledResolution = new ScaledResolution(minecraft.gameSettings, minecraft.displayWidth, minecraft.displayHeight);
		int w = scaledResolution.getScaledWidth();
		int h = scaledResolution.getScaledHeight();
		GL11.glPushMatrix();
		switch(mod_Scouter.targetStatusPosition)
		{
		case 0:
			GL11.glTranslatef(w / 2.0F, h / 2.0F - s.length * 9.0F / 2.0F, 0.0F);
			break;
		case 1:
			GL11.glTranslatef(2.0F, 2.0F, 0.0F);
			break;
		case 2:
			if(mod_Scouter.coordinate)
			{
				GL11.glTranslatef(2.0F, h - s.length * 9.0F - 27.0F, 0.0F);
			} else
			{
				GL11.glTranslatef(2.0F, h - s.length * 9.0F, 0.0F);
			}
			break;
		case 3:
			GL11.glTranslatef(w - 2.0F, 2.0F, 0.0F);
			break;
		case 4:
			if(mod.count > 0)
			{
				GL11.glTranslatef(w - 2.0F, h - s.length * 9.0F - 27.0F, 0.0F);
			} else
			{
				GL11.glTranslatef(w - 2.0F, h - s.length * 9.0F, 0.0F);
			}
			break;
		}
		GL11.glTranslatef(mod_Scouter.targetStatus_X, mod_Scouter.targetStatus_Y, 0.0F);
		GL11.glEnable(3042 /*GL_BLEND*/);
		GL11.glBlendFunc(770, 771);
		int color = 0xccffffff;
		if(flag)
		{
			color = mod.lockonColorInt;
		}
		for(int i = 0; i < s.length; i++)
		{
			if(mod_Scouter.targetStatusPosition == 0)
			{
				fontRenderer.drawString(s[i], -fontRenderer.getStringWidth(s[i]) / 2, i * 9, color);
			} else
			if(mod_Scouter.targetStatusPosition <= 2)
			{
				fontRenderer.drawString(s[i], 0, i * 9, color);
			} else
			{
				fontRenderer.drawString(s[i], -fontRenderer.getStringWidth(s[i]), i * 9, color);
			}
		}
		GL11.glDisable(3042 /*GL_BLEND*/);
		GL11.glPopMatrix();
	}

	public void drawScouterAlert(Minecraft minecraft)
	{
		FontRenderer fontRenderer = minecraft.fontRenderer;
		ScaledResolution scaledResolution = new ScaledResolution(minecraft.gameSettings, minecraft.displayWidth, minecraft.displayHeight);
		int w = scaledResolution.getScaledWidth();
		int h = scaledResolution.getScaledHeight();
		GL11.glPushMatrix();
		GL11.glTranslatef(w / 2, h / 2, 0.0F);
		GL11.glEnable(3042 /*GL_BLEND*/);
		GL11.glBlendFunc(770, 771);
		fontRenderer.drawStringWithShadow("Warning!", -fontRenderer.getStringWidth("Warning!") - 10, -3, 0xccff0000);
		fontRenderer.drawStringWithShadow("<" + mod.enemy + ">", 10, -3, 0xccff0000);
		GL11.glDisable(3042 /*GL_BLEND*/);
		GL11.glPopMatrix();
	}

	public void drawScouterCoordinate(Minecraft minecraft)
	{
		FontRenderer fontRenderer = minecraft.fontRenderer;
		ScaledResolution scaledResolution = new ScaledResolution(minecraft.gameSettings, minecraft.displayWidth, minecraft.displayHeight);
//		int w = scaledResolution.getScaledWidth();
		int h = scaledResolution.getScaledHeight();
		int x = (int)Math.floor(minecraft.thePlayer.posX);
		int y = (int)Math.floor(minecraft.thePlayer.posY + minecraft.thePlayer.getEyeHeight() - minecraft.thePlayer.yOffset);
		int z = (int)Math.floor(minecraft.thePlayer.posZ);
		int direction = (int)Math.floor(((minecraft.thePlayer.rotationYaw * 8.0F) / 360.0F) + 0.5F) & 7;
		Chunk chunk = minecraft.theWorld.getChunkFromBlockCoords(x, z);
		ChunkCoordinates chunkCoordinates = minecraft.thePlayer.getBedLocation(minecraft.thePlayer.dimension);
		BiomeGenBase biomeGenBase = chunk.getBiomeGenForWorldCoords(x & 15, z & 15, minecraft.theWorld.getWorldChunkManager());
		if(chunkCoordinates == null)
		{
			chunkCoordinates = minecraft.theWorld.getSpawnPoint();
		}
		double rx = chunkCoordinates.posX - x;
		double ry = chunkCoordinates.posZ - z;
		int respawn = (int)Math.floor((Math.atan2(ry, rx) * (180.0D / Math.PI))) / 45 + 6;
		if(respawn > 7)
		{
			respawn -= 8;
		}
		int color1 = 0xccffffff;
		if(respawn == direction)
		{
			color1 = 0xccff0000;
		}
		ChunkPosition chunkPosition = minecraft.theWorld.findClosestStructure("Stronghold", x, y, z);
		int color2 = 0xccffffff;
		if(chunkPosition != null)
		{
			int sx = x - chunkPosition.chunkPosX;
			int sz = z - chunkPosition.chunkPosZ;
			int dis = (int)Math.floor(Math.sqrt(sx * sx + sz * sz));
			if(dis <= 16)
			{
				color2 = 0xccff00ff;
			} else
			if(dis <= 32)
			{
				color2 = 0xccff66ff;
			} else
			if(dis <= 64)
			{
				color2 = 0xccffccff;
			}
		}
		String d = "Undefined";
		switch(direction)
		{
		case 0:
			d = "[S] ";
			break;
		case 1:
			d = "[SW] ";
			break;
		case 2:
			d = "[W] ";
			break;
		case 3:
			d = "[NW] ";
			break;
		case 4:
			d = "[N] ";
			break;
		case 5:
			d = "[NE] ";
			break;
		case 6:
			d = "[E] ";
			break;
		case 7:
			d = "[SE] ";
			break;
		}
		GL11.glPushMatrix();
		GL11.glTranslatef(0.0F, h, 0.0F);
		GL11.glEnable(3042 /*GL_BLEND*/);
		GL11.glBlendFunc(770, 771);
		fontRenderer.drawStringWithShadow(d, 2, -27, color1);
		fontRenderer.drawStringWithShadow(biomeGenBase.biomeName, fontRenderer.getStringWidth(d), -27, 0xcc000000 + biomeGenBase.color);
		if(minecraft.isSingleplayer())
		{
			boolean slime = (new java.util.Random(minecraft.getIntegratedServer().worldServerForDimension(0).getSeed() + (chunk.xPosition * chunk.xPosition * 0x4c1906) + (chunk.xPosition * 0x5ac0db) + (chunk.zPosition * chunk.zPosition) * 0x4307a7L + (chunk.zPosition * 0x5f24f) ^ 0x3ad8025f)).nextInt(10) == 0;
			fontRenderer.drawStringWithShadow((slime && minecraft.thePlayer.dimension == 0) ? "@Slime" : "", fontRenderer.getStringWidth(d + biomeGenBase.biomeName), -27, 0xcc00ff00);
		}
		fontRenderer.drawStringWithShadow(String.format("M:%s A:%s I:%s", mod.entityCountMob, mod.entityCountAnimal, mod.entityCountItem), 2, -18, 0xcc999999);
		fontRenderer.drawStringWithShadow(String.format("X:%d Z:%d Y:%d", x, z, y), 2, -9, color2);
		GL11.glDisable(3042 /*GL_BLEND*/);
		GL11.glPopMatrix();
	}

	public void drawScouterStatus(Minecraft minecraft, String s1, String s2, String s3)
	{
		FontRenderer fontRenderer = minecraft.fontRenderer;
		ScaledResolution scaledResolution = new ScaledResolution(minecraft.gameSettings, minecraft.displayWidth, minecraft.displayHeight);
		int w = scaledResolution.getScaledWidth();
		int h = scaledResolution.getScaledHeight();
		GL11.glPushMatrix();
		GL11.glTranslatef(w, h, 0.0F);
		GL11.glEnable(3042 /*GL_BLEND*/);
		GL11.glBlendFunc(770, 771);
		fontRenderer.drawStringWithShadow(s1, -fontRenderer.getStringWidth(s1) - 2, -27, mod.lockonColorInt);
		fontRenderer.drawStringWithShadow(s2, -fontRenderer.getStringWidth(s2) - 2, -18, 0xccffffff);
		fontRenderer.drawStringWithShadow(s3, -fontRenderer.getStringWidth(s3) - 2, -9, 0xccffffff);
		GL11.glDisable(3042 /*GL_BLEND*/);
		GL11.glPopMatrix();
	}

	@Override
	public void doRender(Entity entity, double d, double d1, double d2, float f, float f1)
	{
		if(mod_Scouter.power)
		{
			drawScouter(renderManager.viewerPosX, renderManager.viewerPosY, renderManager.viewerPosZ);
		}
	}

	@Override
	protected ResourceLocation getEntityTexture(Entity entity) {
		return mod.circleTexturePass;
	}
}
