package scouter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

import org.lwjgl.input.Keyboard;

import cpw.mods.fml.client.registry.RenderingRegistry;


public class Scouter
{
	public final mod_Scouter mod;
	public final String modName = this.getClass().getSimpleName();
	public EntityScouter entity;
	public RenderScouter render;
	public ResourceLocation sightTexturePass = new ResourceLocation("textures/sight.png");
	public ResourceLocation circleTexturePass = new ResourceLocation("textures/circle.png");
	private World lastWorld = null;
	private boolean ctrl;
	private final String[] modeName = {
		"Item",
		"Animal",
		"ID",
		"Type",
		"Scouter"
	};
	public EntityLiving targetEntity = null;
	public List<EntityLiving> lockonEntityList = new ArrayList<EntityLiving>();
	public List<MovingObjectPosition> lockonBlockList = new ArrayList<MovingObjectPosition>();
	public MovingObjectPosition targetBlock = null;
	public String enemy = null;
	public boolean addLockonEntity;
	public boolean addLockonBlock;
	public boolean looking;
	public int lockonId;
	public int lockonBlockIndex;
//	public int entityCountAll;
	public int entityCountMob;
	public int entityCountAnimal;
	public int entityCountItem;
	public int lockonColorInt;
	public long timer;
	public float tick;
	public float count;
	public float lockonColor_R;
	public float lockonColor_G;
	public float lockonColor_B;
	public float lockonColor_A;

	public Scouter(mod_Scouter mod)
	{
		this.mod = mod;
		render = new RenderScouter(this);
		addRenderer();
	}

	public void load()
	{
		if(java.util.regex.Pattern.matches("0x\\w\\w\\w\\w\\w\\w\\w\\w", mod_Scouter.lockonColor))
		{
			long lockonColorLong = Long.decode(mod_Scouter.lockonColor);
			lockonColorInt = (int)lockonColorLong;
		} else
		{
			lockonColorInt = 0xcc66ff99;
		}
		lockonColor_A = ((lockonColorInt & 0xff000000) >>> 24) / 255.0F;
		lockonColor_R = ((lockonColorInt & 0x00ff0000) >> 16) / 255.0F;
		lockonColor_G = ((lockonColorInt & 0x0000ff00) >> 8) / 255.0F;
		lockonColor_B = ((lockonColorInt & 0x000000ff) >> 0) / 255.0F;
//		System.out.println("[" + modName + "] LockonColor : 0x" + Integer.toHexString(lockonColorInt));
		addRendererForFML();
	}

	private void addRendererForFML()
	{
		try
		{
			Class clazz = Class.forName("cpw.mods.fml.common.Loader");
			Map<Class<? extends Entity>, Render> renderers = new java.util.HashMap<Class<? extends Entity>, Render>();
			for(Entry<Class<? extends Entity>, Render> e : renderers.entrySet())
			{
				cpw.mods.fml.client.registry.RenderingRegistry.registerEntityRenderingHandler(e.getKey(), e.getValue());
			}
		}
		catch(ClassNotFoundException e)
		{
			System.out.println("[" + modName + "] ForgeModLoader not found. Use ModLoader.");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}

	public void addRenderer()
	{
		RenderingRegistry.registerEntityRenderingHandler(EntityScouter.class, render);
	}

	public boolean onTickInGame(float f, Minecraft minecraft)
	{
		if(minecraft.theWorld != lastWorld)
		{
			resetScouter(minecraft);
		}
		tick = f;
		if(minecraft.currentScreen == null && !minecraft.gameSettings.hideGUI)
		{
			if(mod_Scouter.power)
			{
				if(mod_Scouter.lockon)
				{
					if(Keyboard.isKeyDown(ClientKeyHandler.kbControl.getKeyCode()))
					{
						if(mod_Scouter.lockonBlock)
						{
							lockonBlock(targetBlock);
						} else
						{
							lockonEntity(targetEntity);
						}
					}
					if(ctrl && !Keyboard.getEventKeyState() && !Keyboard.isKeyDown(ClientKeyHandler.kbControl.getKeyCode()))
					{
						if(mod_Scouter.lockonBlock)
						{
							if(addLockonBlock)
							{
								lockonBlockIndex = lockonBlockList.size() - 1;
							} else
							{
								removeLockonBlock(targetBlock);
							}
						} else
						{
							if(addLockonEntity)
							{
								lockonId = getLockonEntityId();
							} else
							{
								removeLockonEntity(targetEntity);
							}
						}
						addLockonBlock = false;
						addLockonEntity = false;
						ctrl = false;
					}
				}
				if(!minecraft.gameSettings.showDebugInfo)
				{
					if((mod_Scouter.lockon && !mod_Scouter.lockonBlock && targetEntity != null) || (mod_Scouter.lockonBlock && (targetBlock != null || !lockonBlockList.isEmpty())))
					{
						render.drawScouterTargetStatus(minecraft);
					}
					if(mod_Scouter.alert && enemy != null)
					{
						render.drawScouterAlert(minecraft);
					}
					if(mod_Scouter.coordinate)
					{
						render.drawScouterCoordinate(minecraft);
					}
				}
				if(count >= 0)
				{
					render.drawScouterStatus(minecraft, (mod_Scouter.lockon ? "LockOnMode" : "") + (mod_Scouter.lockonBlock ? "[+Block]" : ""), "Alert : " + (mod_Scouter.alert ? "ON" : "OFF"), String.format("Mode%d : %s [%d]", mod_Scouter.mode + 1, modeName[mod_Scouter.mode], mod_Scouter.range));
					count -= f;
				}
			} else
			{
				if(count >= 0)
				{
					render.drawScouterStatus(minecraft, "", "", "Scouter : OFF");
					count -= f;
				}
			}
		}
		return true;
	}

	private void removeLockonEntity(EntityLiving obj) {
		if(!lockonEntityList.isEmpty())
		{
			boolean flag = true;
			if(lockonEntityList.contains(obj) && looking)
			{
				if(lockonEntityList.size() >= 2)
				{
					int i = lockonEntityList.indexOf(targetEntity);
					int j = lockonEntityList.get(i).getEntityId();
					lockonEntityList.remove(i);
					if(lockonId == j)
					{
						lockonId = lockonEntityList.get(0).getEntityId();
						targetEntity = lockonEntityList.get(0);
					}
					flag = false;
				}
			}
			if(flag)
			{
				lockonEntityList.clear();
			}
		}
	}

	private int getLockonEntityId() {
		if(lockonId == 0)
		{
			if(lockonEntityList.size() > 1)
			{
				return lockonEntityList.get(0).getEntityId();
			} else
			{
				if(targetEntity != null)
				{
					return targetEntity.getEntityId();
				}
			}
		}
		return 0;
	}

	private void lockonEntity(EntityLiving target) {
		if(target != null)
		{
			boolean flag = isLockonEntity(targetEntity);
			if(flag)
			{
				lockonEntityList.add(targetEntity);
				addLockonEntity = true;
			}
		}
	}

	private void lockonBlock(MovingObjectPosition target) {
		if(target != null)
		{
			boolean flag = isLockonBlock(targetBlock);
			if(flag == false)
			{
				lockonBlockList.add(targetBlock);
				addLockonBlock = true;
			}
		}
	}

	private void removeLockonBlock(MovingObjectPosition obj) {
		if(obj != null)
		{
			if(!lockonBlockList.isEmpty())
			{
				for(int i = 0; i < lockonBlockList.size(); i++)
				{
					if(lockonBlockList.get(i).blockX == obj.blockX && lockonBlockList.get(i).blockY == targetBlock.blockY && lockonBlockList.get(i).blockZ == targetBlock.blockZ)
					{
						lockonBlockList.remove(i);
						if(lockonBlockIndex > 0)
						{
							lockonBlockIndex--;
						} else
						{
							lockonBlockIndex = 0;
						}
						break;
					}
				}
			}
		} else
		{
			lockonBlockList.clear();
		}
	}

	private boolean isLockonEntity(Entity entity) {
		boolean flag = true;
		for(EntityLiving temp : lockonEntityList)
		{
			if(temp.getEntityId() == entity.getEntityId())
			{
				flag = false;
				break;
			}
		}
		return flag;
	}

	private boolean isLockonBlock(MovingObjectPosition obj) {
		boolean flag = false;
		for(MovingObjectPosition temp : lockonBlockList)
		{
			if(temp.blockX == obj.blockX && temp.blockY == obj.blockY && temp.blockZ == obj.blockZ)
			{
				flag = true;
			}
		}
		return flag;
	}

	private void resetScouter(Minecraft minecraft) {
		entity = new EntityScouter(minecraft, minecraft.theWorld);
        if(entity == null) {
            return;
        }
        if(minecraft == null) {
            return;
        }
        if(minecraft.thePlayer == null) {
            return;
        }
		entity.setPosition(minecraft.thePlayer.posX, minecraft.thePlayer.posY - minecraft.thePlayer.height, minecraft.thePlayer.posZ);
		minecraft.theWorld.spawnEntityInWorld(entity);
		lastWorld = minecraft.theWorld;
		addLockonBlock = false;
		addLockonEntity = false;
		lockonBlockIndex = 0;
		lockonBlockList.clear();
		targetBlock = null;
		lockonId = 0;
		lockonEntityList.clear();
		targetEntity = null;
		if(mod_Scouter.power)
		{
			setCount();
		}
		timer = System.currentTimeMillis();
	}

	public void keyboardEvent(KeyBinding keyBinding)
	{
		Minecraft minecraft = Minecraft.getMinecraft();
		if(!keyBinding.isPressed() || minecraft.currentScreen != null || minecraft.gameSettings.hideGUI)
		{
			//return;
		}
		if(keyBinding.getKeyCode() == ClientKeyHandler.kbPower.getKeyCode())
		{
			togglePower();
			setCount();
		}
		ctrl = false;
		if(mod_Scouter.power)
		{
			if(keyBinding.getKeyCode() == ClientKeyHandler.kbModeUp.getKeyCode())
			{
				if(Keyboard.isKeyDown(ClientKeyHandler.kbControl.getKeyCode()))
				{
					if(mod_Scouter.lockon)
					{
						if(mod_Scouter.lockonBlock)
						{
							nextLockonBlock();
						} else
						{
							nextLockonEntity();
						}
					}
				} else
				{
					modeUp();
					setCount();
				}
			}
			if(keyBinding.getKeyCode() == ClientKeyHandler.kbModeDown.getKeyCode())
			{
				if(Keyboard.isKeyDown(ClientKeyHandler.kbControl.getKeyCode()))
				{
					if(mod_Scouter.lockon)
					{
						if(mod_Scouter.lockonBlock)
						{
							prevLockonBlock();
						} else
						{
							prevLockonEntity();
						}
					}
				} else
				{
					modeDown();
					setCount();
				}
			}
			if(keyBinding.getKeyCode() == ClientKeyHandler.kbRangeUp.getKeyCode())
			{
				if(Keyboard.isKeyDown(ClientKeyHandler.kbControl.getKeyCode()))
				{
					if(mod_Scouter.range < 256) {
						rangeUp();
						setCount();
					}
				}
			}
			if(keyBinding.getKeyCode() == ClientKeyHandler.kbRangeDown.getKeyCode())
			{
				if(Keyboard.isKeyDown(ClientKeyHandler.kbControl.getKeyCode()))
				{
					if(mod_Scouter.range > 0) {
						rangeDown();
						setCount();
					}
				}
			}
			if(keyBinding.getKeyCode() == ClientKeyHandler.kbControl.getKeyCode())
			{
				ctrl = true;
			}
			if(keyBinding.getKeyCode() == ClientKeyHandler.kbAlert.getKeyCode())
			{
				//if(Keyboard.isKeyDown(mod_Scouter.cfg_Control))
				{
					toggleAlert();
					setCount();
				}
			}
			if(keyBinding.getKeyCode() == ClientKeyHandler.kbCoordinate.getKeyCode())
			{
				//if(Keyboard.isKeyDown(mod_Scouter.cfg_Control))
				{
					toggleCoordinate();
				}
			}
		}
	}

	private void togglePower() {
		if(mod_Scouter.power)
		{
			if(mod_Scouter.lockon)
			{
				if(mod_Scouter.lockonBlock)
				{
					mod_Scouter.lockonBlock = false;
					mod_Scouter.lockon = false;
					mod_Scouter.power = false;
				} else
				{
					mod_Scouter.lockonBlock = true;
				}
			} else
			{
				mod_Scouter.lockon = true;
			}
		} else
		{
			mod_Scouter.power = true;
		}
	}

	private void prevLockonEntity() {
		if(!lockonEntityList.isEmpty())
		{
			int lockonIndex;
			if(lockonEntityList.indexOf(targetEntity) == 0)
			{
				lockonIndex = lockonEntityList.size() - 1;
			} else
			{
				lockonIndex = lockonEntityList.indexOf(targetEntity);
			}
			for(int i = lockonIndex; i >= 0; i--)
			{
				if(lockonEntityList.get(i).getEntityId() != lockonId)
				{
					lockonId = lockonEntityList.get(i).getEntityId();
					targetEntity = lockonEntityList.get(i);
					break;
				}
			}
		}
	}

	private void nextLockonEntity() {
		if(!lockonEntityList.isEmpty())
		{
			int lockonIndex;
			if(lockonEntityList.indexOf(targetEntity) == lockonEntityList.size() - 1)
			{
				lockonIndex = 0;
			} else
			{
				lockonIndex = lockonEntityList.indexOf(targetEntity);
			}
			for(int i = lockonIndex; i < lockonEntityList.size(); i++)
			{
				if(lockonEntityList.get(i).getEntityId() != lockonId)
				{
					lockonId = lockonEntityList.get(i).getEntityId();
					targetEntity = lockonEntityList.get(i);
					break;
				}
			}
		}
	}

	private void prevLockonBlock() {
		if(!lockonBlockList.isEmpty())
		{
			if(lockonBlockIndex > 0)
			{
				lockonBlockIndex--;
			} else
			{
				lockonBlockIndex = lockonBlockList.size() - 1;
			}
		}
	}

	private void nextLockonBlock() {
		if(!lockonBlockList.isEmpty())
		{
			if(lockonBlockIndex < lockonBlockList.size() - 1)
			{
				lockonBlockIndex++;
			} else
			{
				lockonBlockIndex = 0;
			}
		}
	}

	private void modeUp() {
		if(mod_Scouter.mode < modeName.length - 1)
		{
			mod_Scouter.mode++;
		} else
		{
			mod_Scouter.mode = 0;
		}
	}

	private void modeDown() {
		if(mod_Scouter.mode > 0)
		{
			mod_Scouter.mode--;
		} else
		{
			mod_Scouter.mode = modeName.length - 1;
		}
	}

	private void rangeUp() {
		if(mod_Scouter.range == 0)
		{
			mod_Scouter.range = 16;
		} else
		if(mod_Scouter.range < 32)
		{
			mod_Scouter.range += 16;
		} else
		if(mod_Scouter.range < 256)
		{
			if(mod_Scouter.range + 32 >= 256)
			{
				mod_Scouter.range = 256;
			} else
			{
				mod_Scouter.range += 32;
			}
		}
	}

	private void rangeDown() {
		if(mod_Scouter.range > 32)
		{
			mod_Scouter.range -= 32;
		} else
		if(mod_Scouter.range > 16)
		{
			mod_Scouter.range -= 16;
		} else
		if(mod_Scouter.range > 0)
		{
			mod_Scouter.range = 0;
		}
	}

	private void toggleAlert() {
		if(mod_Scouter.alert)
		{
			mod_Scouter.alert = false;
		} else
		{
			mod_Scouter.alert = true;
		}
	}

	private void toggleCoordinate() {
		if(mod_Scouter.coordinate)
		{
			mod_Scouter.coordinate = false;
		} else
		{
			mod_Scouter.coordinate = true;
		}
	}

	private void setCount()
	{
		count = 200.0F;
	}
}
