package scouter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.ReflectionHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.EntityPlayer;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.EventHandler;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

@Mod(modid = mod_Scouter.modid, name = mod_Scouter.modid, version = "1.6.2.1")
public class mod_Scouter
{
	public static final String modid = "Scouter";
	
	@SidedProxy(clientSide = "scouter.ClientProxy", serverSide = "scouter.CommonProxy")
	public static CommonProxy proxy;
	
	@Instance("mod_Scouter")
	public static mod_Scouter instance;

	private final String entityToAttack = "func_70782_k";
	private String getDropItem = "func_146068_u";
    private String experienceValue = "field_70728_aV";
	private final Scouter mod;

	@EventHandler
	public void init(FMLInitializationEvent event) {
		proxy.init();
	}
	@EventHandler
	public void preInit(FMLPreInitializationEvent event) {
		instance = this;
		mod.load();
        Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
        try {
            cfg.load();
            power = cfg.get(Configuration.CATEGORY_GENERAL, "power", false, "[Power] true:ON / false:OFF").getBoolean(false);
            lockon = cfg.get(Configuration.CATEGORY_GENERAL, "lockon", false, "[LockonMode] true:ON / false:OFF").getBoolean(false);
            lockonBlock = cfg.get(Configuration.CATEGORY_GENERAL, "lockonBlock", false, "[LockonMode+Block] true:ON / false:OFF").getBoolean(false);
            alert = cfg.get(Configuration.CATEGORY_GENERAL, "alert", false, "[AlertDisplay] true:ON / false:OFF").getBoolean(false);
            coordinate = cfg.get(Configuration.CATEGORY_GENERAL, "coordinate", false, "[CoordinateDisplay] true:ON / false:OFF").getBoolean(false);
            mode = cfg.get(Configuration.CATEGORY_GENERAL, "mode", 2, "[StartupMode] 0:Item / 1:Animal / 2:ID / 3:Type / 4:Scouter").getInt();
            range = cfg.get(Configuration.CATEGORY_GENERAL, "range", 64, "[ScanRange] 0 - 256").getInt();
            stringDisplayRange = cfg.get(Configuration.CATEGORY_GENERAL, "stringDisplayRange", 64, "[StringDisplayRange] 0 - 256").getInt();
            targetStatusPosition = cfg.get(Configuration.CATEGORY_GENERAL, "targetStatusPosition", 4, "[TargetStatusPosition] 0:Center / 1:UpperLeft / 2:LowerLeft / 3:UpperRight / 4:LowerRight").getInt();
            targetStatus_X = cfg.get(Configuration.CATEGORY_GENERAL, "targetStatus_X", 0, "[TargetStatusCustomCoordinateX] Difference from the current position").getInt();
            targetStatus_Y = cfg.get(Configuration.CATEGORY_GENERAL, "targetStatus_Y", 0, "[TargetStatusCustomCoordinateY] Difference from the current position").getInt();
            lockonColor = cfg.get(Configuration.CATEGORY_GENERAL, "lockonColor", "0xcc66ff99", "[LockonColor] 0x[(Alpha)cc(Red)66(Green)ff(Blue)99]").getString();
            cfg_Power = cfg.get(Configuration.CATEGORY_GENERAL, "cfg_Power", 62, "F4 -> http://lwjgl.org/javadoc/constant-values.html#org.lwjgl.input.Keyboard.CHAR_NONE").getInt();
            cfg_Control = cfg.get(Configuration.CATEGORY_GENERAL, "cfg_Control", 29, "L_Control").getInt();
            cfg_ModeUp = cfg.get(Configuration.CATEGORY_GENERAL, "cfg_ModeUp", 205, "Right").getInt();
            cfg_ModeDown = cfg.get(Configuration.CATEGORY_GENERAL, "cfg_ModeDown", 203, "Left").getInt();
            cfg_RangeUp = cfg.get(Configuration.CATEGORY_GENERAL, "cfg_RangeUp", 200, "Up").getInt();
            cfg_RangeDown = cfg.get(Configuration.CATEGORY_GENERAL, "cfg_RangeDown", 208, "Down").getInt();
            cfg_Alert = cfg.get(Configuration.CATEGORY_GENERAL, "cfg_Alert", 157, "R_Control").getInt();
            cfg_Coordinate = cfg.get(Configuration.CATEGORY_GENERAL, "cfg_Coordinate", 54, "R_Shift").getInt();
            cfg.save();
        } catch (Exception e) {
            FMLLog.log(Level.ERROR, e, this.modid + " load config exception");
        } finally {
            cfg.save();
        }
	}

	public mod_Scouter()
	{
		mod = new Scouter(this);
	}

	public boolean onTickInGame(float f, Minecraft minecraft)
	{
		return mod.onTickInGame(f, minecraft);
	}
/*
	@Override
	public boolean onTickInGUI(float f, Minecraft minecraft, GuiScreen gui)
	{
		return mod.onTickInGUI(f, minecraft, gui);
	}
*/
	public void keyboardEvent(KeyBinding keybinding)
	{
		mod.keyboardEvent(keybinding);
	}

	public List<String> getEntityAItasks(EntityLiving entityliving)
	{
		List<EntityAITasks.EntityAITaskEntry> tasks = new ArrayList<EntityAITasks.EntityAITaskEntry>();
		List<EntityAITasks.EntityAITaskEntry> targetTasks = new ArrayList<EntityAITasks.EntityAITaskEntry>();
		try
		{
            //ObfuscationReflectionHelper.remapFieldNames()
			tasks = (ArrayList<EntityAITasks.EntityAITaskEntry>)ObfuscationReflectionHelper.getPrivateValue(EntityAITasks.class, entityliving.tasks, 1);//field_75780_b
			String[] fields = ObfuscationReflectionHelper.remapFieldNames("EntityLiving", "targetTasks");
			EntityAITasks t = (EntityAITasks)ObfuscationReflectionHelper.getPrivateValue(EntityLiving.class, entityliving, fields[0]);//"field_70715_bh", targetTasks
			targetTasks = (ArrayList<EntityAITasks.EntityAITaskEntry>)ObfuscationReflectionHelper.getPrivateValue(EntityAITasks.class, t, 1);//field_75780_b
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		tasks.addAll(targetTasks);
		List<String> ai = new ArrayList<String>();
		int size = tasks.size();
		for(int i = 0; i < size; i++)
		{
			String s;
			s = tasks.get(i).action.getClass().getSimpleName().toString();
			if(this.getClass().getPackage() == null)
			{
				s = mod.render.entityAImap.get(s);
			} else
			{
				s = s.substring(8);
			}
			ai.add(s);
		}
		return ai;
	}

	public Item getDropItem(EntityLiving entityliving)
	{
		try {
			Method m = EntityLiving.class.getDeclaredMethod(getDropItem);//getDropItem
			m.setAccessible(true);
			return (Item) m.invoke(entityliving, new Object[]{});
		} catch (NoSuchMethodException e) {
			getDropItem = "getDropItem";
		} catch (SecurityException e) {
			e.printStackTrace();
		}
		catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
		return null;
	}

	public int getExperiencePoints(EntityLiving entityliving, EntityPlayer entityplayer)
	{
        int exp = 0;
        try
        {
            exp = ObfuscationReflectionHelper.getPrivateValue(EntityLiving.class, entityliving, "experienceValue", "field_70728_aV");
        } catch (ReflectionHelper.UnableToFindFieldException e) {
            exp = -2;
        } catch (ReflectionHelper.UnableToAccessFieldException e) {
            exp = -3;
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
        return exp;
	}

	public static boolean power = false;
	public static boolean lockon = false;
	public static boolean lockonBlock = false;
	public static boolean alert = false;
	public static boolean coordinate = false;
	public static int mode = 2;
	public static int range = 64;
	public static int stringDisplayRange = 64;
	public static int targetStatusPosition = 4;
	public static int targetStatus_X = 0;
	public static int targetStatus_Y = 0;
	public static String lockonColor = "0xcc66ff99";

	public static int cfg_Power = 62;//F4
	public static int cfg_Control = 29;//L_Control
	public static int cfg_ModeUp = 205;//Right
	public static int cfg_ModeDown = 203;//Left
	public static int cfg_RangeUp = 200;//Up
	public static int cfg_RangeDown = 208;//Down
	public static int cfg_Alert = 157;//R_Control
	public static int cfg_Coordinate = 54;//R_Shift
}
