package tsuteto.snowsdeeper;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.common.config.Configuration;

/**
 * The Main Class of Snows Deeper
 *
 * @author Tsuteto
 *
 */
@Mod(modid = SnowsDeeper.modid, name = "Snows Deeper", version = "1.1.0-MC1.7.2")
public class SnowsDeeper
{
    public static final String modid = "SnowsDeeper";

    @Mod.Instance(modid)
    public static SnowsDeeper instance;

    public static int snowRate = 3;
    public static int maxSnowDepth = 40;
    public static boolean debug = false;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event)
    {
        ModLog.mod = this.getClass();

        Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
        cfg.load();

        snowRate = cfg.get("general", "snowRate", snowRate,
                "Speed rate getting the snow deeper. The less the faster. 1 is the fastest.").getInt();
        if (snowRate < 1) snowRate = 1;

        double maxSnowDepthMeter = cfg.get("general", "maxSnowDepth", 5.0D,
                "Max snow depth. The unit is block in increments of 0.125. 0 for disabling this MOD.").getDouble(5.0D);
        maxSnowDepth  = (int)(maxSnowDepthMeter * 8.0D);

        debug = cfg.get("general", "debug", debug).getBoolean(false);

        cfg.save();

        ModLog.isDebug = debug;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event)
    {
    }
}
