/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world;

import aroma1997.core.client.util.Colors;
import aroma1997.core.config.Conf;
import aroma1997.core.log.LogHelperPre;
import aroma1997.core.util.AromaRegistry;
import aroma1997.core.version.VersionCheck;
import aroma1997.world.BiomeGenMining;
import aroma1997.world.CommonProxy;
import aroma1997.world.CreativeTabDW;
import aroma1997.world.DimensionChanger;
import aroma1997.world.MiningPortal;
import aroma1997.world.PortalFrame;
import aroma1997.world.PortalIgniter;
import aroma1997.world.Reference;
import aroma1997.world.StickyOre;
import aroma1997.world.WorldProviderMining;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="Aroma1997sDimension", name="Aroma1997's Dimensional World", dependencies="required-after:Aroma1997Core")
public class DimensionalWorld {
    @Mod.Instance(value="Aroma1997sDimension")
    public static DimensionalWorld instance;
    @SidedProxy(clientSide="aroma1997.world.client.ClientProxy", serverSide="aroma1997.world.CommonProxy")
    public static CommonProxy proxy;
    public static int dimension;
    public static int biomeID;
    private static boolean enableMSG;
    private static String sendMSG;
    public static boolean spawnMonsters;
    public static boolean spawnAnimals;
    public static Block aromicPortal;
    public static Block portalFrame;
    public static Item portalIgniter;
    public static Block stickyOre;
    public static Item dimensionChanger;
    public static boolean generateStickyOre;
    public static int height;
    public static CreativeTabs creativeTabDW;
    public static boolean generateDungeons;
    public static boolean generateLakes;
    public static int oreDensity;
    public static BiomeGenMining miningBiome;
    public Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = LogHelperPre.genNewLogger((String)"Aroma1997sDimension");
        Configuration config = Conf.getConfig((String)"Aroma1997sDimension");
        config.load();
        Property dimensionProp = config.get("general", "DimensionID", 6);
        dimensionProp.comment = "The Mining World will have this dimension ID.";
        dimension = dimensionProp.getInt(6);
        Property biomeProp = config.get("general", "BiomeID", 47);
        biomeProp.comment = "The Mining Biome will have this ID.";
        biomeID = biomeProp.getInt(47);
        Property generateStickyOreProp = config.get("general", "enableStickyOre", true);
        generateStickyOreProp.comment = "If Sticky ore is generated in the Mining World";
        generateStickyOre = generateStickyOreProp.getBoolean(true);
        Property enableMSGProp = config.get("general", "enableTextMessageOnDimension", false);
        enableMSGProp.comment = "If a Message is sent to a Player, every time he enters the Mining World and the message. Only makes sense on a server.";
        enableMSG = enableMSGProp.getBoolean(false);
        Property sendMSGProp = config.get("general", "Message", "Aroma1997 wishes you good luck on your mining expedition.");
        sendMSGProp.comment = "The Message that will be sent.";
        sendMSG = sendMSGProp.getString();
        Property generateDungeonsProp = config.get("general", "enableVanillaDungeansGeneration", false);
        generateDungeonsProp.comment = "If Vanilla Dungeons will spawn in the Mining World.";
        generateDungeons = generateDungeonsProp.getBoolean(false);
        Property generateLakesProp = config.get("general", "enableVanillaLakesGeneration", false);
        generateLakesProp.comment = "If Vanilla Lakes are generated in the Mining World.";
        generateLakes = generateLakesProp.getBoolean(false);
        oreDensity = config.get("general", "oreDensity", 1, "OreDensity defines how many ores are spawned in the Mining World. 0 means no ores are generated. 1 means default, 2 means twice as much as normal,...").getInt();
        Property spawnMonstersProp = config.get("general", "spawnMonsters", false);
        spawnMonstersProp.comment = "If Monsters Spawn in the Mining World.";
        spawnMonsters = spawnMonstersProp.getBoolean(false);
        Property spawnAnimalsProp = config.get("general", "spawnAnimals", false);
        spawnAnimalsProp.comment = "If Animals spawn in the Mining World.";
        spawnAnimals = spawnAnimalsProp.getBoolean(false);
        height = config.get("general", "worldHeight", 80, "The height of the Mining World").getInt();
        Property generateOverworld = config.get("general", "generateOverworld", false);
        generateOverworld.comment = "This defines if it will simulate the world during the OrePopulation as if it would be the overworld. NOTE: THIS MAY CAUSE ISSUES(it shouldn't) WITH YOUR WORLD SAVE!!!!!!!";
        config.save();
        aromicPortal = new MiningPortal();
        GameRegistry.registerBlock((Block)aromicPortal, (String)"aromicPortal");
        portalFrame = new PortalFrame();
        GameRegistry.registerBlock((Block)portalFrame, (String)"portalFrame");
        stickyOre = new StickyOre();
        GameRegistry.registerBlock((Block)stickyOre, (String)"stickyOre");
        portalIgniter = new PortalIgniter();
        GameRegistry.registerItem((Item)portalIgniter, (String)"PortalIgniter");
        dimensionChanger = new DimensionChanger();
        GameRegistry.registerItem((Item)dimensionChanger, (String)"DimensionChanger");
        OreDictionary.registerOre((String)"brickStone", (Block)portalFrame);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        miningBiome = new BiomeGenMining(biomeID);
        ItemStack igniter = new ItemStack(portalIgniter, 1, Short.MAX_VALUE);
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(dimensionChanger), (boolean)false, (Object[])new Object[]{"DED", "PIP", "DED", Character.valueOf('D'), new ItemStack(Items.field_151045_i), Character.valueOf('E'), new ItemStack(Items.field_151061_bv), Character.valueOf('P'), new ItemStack(Items.field_151079_bi), Character.valueOf('I'), igniter});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(dimensionChanger), (boolean)false, (Object[])new Object[]{"DPD", "EIE", "DPD", Character.valueOf('D'), new ItemStack(Items.field_151045_i), Character.valueOf('E'), new ItemStack(Items.field_151061_bv), Character.valueOf('P'), new ItemStack(Items.field_151079_bi), Character.valueOf('I'), igniter});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(portalIgniter), (boolean)false, (Object[])new Object[]{"xwx", " y ", " z ", Character.valueOf('x'), new ItemStack(Blocks.field_150417_aV, 1, Short.MAX_VALUE), Character.valueOf('w'), new ItemStack(Items.field_151033_d), Character.valueOf('y'), new ItemStack(Items.field_151050_s), Character.valueOf('z'), "stickWood"});
        AromaRegistry.registerShapelessAromicRecipe((ItemStack)new ItemStack(portalFrame), (boolean)false, (Object[])new Object[]{igniter, new ItemStack(Blocks.field_150417_aV, 1, Short.MAX_VALUE)});
        if (DimensionManager.isDimensionRegistered((int)dimension)) {
            this.logger.log(Level.ERROR, "Failed to register the Mining Dimension with the ID " + dimension + ". Please pick another one!");
        }
        DimensionManager.registerProviderType((int)dimension, WorldProviderMining.class, (boolean)false);
        DimensionManager.registerDimension((int)dimension, (int)dimension);
        FMLInterModComms.sendMessage((String)"BuildCraft|Energy", (String)"oil-gen-exclude", (String)(DimensionalWorld.miningBiome.field_76756_M + ""));
        BiomeManager.addStrongholdBiome((BiomeGenBase)miningBiome);
        BiomeDictionary.registerBiomeType((BiomeGenBase)miningBiome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN});
        VersionCheck.registerVersionChecker((String)"Aroma1997sDimension".replace(" ", ""), (String)Reference.VERSION);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        miningBiome.clearMonsters();
        this.logger.log(Level.INFO, "Loaded.");
        this.logger.log(Level.TRACE, "Dimension registered with ID: " + dimension + ".");
    }

    public static String getWorldMessage() {
        String msg = Colors.applyColors((String)sendMSG);
        if (enableMSG) {
            return msg;
        }
        return null;
    }

    static {
        creativeTabDW = new CreativeTabDW("Aroma1997sDimension".toLowerCase() + ":creativeTabDW");
    }
}

