/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.explodables.entity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import uk.co.stealthware.explodables.Explodables;
import uk.co.stealthware.explodables.entity.EntityDirectionalExplosive;

public class EntitySpokeBombPrimed
extends EntityDirectionalExplosive {
    private static Explosion FAKE_EXPLOSION = new Explosion(null, null, 0.0, 0.0, 0.0, 0.0f);

    public EntitySpokeBombPrimed(World world) {
        super(world);
    }

    public EntitySpokeBombPrimed(World world, double d, double d1, double d2, int dir) {
        super(world, d, d1, d2, dir);
    }

    @Override
    protected void explode() {
        this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "random.explode", 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        int explosionSize = Explodables.spokeBombPower - 1;
        int startX = 0;
        int endX = 0;
        int startY = 0;
        int endY = 0;
        int startZ = 0;
        int endZ = 0;
        switch (this.direction) {
            case 0: {
                startX = -1;
                endX = 1;
                startY = 0;
                endY = explosionSize;
                startZ = -1;
                endZ = 1;
                break;
            }
            case 1: {
                startX = -1;
                endX = 1;
                startY = -explosionSize;
                endY = 0;
                startZ = -1;
                endZ = 1;
                break;
            }
            case 2: {
                startX = -1;
                endX = 1;
                startY = -1;
                endY = 1;
                startZ = 0;
                endZ = explosionSize;
                break;
            }
            case 3: {
                startX = -1;
                endX = 1;
                startY = -1;
                endY = 1;
                startZ = -explosionSize;
                endZ = 0;
                break;
            }
            case 4: {
                startX = 0;
                endX = explosionSize;
                startY = -1;
                endY = 1;
                startZ = -1;
                endZ = 1;
                break;
            }
            case 5: {
                startX = -explosionSize;
                endX = 0;
                startY = -1;
                endY = 1;
                startZ = -1;
                endZ = 1;
            }
        }
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    int newMeta;
                    int i1 = (int)(this.field_70165_t - 0.5) + x;
                    int j1 = (int)this.field_70163_u + y;
                    int k1 = (int)(this.field_70161_v - 0.5) + z;
                    Block block = this.field_70170_p.func_147439_a(i1, j1, k1);
                    this.field_70170_p.func_72869_a("explode", (double)i1, (double)j1, (double)k1, 0.0, 0.0, 0.0);
                    this.field_70170_p.func_72869_a("smoke", (double)i1, (double)j1, (double)k1, 0.0, 0.0, 0.0);
                    if (block == Blocks.field_150350_a || this.field_70170_p.field_72995_K || !(block.func_149638_a(null) < 150.0f)) continue;
                    block.func_149690_a(this.field_70170_p, i1, j1, k1, this.field_70170_p.func_72805_g(i1, j1, k1), 0.5f, 0);
                    block.onBlockExploded(this.field_70170_p, i1, j1, k1, FAKE_EXPLOSION);
                    if (!(this.direction != 2 && this.direction != 3 || x != startX && x != endX && y != startY && y != endY)) {
                        newMeta = 0;
                        if (x == startX && y == startY) {
                            newMeta = 6;
                        } else if (x == startX && y == endY) {
                            newMeta = 7;
                        } else if (x == endX && y == startY) {
                            newMeta = 8;
                        } else if (x == endX && y == endY) {
                            newMeta = 9;
                        } else if (y == startY) {
                            newMeta = 0;
                        } else if (y == endY) {
                            newMeta = 1;
                        } else if (x == startX) {
                            newMeta = 2;
                        } else if (x == endX) {
                            newMeta = 3;
                        }
                        this.field_70170_p.func_147465_d(i1, j1, k1, Explodables.blockReinforcedIron, newMeta, 3);
                        continue;
                    }
                    if (this.direction != 4 && this.direction != 5 || y != startY && y != endY && z != startZ && z != endZ) continue;
                    newMeta = 0;
                    if (y == startY && z == startZ) {
                        newMeta = 10;
                    } else if (y == startY && z == endZ) {
                        newMeta = 11;
                    } else if (y == endY && z == startZ) {
                        newMeta = 12;
                    } else if (y == endY && z == endZ) {
                        newMeta = 13;
                    } else if (y == startY) {
                        newMeta = 0;
                    } else if (y == endY) {
                        newMeta = 1;
                    } else if (z == startZ) {
                        newMeta = 4;
                    } else if (z == endZ) {
                        newMeta = 5;
                    }
                    this.field_70170_p.func_147465_d(i1, j1, k1, Explodables.blockReinforcedIron, newMeta, 3);
                }
            }
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        float entityExplosionSize = 2.0f;
        int k = MathHelper.func_76128_c((double)(this.field_70165_t - (double)entityExplosionSize - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.field_70165_t + (double)entityExplosionSize + 1.0));
        int k1 = MathHelper.func_76128_c((double)(this.field_70163_u - (double)entityExplosionSize - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.field_70163_u + (double)entityExplosionSize + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.field_70161_v - (double)entityExplosionSize - 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.field_70161_v + (double)entityExplosionSize + 1.0));
        List list = this.field_70170_p.func_72839_b(null, AxisAlignedBB.func_72330_a((double)k, (double)k1, (double)i2, (double)i1, (double)l1, (double)j2));
        Vec3 vec3d = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            Entity entity = (Entity)list.get(k2);
            double d4 = entity.func_70011_f(this.field_70165_t, this.field_70163_u, this.field_70161_v) / (double)entityExplosionSize;
            if (!(d4 <= 1.0)) continue;
            double d6 = entity.field_70165_t - this.field_70165_t;
            double d8 = entity.field_70163_u - this.field_70163_u;
            double d10 = entity.field_70161_v - this.field_70161_v;
            double d11 = MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8 + d10 * d10));
            d6 /= d11;
            d8 /= d11;
            d10 /= d11;
            double d12 = this.field_70170_p.func_72842_a(vec3d, entity.field_70121_D);
            double d13 = (1.0 - d4) * d12;
            entity.func_70097_a(damageSource, (float)((int)((d13 * d13 + d13) / 2.0 * 8.0 * (double)entityExplosionSize + 1.0)));
            double d14 = d13;
            entity.field_70159_w += d6 * d14;
            entity.field_70181_x += d8 * d14;
            entity.field_70179_y += d10 * d14;
        }
    }
}

