/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.explodables;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import uk.co.stealthware.explodables.CommonProxy;
import uk.co.stealthware.explodables.Packet;
import uk.co.stealthware.explodables.PacketHandler;
import uk.co.stealthware.explodables.block.BlockBlastingGel;
import uk.co.stealthware.explodables.block.BlockBreachingCharge;
import uk.co.stealthware.explodables.block.BlockButtonObsidian;
import uk.co.stealthware.explodables.block.BlockClaymoreMine;
import uk.co.stealthware.explodables.block.BlockClaymoreMulti;
import uk.co.stealthware.explodables.block.BlockExplosivesChest;
import uk.co.stealthware.explodables.block.BlockObsidianDoor;
import uk.co.stealthware.explodables.block.BlockPlasticExplosive;
import uk.co.stealthware.explodables.block.BlockReinforcedGlass;
import uk.co.stealthware.explodables.block.BlockReinforcedGlassPane;
import uk.co.stealthware.explodables.block.BlockReinforcedIron;
import uk.co.stealthware.explodables.block.BlockShapedCharge;
import uk.co.stealthware.explodables.block.BlockSpokeBomb;
import uk.co.stealthware.explodables.entity.EntityBreachingChargePrimed;
import uk.co.stealthware.explodables.entity.EntityClaymoreMinePrimed;
import uk.co.stealthware.explodables.entity.EntityShapedChargePrimed;
import uk.co.stealthware.explodables.entity.EntitySpokeBombPrimed;
import uk.co.stealthware.explodables.entity.TileEntityExplosivesChest;
import uk.co.stealthware.explodables.item.ItemBlastingGel;
import uk.co.stealthware.explodables.item.ItemObsidianDoor;
import uk.co.stealthware.minecraft.StealthwareItem;
import uk.co.stealthware.minecraft.StealthwareMod;

@Mod(modid="Explodables", name="Explodables", version="1.9", useMetadata=true)
public class Explodables
extends StealthwareMod
implements IFuelHandler {
    public static int shapedChargeEntityId = 220;
    public static int spokeBombEntityId = 221;
    public static int claymoreMineEntityId = 222;
    public static int breachingChargeEntityId = 223;
    public static float shapedChargePower = 10.0f;
    public static int blastingGelPower = 4;
    public static int highExBlastingGelPower = 8;
    public static int spokeBombPower = 4;
    public static float claymoreMinePower = 8.0f;
    public static float breachingChargePower = 6.0f;
    public static boolean enableNewBlocks = false;
    @SidedProxy(clientSide="uk.co.stealthware.explodables.ClientProxy", serverSide="uk.co.stealthware.explodables.CommonProxy")
    public static CommonProxy proxy;
    public static Explodables instance;
    public static SimpleNetworkWrapper network;
    public static Block blockShapedCharge;
    public static BlockBlastingGel blockBlastingGel;
    public static BlockBlastingGel blockHighExBlastingGel;
    public static Item itemBlastingGel;
    public static Item itemHighExBlastingGel;
    public static Block blockSpokeBomb;
    public static Block blockReinforcedIron;
    public static Item itemMoltenIron;
    public static Item itemScrapIron;
    public static Item itemGelatine;
    public static Block blockPlasticExplosive;
    public static Block blockExplosivesChest;
    public static Block blockObsidianDoor;
    public static Item itemObsidianDoor;
    public static Block blockReinforcedGlass;
    public static Block blockClaymoreMine;
    public static Block blockClaymoreMulti;
    public static Block blockBreachingCharge;
    public static Block blockReinforcedGlassPane;
    public static Block blockObsidianButton;
    public static int modelBlastingGelId;
    public static int modelShapedChargeId;
    public static int modelSpokeBombId;
    public static int modelReinforcedIronId;
    public static int modelExplosivesChestId;
    public static int modelClaymoreMineId;
    public static int modelMultiClaymoreMineId;
    public static int modelBreachingChargeId;

    public Explodables() throws Exception {
        instance = this;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        shapedChargeEntityId = this.config_getEntityId("ShapedCharge", shapedChargeEntityId);
        spokeBombEntityId = this.config_getEntityId("SpokeBomb", spokeBombEntityId);
        claymoreMineEntityId = this.config_getEntityId("ClaymoreMine", claymoreMineEntityId);
        breachingChargeEntityId = this.config_getEntityId("BreachingCharge", breachingChargeEntityId);
        shapedChargePower = this.config_getRangeValue("ShapedChargePower", "Controls size of explosion for Shaped Charges", (int)shapedChargePower, 1, 100);
        blastingGelPower = this.config_getRangeValue("BlastingGelPower", "Controls size of explosion for Blasting Gel (the number of blocks to remove)", blastingGelPower, 1, 20);
        highExBlastingGelPower = this.config_getRangeValue("HighExBlastingGelPower", "Controls size of explosion for High-Ex Blasting Gel (the number of blocks to remove)", highExBlastingGelPower, 1, 30);
        spokeBombPower = this.config_getRangeValue("SpokeBombPower", "Controls size of explosion for Spoke Bombs (the length of the tunnel)", spokeBombPower, 1, 30);
        claymoreMinePower = this.config_getRangeValue("ClaymoreMinePower", "Controls size of explosion for Claymore Mines", (int)claymoreMinePower, 1, 40);
        breachingChargePower = this.config_getRangeValue("BreachingChargePower", "Controls size of explosion for Breaching Charge", (int)breachingChargePower, 1, 40);
        enableNewBlocks = this.config_getEnabled("NewBlocks", "Enables the new blocks added in 1.9. Leave disabled to avoid problem upgrading worlds.", enableNewBlocks);
        this.config.save();
        blockShapedCharge = new BlockShapedCharge(this);
        blockBlastingGel = new BlockBlastingGel(BlockBlastingGel.COLOUR_NORMAL, blastingGelPower, itemBlastingGel);
        blockHighExBlastingGel = new BlockBlastingGel(BlockBlastingGel.COLOUR_HIGHEX, highExBlastingGelPower, itemHighExBlastingGel);
        blockSpokeBomb = new BlockSpokeBomb(this);
        blockReinforcedIron = new BlockReinforcedIron(this);
        blockPlasticExplosive = new BlockPlasticExplosive(this);
        blockExplosivesChest = new BlockExplosivesChest();
        blockObsidianDoor = new BlockObsidianDoor(this);
        blockReinforcedGlass = new BlockReinforcedGlass(this);
        blockClaymoreMine = new BlockClaymoreMine(this);
        blockClaymoreMulti = new BlockClaymoreMulti(this);
        blockBreachingCharge = new BlockBreachingCharge(this);
        blockReinforcedGlassPane = new BlockReinforcedGlassPane(this);
        blockObsidianButton = new BlockButtonObsidian();
        itemBlastingGel = new ItemBlastingGel(false, this);
        itemHighExBlastingGel = new ItemBlastingGel(true, this);
        itemMoltenIron = new StealthwareItem((StealthwareMod)this);
        itemScrapIron = new StealthwareItem((StealthwareMod)this);
        itemGelatine = new StealthwareItem((StealthwareMod)this);
        itemObsidianDoor = new ItemObsidianDoor(this);
        this.registerBlock(blockShapedCharge, "shapedCharge");
        this.registerBlock(blockBlastingGel, "blastingGel");
        this.registerBlock(blockSpokeBomb, "spokeBomb");
        this.registerBlock(blockReinforcedIron, "reinforcedIron");
        this.registerBlock(blockPlasticExplosive, "plasticExplosive");
        this.registerBlock(blockExplosivesChest, "explosivesChest");
        this.registerBlock(blockObsidianDoor, "doorObsidianBlock");
        this.registerBlock(blockReinforcedGlass, "reinforcedGlass");
        this.registerBlock(blockClaymoreMine, "claymore");
        this.registerBlock(blockBreachingCharge, "breachCharge");
        this.registerBlock(blockReinforcedGlassPane, "reinforcedGlassPane");
        if (enableNewBlocks) {
            this.registerBlock(blockHighExBlastingGel, "blastingGelHE");
            this.registerBlock(blockObsidianButton, "obsidianButton");
            this.registerItem(itemHighExBlastingGel, "IBlastingGelHE");
        }
        this.registerItem(itemBlastingGel, "IBlastingGel");
        this.registerItem(itemMoltenIron, "moltenIron");
        this.registerItem(itemScrapIron, "scrapIron");
        this.registerItem(itemGelatine, "gelatine");
        this.registerItem(itemObsidianDoor, "doorObsidian");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        super.init(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        network = new SimpleNetworkWrapper("Explodables_C1");
        network.registerMessage(PacketHandler.BlastingGelExplodeHandler.class, Packet.BlastingGelExplode.class, 1, Side.CLIENT);
        network.registerMessage(PacketHandler.UpdateDirectionalExplosiveHandler.class, Packet.UpdateDirectionalExplosive.class, 2, Side.CLIENT);
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockShapedCharge, 6), (Object[])new Object[]{"#X#", "###", "ZZZ", Character.valueOf('#'), blockPlasticExplosive, Character.valueOf('X'), Items.field_151042_j, Character.valueOf('Z'), Blocks.field_150343_Z});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(itemBlastingGel, 4), (Object[])new Object[]{Items.field_151137_ax, Items.field_151016_H, itemGelatine});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(itemHighExBlastingGel, 1), (Object[])new Object[]{itemBlastingGel, new ItemStack(Items.field_151100_aR, 1, 4)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockSpokeBomb, 1), (Object[])new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), itemMoltenIron, Character.valueOf('X'), blockPlasticExplosive});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemMoltenIron, 20), (Object[])new Object[]{"#", "#", "X", Character.valueOf('#'), Items.field_151042_j, Character.valueOf('X'), Items.field_151129_at});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(blockPlasticExplosive, 2), (Object[])new Object[]{Blocks.field_150335_W, Blocks.field_150435_aG});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockExplosivesChest, 1), (Object[])new Object[]{"#X#", "X X", "#X#", Character.valueOf('#'), Blocks.field_150343_Z, Character.valueOf('X'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemObsidianDoor, 1), (Object[])new Object[]{"##", "##", "##", Character.valueOf('#'), Blocks.field_150343_Z});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockReinforcedGlass, 4), (Object[])new Object[]{" X ", "X#X", " X ", Character.valueOf('#'), new ItemStack(Blocks.field_150359_w, 4), Character.valueOf('X'), Blocks.field_150343_Z});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockClaymoreMine, 4), (Object[])new Object[]{"###", "X#X", "XXX", Character.valueOf('#'), blockPlasticExplosive, Character.valueOf('X'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockClaymoreMulti, 1), (Object[])new Object[]{"X#X", "XXX", Character.valueOf('#'), Items.field_151137_ax, Character.valueOf('X'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockBreachingCharge, 6), (Object[])new Object[]{"XXX", "ZZZ", Character.valueOf('X'), blockPlasticExplosive, Character.valueOf('Z'), Blocks.field_150344_f});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockReinforcedGlassPane, 16), (Object[])new Object[]{"###", "###", Character.valueOf('#'), blockReinforcedGlass});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(blockObsidianButton, 1), (Object[])new Object[]{Blocks.field_150343_Z});
        GameRegistry.addSmelting((Item)itemScrapIron, (ItemStack)new ItemStack(itemMoltenIron, 1), (float)0.3f);
        GameRegistry.addSmelting((Item)Items.field_151103_aS, (ItemStack)new ItemStack(itemGelatine, 1), (float)0.3f);
        GameRegistry.addSmelting((Item)Items.field_151116_aA, (ItemStack)new ItemStack(itemGelatine, 1), (float)0.3f);
        GameRegistry.registerTileEntity(TileEntityExplosivesChest.class, (String)"ExplosivesChest");
        EntityRegistry.registerModEntity(EntityShapedChargePrimed.class, (String)"ShapedChargePrimed", (int)shapedChargeEntityId, (Object)((Object)this), (int)160, (int)5, (boolean)false);
        EntityRegistry.registerModEntity(EntitySpokeBombPrimed.class, (String)"SpokeBombPrimed", (int)spokeBombEntityId, (Object)((Object)this), (int)160, (int)5, (boolean)false);
        EntityRegistry.registerModEntity(EntityClaymoreMinePrimed.class, (String)"ClaymoreMinePrimed", (int)claymoreMineEntityId, (Object)((Object)this), (int)160, (int)5, (boolean)false);
        EntityRegistry.registerModEntity(EntityBreachingChargePrimed.class, (String)"BreachingChargePrimed", (int)breachingChargeEntityId, (Object)((Object)this), (int)160, (int)5, (boolean)false);
        itemBlastingGel.func_77637_a(CreativeTabs.field_78028_d);
        itemHighExBlastingGel.func_77637_a(CreativeTabs.field_78028_d);
        itemGelatine.func_77637_a(CreativeTabs.field_78035_l);
        itemMoltenIron.func_77637_a(CreativeTabs.field_78035_l);
        itemScrapIron.func_77637_a(CreativeTabs.field_78035_l);
        itemObsidianDoor.func_77637_a(CreativeTabs.field_78028_d);
        blockShapedCharge.func_149647_a(CreativeTabs.field_78028_d);
        blockSpokeBomb.func_149647_a(CreativeTabs.field_78028_d);
        blockClaymoreMine.func_149647_a(CreativeTabs.field_78028_d);
        blockClaymoreMulti.func_149647_a(CreativeTabs.field_78028_d);
        blockBreachingCharge.func_149647_a(CreativeTabs.field_78028_d);
        blockPlasticExplosive.func_149647_a(CreativeTabs.field_78035_l);
        blockObsidianButton.func_149647_a(CreativeTabs.field_78028_d);
        GameRegistry.registerFuelHandler((IFuelHandler)this);
        proxy.setupRenderer();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        Object neiAPI = evt.buildSoftDependProxy("NotEnoughItems", "codechicken.nei.api.API");
        if (neiAPI != null) {
            try {
                Method hideItem = neiAPI.getClass().getMethod("hideItem", Integer.TYPE);
                hideItem.invoke(neiAPI, Block.func_149682_b((Block)blockObsidianDoor));
                hideItem.invoke(neiAPI, Block.func_149682_b((Block)blockReinforcedIron));
                hideItem.invoke(neiAPI, Block.func_149682_b((Block)blockBlastingGel));
                hideItem.invoke(neiAPI, Block.func_149682_b((Block)blockHighExBlastingGel));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            blockBlastingGel.update();
            blockHighExBlastingGel.update();
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            blockBlastingGel.update();
            blockHighExBlastingGel.update();
        }
    }

    public int getBurnTime(ItemStack fuel) {
        Block block = ((ItemBlock)fuel.func_77973_b()).field_150939_a;
        if (block == blockPlasticExplosive) {
            return 800;
        }
        return 0;
    }
}

