/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.explodables;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import uk.co.stealthware.explodables.entity.EntityDirectionalExplosive;

public class ShapedExplosion {
    private static Explosion FAKE_EXPLOSION = new Explosion(null, null, 0.0, 0.0, 0.0, 0.0f);
    public boolean isFlaming = false;
    private WeakReference<World> worldObj;
    public double explosionX;
    public double explosionY;
    public double explosionZ;
    public Entity exploder;
    public float explosionSize;
    public Set<ChunkPosition> destroyedBlockPositions;
    private int meta;

    public ShapedExplosion(World world, Entity entity, double d, double d1, double d2, float f, int meta) {
        new Random();
        this.destroyedBlockPositions = new HashSet<ChunkPosition>();
        this.worldObj = new WeakReference<World>(world);
        this.exploder = entity;
        this.explosionSize = f;
        this.explosionX = d;
        this.explosionY = d1;
        this.explosionZ = d2;
        this.meta = meta;
    }

    public void doExplosionA() {
        World world = (World)this.worldObj.get();
        int startX = 0;
        int endX = 0;
        int startY = 0;
        int endY = 0;
        int startZ = 0;
        int endZ = 0;
        switch (this.meta) {
            case 0: {
                startX = 3;
                endX = 13;
                startY = 6;
                endY = 16;
                startZ = 3;
                endZ = 13;
                break;
            }
            case 1: {
                startX = 3;
                endX = 13;
                startY = 0;
                endY = 10;
                startZ = 3;
                endZ = 13;
                break;
            }
            case 2: {
                this.explosionY += 0.5;
                startX = 4;
                endX = 13;
                startY = 4;
                endY = 13;
                startZ = 6;
                endZ = 16;
                break;
            }
            case 3: {
                this.explosionY += 0.5;
                startX = 4;
                endX = 13;
                startY = 4;
                endY = 13;
                startZ = 0;
                endZ = 10;
                break;
            }
            case 4: {
                this.explosionY += 0.5;
                startX = 6;
                endX = 16;
                startY = 4;
                endY = 13;
                startZ = 4;
                endZ = 13;
                break;
            }
            case 5: {
                this.explosionY += 0.5;
                startX = 0;
                endX = 10;
                startY = 4;
                endY = 13;
                startZ = 4;
                endZ = 13;
            }
        }
        startX *= 2;
        endX *= 2;
        startY *= 2;
        endY *= 2;
        startZ *= 2;
        endZ *= 2;
        for (int var3 = startX; var3 < endX; ++var3) {
            for (int var4 = startY; var4 < endY; ++var4) {
                for (int var5 = startZ; var5 < endZ; ++var5) {
                    if (var3 != 0 && var3 != 31 && var4 != 0 && var4 != 31 && var5 != 0 && var5 != 31) continue;
                    double var6 = (float)var3 / 31.0f * 2.0f - 1.0f;
                    double var8 = (float)var4 / 31.0f * 2.0f - 1.0f;
                    double var10 = (float)var5 / 31.0f * 2.0f - 1.0f;
                    double var12 = Math.sqrt(var6 * var6 + var8 * var8 + var10 * var10);
                    var6 /= var12;
                    var8 /= var12;
                    var10 /= var12;
                    double var15 = this.explosionX;
                    double var17 = this.explosionY;
                    double var19 = this.explosionZ;
                    float var21 = 0.3f;
                    for (float var14 = this.explosionSize * (0.7f + world.field_73012_v.nextFloat() * 0.6f); var14 > 0.0f; var14 -= var21 * 0.75f) {
                        int var24;
                        int var23;
                        int var22 = MathHelper.func_76128_c((double)var15);
                        Block var25 = world.func_147439_a(var22, var23 = MathHelper.func_76128_c((double)var17), var24 = MathHelper.func_76128_c((double)var19));
                        if (var25 != Blocks.field_150350_a) {
                            float var27 = var25.getExplosionResistance(this.exploder, world, var22, var23, var24, this.explosionX, this.explosionY, this.explosionZ);
                            var14 -= (var27 + 0.3f) * var21;
                        }
                        if (var14 > 0.0f) {
                            this.destroyedBlockPositions.add(new ChunkPosition(var22, var23, var24));
                        }
                        var15 += var6 * (double)var21;
                        var17 += var8 * (double)var21;
                        var19 += var10 * (double)var21;
                    }
                }
            }
        }
        if (world.field_72995_K) {
            return;
        }
        float entityExplosionSize = 6.0f;
        int k = MathHelper.func_76128_c((double)(this.explosionX - (double)entityExplosionSize - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.explosionX + (double)entityExplosionSize + 1.0));
        int k1 = MathHelper.func_76128_c((double)(this.explosionY - (double)entityExplosionSize - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.explosionY + (double)entityExplosionSize + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.explosionZ - (double)entityExplosionSize - 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.explosionZ + (double)entityExplosionSize + 1.0));
        List list = world.func_72839_b(this.exploder, AxisAlignedBB.func_72330_a((double)k, (double)k1, (double)i2, (double)i1, (double)l1, (double)j2));
        Vec3 vec3d = Vec3.func_72443_a((double)this.explosionX, (double)this.explosionY, (double)this.explosionZ);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            Entity entity = (Entity)list.get(k2);
            double d4 = entity.func_70011_f(this.explosionX, this.explosionY, this.explosionZ) / (double)entityExplosionSize;
            if (!(d4 <= 1.0)) continue;
            double d6 = entity.field_70165_t - this.explosionX;
            double d8 = entity.field_70163_u - this.explosionY;
            double d10 = entity.field_70161_v - this.explosionZ;
            double d11 = MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8 + d10 * d10));
            d6 /= d11;
            d8 /= d11;
            d10 /= d11;
            double d12 = world.func_72842_a(vec3d, entity.field_70121_D);
            double d13 = (1.0 - d4) * d12;
            entity.func_70097_a(EntityDirectionalExplosive.damageSource, (float)((int)((d13 * d13 + d13) / 2.0 * 8.0 * (double)entityExplosionSize + 1.0)));
            double d14 = d13;
            entity.field_70159_w += d6 * d14;
            entity.field_70181_x += d8 * d14;
            entity.field_70179_y += d10 * d14;
        }
    }

    public void doExplosionB(boolean flag) {
        World world = (World)this.worldObj.get();
        world.func_72908_a(this.explosionX, this.explosionY, this.explosionZ, "random.explode", 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        world.func_72869_a("hugeexplosion", this.explosionX, this.explosionY, this.explosionZ, 0.0, 0.0, 0.0);
        ArrayList<ChunkPosition> arraylist = new ArrayList<ChunkPosition>();
        arraylist.addAll(this.destroyedBlockPositions);
        for (int i = arraylist.size() - 1; i >= 0; --i) {
            ChunkPosition chunkposition = (ChunkPosition)arraylist.get(i);
            int j = chunkposition.field_151329_a;
            int k = chunkposition.field_151327_b;
            int l = chunkposition.field_151328_c;
            Block block = world.func_147439_a(j, k, l);
            if (flag) {
                double d = (float)j + world.field_73012_v.nextFloat();
                double d1 = (float)k + world.field_73012_v.nextFloat();
                double d2 = (float)l + world.field_73012_v.nextFloat();
                double d3 = d - this.explosionX;
                double d4 = d1 - this.explosionY;
                double d5 = d2 - this.explosionZ;
                double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                d3 /= d6;
                d4 /= d6;
                d5 /= d6;
                double d7 = 0.5 / (d6 / (double)this.explosionSize + 0.1);
                world.func_72869_a("explode", (d + this.explosionX * 1.0) / 2.0, (d1 + this.explosionY * 1.0) / 2.0, (d2 + this.explosionZ * 1.0) / 2.0, d3 *= (d7 *= (double)(world.field_73012_v.nextFloat() * world.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
                world.func_72869_a("smoke", d, d1, d2, d3, d4, d5);
            }
            if (block == Blocks.field_150350_a || world.field_72995_K) continue;
            block.func_149690_a(world, j, k, l, world.func_72805_g(j, k, l), 0.3f, 0);
            block.onBlockExploded(world, j, k, l, FAKE_EXPLOSION);
        }
    }
}

