/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.explodables.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Direction;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import uk.co.stealthware.explodables.Explodables;

public class BlockBlastingGel
extends Block {
    @SideOnly(value=Side.CLIENT)
    public static IIcon line;
    @SideOnly(value=Side.CLIENT)
    public static IIcon cross;
    @SideOnly(value=Side.CLIENT)
    public static IIcon line_overlay;
    @SideOnly(value=Side.CLIENT)
    public static IIcon cross_overlay;
    public static int COLOUR_NORMAL;
    public static int COLOUR_HIGHEX;
    private static Explosion FAKE_EXPLOSION;
    private WeakReference<World> worldObj;
    private int explosionSize;
    private int colour;
    private Item item;
    private Map<ChunkPosition, Integer> activatedBlockPositions;
    private boolean wiresProvidePower = true;
    private Set<ChunkPosition> blocksNeedingUpdate = new HashSet<ChunkPosition>();
    int updateCount = 0;
    int updateSpeed = 10;

    public BlockBlastingGel(int colour, int power, Item item) {
        super(Material.field_151594_q);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
        this.explosionSize = power;
        this.colour = colour;
        this.item = item;
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149776_m);
        this.func_149649_H();
        this.activatedBlockPositions = new HashMap<ChunkPosition, Integer>();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        line = reg.func_94245_a("Explodables:blastingGel_line");
        cross = reg.func_94245_a("Explodables:blastingGel_cross");
        line_overlay = reg.func_94245_a("Explodables:blastingGel_line_overlay");
        cross_overlay = reg.func_94245_a("Explodables:blastingGel_cross_overlay");
        this.field_149761_L = cross;
    }

    public AxisAlignedBB func_149668_a(World world, int i, int j, int k) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return Explodables.modelBlastingGelId;
    }

    public int func_149720_d(IBlockAccess iblockaccess, int i, int j, int k) {
        return this.colour;
    }

    public int getColour() {
        return this.colour;
    }

    public boolean func_149742_c(World par1World, int par2, int par3, int par4) {
        return World.func_147466_a((IBlockAccess)par1World, (int)par2, (int)(par3 - 1), (int)par4) || par1World.func_147439_a(par2, par3 - 1, par4) == Blocks.field_150426_aN;
    }

    private void updateAndPropagateCurrentStrength(World par1World, int par2, int par3, int par4) {
        this.calculateCurrentChanges(par1World, par2, par3, par4, par2, par3, par4);
        ArrayList<ChunkPosition> arraylist = new ArrayList<ChunkPosition>(this.blocksNeedingUpdate);
        this.blocksNeedingUpdate.clear();
        for (int l = 0; l < arraylist.size(); ++l) {
            ChunkPosition chunkposition = arraylist.get(l);
            par1World.func_147459_d(chunkposition.field_151329_a, chunkposition.field_151327_b, chunkposition.field_151328_c, (Block)this);
        }
    }

    private void calculateCurrentChanges(World par1World, int par2, int par3, int par4, int par5, int par6, int par7) {
        int k1 = par1World.func_72805_g(par2, par3, par4);
        int b0 = 0;
        int l1 = this.getMaxCurrentStrength(par1World, par5, par6, par7, b0);
        this.wiresProvidePower = false;
        int i2 = par1World.func_94572_D(par2, par3, par4);
        this.wiresProvidePower = true;
        if (i2 > 0 && i2 > l1 - 1) {
            l1 = i2;
        }
        int j2 = 0;
        for (int k2 = 0; k2 < 4; ++k2) {
            int l2 = par2;
            int i3 = par4;
            if (k2 == 0) {
                l2 = par2 - 1;
            }
            if (k2 == 1) {
                ++l2;
            }
            if (k2 == 2) {
                i3 = par4 - 1;
            }
            if (k2 == 3) {
                ++i3;
            }
            if (l2 != par5 || i3 != par7) {
                j2 = this.getMaxCurrentStrength(par1World, l2, par3, i3, j2);
            }
            if (par1World.func_147445_c(l2, par3, i3, false) && !par1World.func_147445_c(par2, par3 + 1, par4, false)) {
                if (l2 == par5 && i3 == par7 || par3 < par6) continue;
                j2 = this.getMaxCurrentStrength(par1World, l2, par3 + 1, i3, j2);
                continue;
            }
            if (par1World.func_147445_c(l2, par3, i3, false) || l2 == par5 && i3 == par7 || par3 > par6) continue;
            j2 = this.getMaxCurrentStrength(par1World, l2, par3 - 1, i3, j2);
        }
        l1 = j2 > l1 ? j2 - 1 : (l1 > 0 ? --l1 : 0);
        if (i2 > l1 - 1) {
            l1 = i2;
        }
        if (k1 != l1) {
            par1World.func_72921_c(par2, par3, par4, l1, 2);
            this.blocksNeedingUpdate.add(new ChunkPosition(par2, par3, par4));
            this.blocksNeedingUpdate.add(new ChunkPosition(par2 - 1, par3, par4));
            this.blocksNeedingUpdate.add(new ChunkPosition(par2 + 1, par3, par4));
            this.blocksNeedingUpdate.add(new ChunkPosition(par2, par3 - 1, par4));
            this.blocksNeedingUpdate.add(new ChunkPosition(par2, par3 + 1, par4));
            this.blocksNeedingUpdate.add(new ChunkPosition(par2, par3, par4 - 1));
            this.blocksNeedingUpdate.add(new ChunkPosition(par2, par3, par4 + 1));
        }
        if (!par1World.field_72995_K) {
            this.checkExplode(par1World, par2, par3, par4);
        }
    }

    private void notifyWireNeighborsOfNeighborChange(World par1World, int par2, int par3, int par4) {
        if (par1World.func_147439_a(par2, par3, par4) == this) {
            par1World.func_147459_d(par2, par3, par4, (Block)this);
            par1World.func_147459_d(par2 - 1, par3, par4, (Block)this);
            par1World.func_147459_d(par2 + 1, par3, par4, (Block)this);
            par1World.func_147459_d(par2, par3, par4 - 1, (Block)this);
            par1World.func_147459_d(par2, par3, par4 + 1, (Block)this);
            par1World.func_147459_d(par2, par3 - 1, par4, (Block)this);
            par1World.func_147459_d(par2, par3 + 1, par4, (Block)this);
        }
    }

    public void func_149726_b(World par1World, int par2, int par3, int par4) {
        super.func_149726_b(par1World, par2, par3, par4);
        if (!par1World.field_72995_K) {
            this.updateAndPropagateCurrentStrength(par1World, par2, par3, par4);
            par1World.func_147459_d(par2, par3 + 1, par4, (Block)this);
            par1World.func_147459_d(par2, par3 - 1, par4, (Block)this);
            this.notifyWireNeighborsOfNeighborChange(par1World, par2 - 1, par3, par4);
            this.notifyWireNeighborsOfNeighborChange(par1World, par2 + 1, par3, par4);
            this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3, par4 - 1);
            this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3, par4 + 1);
            if (par1World.func_147445_c(par2 - 1, par3, par4, false)) {
                this.notifyWireNeighborsOfNeighborChange(par1World, par2 - 1, par3 + 1, par4);
            } else {
                this.notifyWireNeighborsOfNeighborChange(par1World, par2 - 1, par3 - 1, par4);
            }
            if (par1World.func_147445_c(par2 + 1, par3, par4, false)) {
                this.notifyWireNeighborsOfNeighborChange(par1World, par2 + 1, par3 + 1, par4);
            } else {
                this.notifyWireNeighborsOfNeighborChange(par1World, par2 + 1, par3 - 1, par4);
            }
            if (par1World.func_147445_c(par2, par3, par4 - 1, false)) {
                this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3 + 1, par4 - 1);
            } else {
                this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3 - 1, par4 - 1);
            }
            if (par1World.func_147445_c(par2, par3, par4 + 1, false)) {
                this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3 + 1, par4 + 1);
            } else {
                this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3 - 1, par4 + 1);
            }
        }
    }

    public void func_149749_a(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        super.func_149749_a(par1World, par2, par3, par4, par5, par6);
        if (!par1World.field_72995_K) {
            par1World.func_147459_d(par2, par3 + 1, par4, (Block)this);
            par1World.func_147459_d(par2, par3 - 1, par4, (Block)this);
            par1World.func_147459_d(par2 + 1, par3, par4, (Block)this);
            par1World.func_147459_d(par2 - 1, par3, par4, (Block)this);
            par1World.func_147459_d(par2, par3, par4 + 1, (Block)this);
            par1World.func_147459_d(par2, par3, par4 - 1, (Block)this);
            this.updateAndPropagateCurrentStrength(par1World, par2, par3, par4);
            this.notifyWireNeighborsOfNeighborChange(par1World, par2 - 1, par3, par4);
            this.notifyWireNeighborsOfNeighborChange(par1World, par2 + 1, par3, par4);
            this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3, par4 - 1);
            this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3, par4 + 1);
            if (par1World.func_147445_c(par2 - 1, par3, par4, false)) {
                this.notifyWireNeighborsOfNeighborChange(par1World, par2 - 1, par3 + 1, par4);
            } else {
                this.notifyWireNeighborsOfNeighborChange(par1World, par2 - 1, par3 - 1, par4);
            }
            if (par1World.func_147445_c(par2 + 1, par3, par4, false)) {
                this.notifyWireNeighborsOfNeighborChange(par1World, par2 + 1, par3 + 1, par4);
            } else {
                this.notifyWireNeighborsOfNeighborChange(par1World, par2 + 1, par3 - 1, par4);
            }
            if (par1World.func_147445_c(par2, par3, par4 - 1, false)) {
                this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3 + 1, par4 - 1);
            } else {
                this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3 - 1, par4 - 1);
            }
            if (par1World.func_147445_c(par2, par3, par4 + 1, false)) {
                this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3 + 1, par4 + 1);
            } else {
                this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3 - 1, par4 + 1);
            }
        }
    }

    private int getMaxCurrentStrength(World par1World, int par2, int par3, int par4, int par5) {
        if (par1World.func_147439_a(par2, par3, par4) != this) {
            return par5;
        }
        int i1 = par1World.func_72805_g(par2, par3, par4);
        return i1 > par5 ? i1 : par5;
    }

    public void func_149695_a(World par1World, int par2, int par3, int par4, Block par5) {
        if (!par1World.field_72995_K) {
            boolean flag = this.func_149742_c(par1World, par2, par3, par4);
            if (flag) {
                this.updateAndPropagateCurrentStrength(par1World, par2, par3, par4);
            } else {
                this.func_149697_b(par1World, par2, par3, par4, 0, 0);
                par1World.func_147468_f(par2, par3, par4);
            }
            super.func_149695_a(par1World, par2, par3, par4, par5);
        }
    }

    public int func_149709_b(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (!this.wiresProvidePower) {
            return 0;
        }
        return this.func_149748_c(iblockaccess, i, j, k, l);
    }

    public int func_149748_c(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        boolean flag3;
        int i1 = iblockaccess.func_72805_g(i, j, k);
        if (i1 == 0) {
            return 0;
        }
        if (l == 1) {
            return i1;
        }
        boolean flag = BlockBlastingGel.isPoweredOrRepeater(iblockaccess, i - 1, j, k, 1) || !iblockaccess.func_147439_a(i - 1, j, k).func_149721_r() && BlockBlastingGel.isPoweredOrRepeater(iblockaccess, i - 1, j - 1, k, -1);
        boolean flag1 = BlockBlastingGel.isPoweredOrRepeater(iblockaccess, i + 1, j, k, 3) || !iblockaccess.func_147439_a(i + 1, j, k).func_149721_r() && BlockBlastingGel.isPoweredOrRepeater(iblockaccess, i + 1, j - 1, k, -1);
        boolean flag2 = BlockBlastingGel.isPoweredOrRepeater(iblockaccess, i, j, k - 1, 2) || !iblockaccess.func_147439_a(i, j, k - 1).func_149721_r() && BlockBlastingGel.isPoweredOrRepeater(iblockaccess, i, j - 1, k - 1, -1);
        boolean bl = flag3 = BlockBlastingGel.isPoweredOrRepeater(iblockaccess, i, j, k + 1, 0) || !iblockaccess.func_147439_a(i, j, k + 1).func_149721_r() && BlockBlastingGel.isPoweredOrRepeater(iblockaccess, i, j - 1, k + 1, -1);
        if (!iblockaccess.func_147439_a(i, j + 1, k).func_149721_r()) {
            if (iblockaccess.func_147439_a(i - 1, j, k).func_149721_r() && BlockBlastingGel.isPoweredOrRepeater(iblockaccess, i - 1, j + 1, k, -1)) {
                flag = true;
            }
            if (iblockaccess.func_147439_a(i + 1, j, k).func_149721_r() && BlockBlastingGel.isPoweredOrRepeater(iblockaccess, i + 1, j + 1, k, -1)) {
                flag1 = true;
            }
            if (iblockaccess.func_147439_a(i, j, k - 1).func_149721_r() && BlockBlastingGel.isPoweredOrRepeater(iblockaccess, i, j + 1, k - 1, -1)) {
                flag2 = true;
            }
            if (iblockaccess.func_147439_a(i, j, k + 1).func_149721_r() && BlockBlastingGel.isPoweredOrRepeater(iblockaccess, i, j + 1, k + 1, -1)) {
                flag3 = true;
            }
        }
        return !flag2 && !flag1 && !flag && !flag3 && l >= 2 && l <= 5 ? i1 : (l == 2 && flag2 && !flag && !flag1 ? i1 : (l == 3 && flag3 && !flag && !flag1 ? i1 : (l == 4 && flag && !flag2 && !flag3 ? i1 : (l == 5 && flag1 && !flag2 && !flag3 ? i1 : 0))));
    }

    public static boolean isPoweredOrRepeater(IBlockAccess par0IBlockAccess, int par1, int par2, int par3, int par4) {
        if (BlockBlastingGel.isPowerProviderOrWire(par0IBlockAccess, par1, par2, par3, par4)) {
            return true;
        }
        Block i1 = par0IBlockAccess.func_147439_a(par1, par2, par3);
        if (i1 == Blocks.field_150416_aS) {
            int j1 = par0IBlockAccess.func_72805_g(par1, par2, par3);
            return par4 == (j1 & 3);
        }
        return false;
    }

    public static boolean isPowerProviderOrWire(IBlockAccess par0IBlockAccess, int par1, int par2, int par3, int par4) {
        Block i1 = par0IBlockAccess.func_147439_a(par1, par2, par3);
        if (i1 == Explodables.blockBlastingGel || i1 == Explodables.blockHighExBlastingGel || i1 == Blocks.field_150488_af) {
            return true;
        }
        if (i1 == Blocks.field_150350_a) {
            return false;
        }
        if (!BlockRedstoneDiode.func_149909_d((Block)i1)) {
            return i1 != null && i1.canConnectRedstone(par0IBlockAccess, par1, par2, par3, par4);
        }
        int j1 = par0IBlockAccess.func_72805_g(par1, par2, par3);
        return par4 == (j1 & 3) || par4 == Direction.field_71580_e[j1 & 3];
    }

    public boolean func_149744_f() {
        return this.wiresProvidePower;
    }

    public void func_149734_b(World par1World, int par2, int par3, int par4, Random par5Random) {
        int l = par1World.func_72805_g(par2, par3, par4);
        if (l > 0) {
            double d0 = (double)par2 + 0.5 + ((double)par5Random.nextFloat() - 0.5) * 0.2;
            double d1 = (float)par3 + 0.0625f;
            double d2 = (double)par4 + 0.5 + ((double)par5Random.nextFloat() - 0.5) * 0.2;
            float f = (float)l / 15.0f;
            float f1 = f * 0.6f + 0.4f;
            if (l == 0) {
                f1 = 0.0f;
            }
            float f2 = f * f * 0.7f - 0.5f;
            float f3 = f * f * 0.6f - 0.7f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f3 < 0.0f) {
                f3 = 0.0f;
            }
            par1World.func_72869_a("reddust", d0, d1, d2, (double)f1, (double)f2, (double)f3);
        }
    }

    public Item func_149694_d(World par1World, int par2, int par3, int par4) {
        return this.item;
    }

    public Item func_149650_a(int i, Random random, int j) {
        return this.item;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack(this.item);
    }

    public void checkExplode(World world, int i, int j, int k) {
        Integer bang;
        int l;
        if (this.worldObj == null || this.worldObj.get() == null) {
            this.worldObj = new WeakReference<World>(world);
        }
        if ((l = world.func_72805_g(i, j, k)) > 0 && (bang = this.activatedBlockPositions.get(new ChunkPosition(i, j, k))) == null) {
            this.activatedBlockPositions.put(new ChunkPosition(i, j, k), 40 - l * 2);
        }
    }

    public void update() {
        if (this.worldObj == null) {
            return;
        }
        World world = (World)this.worldObj.get();
        if (world == null) {
            return;
        }
        ++this.updateCount;
        if (this.updateCount >= this.updateSpeed) {
            this.updateCount = 0;
            if (this.activatedBlockPositions.size() > 0) {
                this.updateSpeed = 1;
                Object[] array = this.activatedBlockPositions.entrySet().toArray();
                for (int i = 0; i < array.length; ++i) {
                    Map.Entry item = (Map.Entry)array[i];
                    if ((Integer)item.getValue() <= 0) {
                        ChunkPosition pos = (ChunkPosition)item.getKey();
                        this.activatedBlockPositions.remove(pos);
                        world.func_147465_d(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, Blocks.field_150350_a, 0, 3);
                        this.doExplosion(world, pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
                        if (!world.field_72995_K) continue;
                        Explodables.proxy.sendGelExplodePacket(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, this.explosionSize);
                        continue;
                    }
                    item.setValue((Integer)item.getValue() - 1);
                }
            } else if (this.updateSpeed == 1 && this.activatedBlockPositions.size() == 0) {
                this.updateSpeed = 10;
            }
        }
    }

    public void doExplosion(World worldObj, int x, int y, int z) {
        worldObj.func_72908_a((double)x, (double)y, (double)z, "random.explode", 4.0f, (1.0f + (worldObj.field_73012_v.nextFloat() - worldObj.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        for (int l = 1; l <= this.explosionSize; ++l) {
            int i1 = x;
            int j1 = y - l;
            int k1 = z;
            Block type = worldObj.func_147439_a(i1, j1, k1);
            worldObj.func_72869_a("explode", (double)i1, (double)j1, (double)k1, 0.0, 0.0, 0.0);
            worldObj.func_72869_a("smoke", (double)i1, (double)j1, (double)k1, 0.0, 0.0, 0.0);
            if (type == Blocks.field_150350_a || !(type.func_149638_a(null) < 100.0f)) continue;
            type.func_149690_a(worldObj, i1, j1, k1, worldObj.func_72805_g(i1, j1, k1), 0.5f, 0);
            type.onBlockExploded(worldObj, i1, j1, k1, FAKE_EXPLOSION);
        }
    }

    static {
        COLOUR_NORMAL = 8847510;
        COLOUR_HIGHEX = 852126;
        FAKE_EXPLOSION = new Explosion(null, null, 0.0, 0.0, 0.0, 0.0f);
    }
}

