/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.explodables.block;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import uk.co.stealthware.explodables.Explodables;
import uk.co.stealthware.explodables.entity.EntityDirectionalExplosive;
import uk.co.stealthware.minecraft.StealthwareBlock;
import uk.co.stealthware.minecraft.StealthwareMod;

public class BlockDirectionalExplosive
extends StealthwareBlock {
    @SideOnly(value=Side.CLIENT)
    IIcon texTop;
    @SideOnly(value=Side.CLIENT)
    IIcon texBottom;
    @SideOnly(value=Side.CLIENT)
    IIcon texLeft;
    @SideOnly(value=Side.CLIENT)
    IIcon texRight;
    @SideOnly(value=Side.CLIENT)
    IIcon texFront;
    @SideOnly(value=Side.CLIENT)
    IIcon texBack;
    @SideOnly(value=Side.CLIENT)
    IIcon[][] texSet;
    LazyModelId model;
    Class<? extends EntityDirectionalExplosive> explosiveType;

    public BlockDirectionalExplosive(StealthwareMod mod) {
        super(Material.field_151590_u, mod);
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149779_h);
    }

    public BlockDirectionalExplosive(Class<? extends EntityDirectionalExplosive> explosiveType, LazyModelId model, StealthwareMod mod) {
        super(Material.field_151590_u, mod);
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149779_h);
        this.explosiveType = explosiveType;
        this.model = model;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        FMLCommonHandler.instance().getFMLLogger().fatal("Must override registerBlockIcons and call createTextureSet!");
    }

    @SideOnly(value=Side.CLIENT)
    void createTextureSet() {
        this.texSet = new IIcon[][]{{this.texBottom, this.texTop, this.texLeft, this.texRight, this.texFront, this.texBack}, {this.texTop, this.texBottom, this.texLeft, this.texRight, this.texFront, this.texBack}, {this.texFront, this.texBack, this.texBottom, this.texTop, this.texLeft, this.texRight}, {this.texFront, this.texBack, this.texTop, this.texBottom, this.texLeft, this.texRight}, {this.texFront, this.texBack, this.texLeft, this.texRight, this.texBottom, this.texTop}, {this.texFront, this.texBack, this.texLeft, this.texRight, this.texTop, this.texBottom}};
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.texSet[meta][side];
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return this.model.getModelId();
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        int l = BlockDirectionalExplosive.getDirection(world, i, j, k, (EntityPlayer)entityliving);
        world.func_72921_c(i, j, k, l, 0);
        if (world.func_72864_z(i, j, k)) {
            this.explode(world, i, j, k, -1);
            world.func_147465_d(i, j, k, Blocks.field_150350_a, 0, 3);
        }
    }

    public void func_149695_a(World world, int i, int j, int k, Block l) {
        if (l != Blocks.field_150350_a && l.func_149744_f() && world.func_72864_z(i, j, k)) {
            this.explode(world, i, j, k, -1);
            world.func_147465_d(i, j, k, Blocks.field_150350_a, 0, 3);
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        if (world.field_72995_K) {
            return;
        }
        this.explode(world, x, y, z, 10 + world.field_73012_v.nextInt(40));
        super.onBlockExploded(world, x, y, z, explosion);
    }

    public void explode(World world, int x, int y, int z, int overrideFuse) {
        if (world.field_72995_K) {
            return;
        }
        try {
            int direction = world.func_72805_g(x, y, z);
            Constructor<? extends EntityDirectionalExplosive> ctor = this.explosiveType.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE, Integer.TYPE);
            EntityDirectionalExplosive entity = ctor.newInstance(world, Float.valueOf((float)x + 0.5f), Float.valueOf(y), Float.valueOf((float)z + 0.5f), direction);
            if (overrideFuse >= 0) {
                entity.fuse = overrideFuse;
            }
            world.func_72838_d((Entity)entity);
            Explodables.proxy.sendFuseDirectionPacket(entity);
        }
        catch (NoSuchMethodException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
    }

    public void func_149664_b(World world, int i, int j, int k, int l) {
        if (world.field_72995_K || !world.func_82736_K().func_82766_b("doTileDrops")) {
            return;
        }
        this.func_149642_a(world, i, j, k, new ItemStack((Block)this, 1, 0));
    }

    static int getDirection(World world, int i, int j, int k, EntityPlayer entityplayer) {
        int l;
        if (MathHelper.func_76135_e((float)((float)entityplayer.field_70165_t - (float)i)) < 2.0f && MathHelper.func_76135_e((float)((float)entityplayer.field_70161_v - (float)k)) < 2.0f) {
            double d = entityplayer.field_70163_u + 1.82 - (double)entityplayer.field_70129_M;
            if (d - (double)j > 2.0) {
                return 1;
            }
            if ((double)j - d > 0.0) {
                return 0;
            }
        }
        if ((l = MathHelper.func_76128_c((double)((double)(entityplayer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0) {
            return 2;
        }
        if (l == 1) {
            return 5;
        }
        if (l == 2) {
            return 3;
        }
        return l != 3 ? 0 : 4;
    }

    static interface LazyModelId {
        public int getModelId();
    }
}

