/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.client.gui;

import net.minecraft.client.gui.FontRenderer;

public class GuiTextPrinter {
    private final FontRenderer fr;
    private int xOrigin;
    private int yOrigin;
    private int x;
    private int y;
    private int yLineSpace = 12;
    private int color;

    public GuiTextPrinter(FontRenderer fr) {
        this.fr = fr;
    }

    private void newLine() {
        this.x = this.xOrigin;
        this.y += this.yLineSpace;
    }

    public void print(String text) {
        String[] lines = text.split("\n", -1);
        if (lines.length > 1) {
            for (int i = 0; i < lines.length; ++i) {
                if (!lines[i].isEmpty()) {
                    String line = lines[i];
                    line = line.replace("\r", "");
                    line = line.replace("\t", "    ");
                    this.fr.func_78261_a(line, this.x, this.y, this.color);
                }
                if (i != lines.length - 1) {
                    this.newLine();
                    continue;
                }
                this.x += this.fr.func_78256_a(lines[i]);
            }
        } else {
            this.fr.func_78261_a(text, this.x, this.y, this.color);
            this.x += this.fr.func_78256_a(text);
        }
    }

    public void println(String text) {
        this.print(text);
        this.newLine();
    }

    public void println() {
        this.newLine();
    }

    public void printf(String format, Object ... args) {
        this.print(String.format(format, args));
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setOrigin(int x, int y) {
        this.x = x;
        this.y = y;
        this.xOrigin = x;
        this.yOrigin = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getLineSpace() {
        return this.yLineSpace;
    }

    public void setLineSpace(int yLineSpace) {
        this.yLineSpace = yLineSpace;
    }
}

