/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.client.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import info.ata4.minecraft.dragon.DragonMounts;
import info.ata4.minecraft.dragon.server.util.PrivateFields;
import java.io.InputStream;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiOpenEvent;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DragonSplash {
    private static final Logger L = LogManager.getLogger();
    private static final ResourceLocation RESOURCE_SPLASHES = new ResourceLocation(DragonMounts.AID, "splashes.txt");
    private final Random rand = new Random();
    private List<String> splashLines;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DragonSplash() {
        try {
            InputStream is = null;
            try {
                is = Minecraft.func_71410_x().func_110442_L().func_110536_a(RESOURCE_SPLASHES).func_110527_b();
                this.splashLines = IOUtils.readLines((InputStream)is, (String)"UTF-8");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        catch (Throwable t) {
            L.warn("Can't load splashes", t);
        }
    }

    @SubscribeEvent
    public void onOpenGui(GuiOpenEvent evt) {
        if (evt.gui instanceof GuiMainMenu) {
            try {
                GuiMainMenu menu = (GuiMainMenu)evt.gui;
                String splash = this.getSplashText(menu);
                if (splash.equals("Kind of dragon free!")) {
                    splash = "Not really dragon free!";
                    this.setSplashText(menu, splash);
                } else if (this.splashLines != null && !this.splashLines.isEmpty() && this.rand.nextInt(10) == 0) {
                    splash = this.splashLines.get(this.rand.nextInt(this.splashLines.size()));
                    this.setSplashText(menu, splash);
                }
            }
            catch (Throwable t) {
                L.warn("Can't override splash", t);
            }
        }
    }

    private String getSplashText(GuiMainMenu menu) {
        return (String)ReflectionHelper.getPrivateValue(GuiMainMenu.class, (Object)menu, (String[])PrivateFields.GUIMAINMENU_SPLASHTEXT);
    }

    private void setSplashText(GuiMainMenu menu, String splash) {
        ReflectionHelper.setPrivateValue(GuiMainMenu.class, (Object)menu, (Object)splash, (String[])PrivateFields.GUIMAINMENU_SPLASHTEXT);
    }
}

