/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.ai;

import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.util.math.MathX;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityLivingBase;

public class DragonBodyHelper
extends EntityBodyHelper {
    private EntityTameableDragon dragon;
    private int turnTicks;
    private int turnTicksLimit = 20;
    private float prevRotationYawHead;

    public DragonBodyHelper(EntityTameableDragon dragon) {
        super((EntityLivingBase)dragon);
        this.dragon = dragon;
    }

    public void func_75664_a() {
        double deltaX = this.dragon.field_70165_t - this.dragon.field_70169_q;
        double deltaY = this.dragon.field_70161_v - this.dragon.field_70166_s;
        double dist = deltaX * deltaX + deltaY * deltaY;
        float yawSpeed = 90.0f;
        if (this.dragon.isFlying() || dist > 1.0E-4) {
            this.dragon.field_70761_aq = this.dragon.field_70177_z;
            this.prevRotationYawHead = this.dragon.field_70759_as = MathX.updateRotation(this.dragon.field_70761_aq, this.dragon.field_70759_as, yawSpeed);
            this.turnTicks = 0;
            return;
        }
        double yawDiff = Math.abs(this.dragon.field_70759_as - this.prevRotationYawHead);
        if (this.dragon.func_70906_o() || yawDiff > 15.0) {
            this.turnTicks = 0;
            this.prevRotationYawHead = this.dragon.field_70759_as;
        } else {
            ++this.turnTicks;
            if (this.turnTicks > this.turnTicksLimit) {
                yawSpeed = Math.max(1.0f - (float)(this.turnTicks - this.turnTicksLimit) / (float)this.turnTicksLimit, 0.0f) * 75.0f;
            }
        }
        this.dragon.field_70761_aq = MathX.updateRotation(this.dragon.field_70759_as, this.dragon.field_70761_aq, yawSpeed);
    }
}

