/*
 * Decompiled with CFR 0.152.
 */
package mc.ambientocclusion.xrayinstaller.gui;

import java.io.File;
import java.net.JarURLConnection;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import mc.ambientocclusion.xrayinstaller.gui.XRayInstallerGUI;

public class XRayInstaller
implements Runnable {
    public static final File mcDirectory;
    public static final File mcVersions;
    public static String targetVersion;

    static {
        Object object = System.getProperty("os.name").toLowerCase();
        String string = System.getProperty("user.home", ".");
        if (((String)object).contains("win")) {
            object = System.getenv("APPDATA");
            object = object != null ? object : string;
            object = new File((String)object, ".minecraft/");
        } else {
            object = ((String)object).contains("mac") ? new File(string, "Library/Application Support/minecraft") : (((String)object).contains("linux") || ((String)object).contains("unix") ? new File(string, ".minecraft/") : new File(string, "minecraft/"));
        }
        mcDirectory = object;
        mcVersions = new File(mcDirectory, "versions");
        targetVersion = null;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new XRayInstaller());
    }

    private XRayInstaller() {
        try {
            targetVersion = ((JarURLConnection)this.getClass().getResource(String.valueOf(this.getClass().getSimpleName()) + ".class").openConnection()).getJarFile().getManifest().getMainAttributes().getValue("TargetVersion");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error retrieving the target version!", "Error", 0);
            System.exit(1);
        }
        System.out.println("Detected Minecraft directory: " + mcDirectory);
        System.out.println("Target version = " + targetVersion);
    }

    @Override
    public void run() {
        String string = "Nimbus";
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo lookAndFeelInfo = lookAndFeelInfoArray[n2];
                if (string.equals(lookAndFeelInfo.getName())) {
                    UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        if (!mcDirectory.isDirectory()) {
            JOptionPane.showMessageDialog(null, "Minecraft not found! Are you sure it is installed?", "Error", 0);
            return;
        }
        new XRayInstallerGUI().setVisible(true);
    }
}

