/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class JSONArray {
    private final ArrayList<Object> myArrayList = new ArrayList();

    public JSONArray() {
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray(JSONTokener x) throws JSONException {
        this();
        if (x.nextClean() != '[') {
            throw x.syntaxError("A JSONArray text must start with '['");
        }
        if (x.nextClean() != ']') {
            void var1_1;
            x.back();
            block4: while (true) {
                if (x.nextClean() == ',') {
                    x.back();
                    this.myArrayList.add(JSONObject.NULL);
                } else {
                    x.back();
                    this.myArrayList.add(x.nextValue());
                }
                switch (x.nextClean()) {
                    case ',': {
                        if (x.nextClean() == ']') {
                            return;
                        }
                        x.back();
                        continue block4;
                    }
                    case ']': {
                        return;
                    }
                }
                break;
            }
            throw var1_1.syntaxError("Expected a ',' or ']'");
        }
    }

    public JSONArray(Collection<Object> collection) {
        if (collection != null) {
            Iterator<Object> iter = collection.iterator();
            while (iter.hasNext()) {
                this.myArrayList.add(JSONObject.wrap(iter.next()));
            }
        }
    }

    public JSONArray(Object array) throws JSONException {
        this();
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            int i = 0;
            while (i < length) {
                Object object = JSONObject.wrap(Array.get(array, i));
                this.myArrayList.add(object);
                ++i;
            }
            return;
        }
        throw new JSONException("JSONArray initial value should be a string or collection or array.");
    }

    public final int length() {
        return this.myArrayList.size();
    }

    /*
     * WARNING - void declaration
     */
    public final Object opt(int index) {
        void var1_1;
        if (index < 0 || index >= this.myArrayList.size()) {
            return null;
        }
        return this.myArrayList.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Object remove(int index) {
        if (index >= 0 && index < this.myArrayList.size()) {
            void var1_1;
            return this.myArrayList.remove((int)var1_1);
        }
        return null;
    }

    public final String toString() {
        try {
            return this.toString$47921032();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private String toString$47921032() throws JSONException {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            void var1_1;
            return this.write((Writer)var1_1, 0, 0).toString();
        }
    }

    /*
     * WARNING - void declaration
     */
    final Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        try {
            void var1_1;
            boolean commanate = false;
            int length = this.myArrayList.size();
            writer.write(91);
            if (length == 1) {
                JSONObject.writeValue(writer, this.myArrayList.get(0), indentFactor, indent);
            } else if (length != 0) {
                void var3_3;
                void var2_2;
                int newindent = indent + indentFactor;
                int i = 0;
                while (i < length) {
                    if (commanate) {
                        writer.write(44);
                    }
                    if (indentFactor > 0) {
                        writer.write(10);
                    }
                    JSONObject.indent(writer, newindent);
                    JSONObject.writeValue(writer, this.myArrayList.get(i), indentFactor, newindent);
                    commanate = true;
                    ++i;
                }
                if (var2_2 > 0) {
                    writer.write(10);
                }
                JSONObject.indent(writer, (int)var3_3);
            }
            writer.write(93);
            return var1_1;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }
}

