/*
 * Decompiled with CFR 0.152.
 */
package mc.ambientocclusion.xrayinstaller.gui;

import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import mc.ambientocclusion.xray.LWIO;
import mc.ambientocclusion.xrayinstaller.gui.MinecraftProfile;
import mc.ambientocclusion.xrayinstaller.gui.XRayInstaller;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public final class Patcher
extends SwingWorker<Object, Object> {
    private static Constructor<? extends ClassVisitor> xrayAdapter = null;
    private final MinecraftProfile oldProfile;
    private final MinecraftProfile newProfile;
    private final ArrayList<URL> sources = new ArrayList();
    private final HashSet<String> fileset = new HashSet();

    /*
     * WARNING - void declaration
     */
    public static ClassVisitor getXRayAdapter(ClassVisitor cv) {
        try {
            if (xrayAdapter == null) {
                xrayAdapter = Class.forName("mc.ambientocclusion.xrayinstaller.XRayClassAdapter").getConstructor(ClassVisitor.class);
            }
            return xrayAdapter.newInstance(cv);
        }
        catch (Exception e) {
            void var0_1;
            throw new Error("Package broken", (Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Patcher(MinecraftProfile oldProfile, MinecraftProfile newProfile) {
        void var2_2;
        void var1_1;
        this.oldProfile = var1_1;
        this.newProfile = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addSource(File f) {
        try {
            void var1_1;
            return this.sources.add(var1_1.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void done() {
        try {
            this.get();
            JOptionPane.showMessageDialog(null, "XRay has been installed successfully!", "XRayInstaller", 1);
            return;
        }
        catch (Exception e) {
            void var1_2;
            void var2_3;
            StringWriter errors = new StringWriter();
            e.printStackTrace();
            e.printStackTrace(new PrintWriter(errors));
            JPanel errorpanel = new JPanel();
            errorpanel.setLayout(new BoxLayout(errorpanel, 1));
            errorpanel.add(new JLabel("A serious error occurred - the details are below."));
            errorpanel.add(Box.createVerticalStrut(2));
            errorpanel.add(new JScrollPane(new JTextArea(var2_3.toString(), 8, 50)));
            JOptionPane.showMessageDialog(null, var1_2, "Error", 0);
            return;
        }
    }

    private void checkOptiFine(JSONObject json) throws MalformedURLException {
        String args = json.getString("minecraftArguments");
        if (args.contains("optifine.OptiFineTweaker")) {
            args = args.replaceAll("(?i)--tweakClass\\s+optifine.OptiFineTweaker", "").trim();
            json.put("minecraftArguments", args);
            json.put("mainClass", "net.minecraft.client.main.Main");
            String string = "libraries";
            Object object = json.get("libraries");
            if (!(object instanceof JSONArray)) {
                throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a JSONArray.");
            }
            JSONArray libraries = (JSONArray)object;
            int i = 0;
            while (i < libraries.length()) {
                int n;
                int n2 = n = i;
                object = libraries.opt(n);
                if (object == null) {
                    throw new JSONException("JSONArray[" + n2 + "] not found.");
                }
                if (!(object instanceof JSONObject)) {
                    throw new JSONException("JSONArray[" + n + "] is not a JSONObject.");
                }
                String[] lib = ((JSONObject)object).getString("name");
                if (lib.split(":", 3)[1].equals("OptiFine")) {
                    File optifine = new File(new File(new File(new File(new File(XRayInstaller.mcDirectory, "libraries"), (lib = lib.split(":", 3))[0].replace('.', File.pathSeparatorChar)), lib[1]), lib[2]), String.format("%s-%s.jar", lib[1], lib[2]));
                    if (optifine.exists() && optifine.isFile()) {
                        System.out.println("OptiFine library path: " + optifine);
                        this.sources.add(((File)object).toURI().toURL());
                    }
                    libraries.remove(i--);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createNewJar() throws Exception {
        void var2_1;
        JarOutputStream out = new JarOutputStream(LWIO.openOutputStream(this.newProfile.jar));
        try {
            for (URL source : this.sources) {
                System.out.println("Processing source: " + source);
                ZipInputStream zipStream = new ZipInputStream(source.openStream());
                try {
                    ZipEntry zipEntry;
                    while ((zipEntry = zipStream.getNextEntry()) != null) {
                        void zipEntry2;
                        String name = zipEntry2.getName();
                        if (name.startsWith("META-INF") || name.startsWith("org/apache") || name.startsWith("org/json") || name.startsWith("org/objectweb") || name.startsWith("mc/ambientocclusion/xrayinstaller") || !this.fileset.add(name)) continue;
                        out.putNextEntry(new JarEntry(name));
                        if (name.toLowerCase().endsWith(".class")) {
                            ClassReader cr = new ClassReader(zipStream);
                            ClassWriter cw = new ClassWriter(cr, 1);
                            ClassVisitor cv = Patcher.getXRayAdapter(cw);
                            ((ClassReader)((Object)zipEntry)).accept(cv, 0);
                            out.write(cw.toByteArray());
                            continue;
                        }
                        LWIO.copy((InputStream)zipStream, out);
                    }
                }
                finally {
                    LWIO.close(zipStream);
                }
            }
        }
        catch (Throwable throwable) {
            LWIO.close(out);
            throw throwable;
        }
        LWIO.close((Closeable)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void setLauncherVersion(String version) throws JSONException, IOException {
        File launcher_profile = new File(XRayInstaller.mcDirectory, "launcher_profiles.json");
        if (launcher_profile.exists()) {
            void var1_1;
            void var2_2;
            String string;
            System.out.println("Setting launch version: " + version);
            JSONObject json = new JSONObject(new String(LWIO.read(launcher_profile)));
            json.getJSONObject("profiles").getJSONObject(json.getString("selectedProfile")).put("lastVersionId", string);
            LWIO.copy(var2_2.toString(4).getBytes(), (File)var1_1);
        }
    }

    private static void cleanupOldForgeVersions(File dir) {
        if (dir.isDirectory()) {
            File[] fileArray = dir.listFiles(new FilenameFilter(){

                @Override
                public final boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".jar");
                }
            });
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File mod = fileArray[n2];
                boolean xrayjar = false;
                try {
                    JarFile jf = new JarFile(mod);
                    try {
                        xrayjar = jf.getManifest().getMainAttributes().getValue("Main-Class").contains("ambientocclusion");
                    }
                    finally {
                        jf.close();
                    }
                }
                catch (Exception exception) {}
                if (xrayjar) {
                    File file;
                    System.out.println("Deleting old version: " + mod.getName());
                    file.delete();
                }
                ++n2;
            }
        }
    }
}

