/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONString;
import org.json.JSONTokener;

public final class JSONObject {
    private final Map<String, Object> map = new HashMap<String, Object>();
    public static final Object NULL = new Null(0);

    public JSONObject() {
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(JSONTokener x) throws JSONException {
        this();
        void var1_1;
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            void var3_3;
            switch (x.nextClean()) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            if (x.nextClean() != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            Object object = x.nextValue();
            JSONObject jSONObject = this;
            if (var3_3 != null && object != null) {
                if (jSONObject.opt((String)var3_3) != null) {
                    throw new JSONException("Duplicate key \"" + (String)var3_3 + "\"");
                }
                jSONObject.put((String)var3_3, object);
            }
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw var1_1.syntaxError("Expected a ',' or '}'");
    }

    /*
     * WARNING - void declaration
     */
    private JSONObject(Map<String, Object> map) {
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                void var3_3;
                void var2_2;
                Object value = entry.getValue();
                if (value == null) continue;
                this.map.put((String)var2_2.getKey(), JSONObject.wrap(var3_3));
            }
        }
    }

    private JSONObject(Object bean) {
        this();
        JSONObject jSONObject;
        void var2_2 = jSONObject;
        jSONObject = this;
        Method[] methodArray = var2_2.getClass();
        methodArray = methodArray.getClassLoader() != null ? methodArray.getMethods() : methodArray.getDeclaredMethods();
        int n = 0;
        while (n < methodArray.length) {
            try {
                Object object = methodArray[n];
                if (Modifier.isPublic(((Method)object).getModifiers())) {
                    String string = ((Method)object).getName();
                    String string2 = "";
                    if (string.startsWith("get")) {
                        string2 = "getClass".equals(string) || "getDeclaringClass".equals(string) ? "" : string.substring(3);
                    } else if (string.startsWith("is")) {
                        string2 = string.substring(2);
                    }
                    if (string2.length() > 0 && Character.isUpperCase(string2.charAt(0)) && ((Method)object).getParameterTypes().length == 0) {
                        if (string2.length() == 1) {
                            string2 = string2.toLowerCase();
                        } else if (!Character.isUpperCase(string2.charAt(1))) {
                            string2 = String.valueOf(string2.substring(0, 1).toLowerCase()) + string2.substring(1);
                        }
                        object = ((Method)object).invoke((Object)var2_2, null);
                        if (object != null) {
                            jSONObject.map.put(string2, JSONObject.wrap(object));
                        }
                    }
                }
            }
            catch (Exception exception) {}
            ++n;
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(String source) throws JSONException {
        this(new JSONTokener((String)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Object get(String key) throws JSONException {
        void var2_2;
        if (key == null) {
            throw new JSONException("Null key.");
        }
        Object object = this.opt(key);
        if (object == null) {
            void var1_1;
            throw new JSONException("JSONObject[" + JSONObject.quote((String)var1_1) + "] not found.");
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final JSONObject getJSONObject(String key) throws JSONException {
        void var1_1;
        Object object = this.get(key);
        if (object instanceof JSONObject) {
            void var2_2;
            return (JSONObject)var2_2;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote((String)var1_1) + "] is not a JSONObject.");
    }

    /*
     * WARNING - void declaration
     */
    public final String getString(String key) throws JSONException {
        void var1_1;
        Object object = this.get(key);
        if (object instanceof String) {
            void var2_2;
            return (String)var2_2;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote((String)var1_1) + "] not a string.");
    }

    /*
     * WARNING - void declaration
     */
    public final Object opt(String key) {
        void var1_1;
        if (key == null) {
            return null;
        }
        return this.map.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final JSONObject put(String key, Object value) throws JSONException {
        void var2_2;
        if (key == null) {
            throw new NullPointerException("Null key.");
        }
        if (value != null) {
            JSONObject.testValidity(value);
            this.map.put(key, var2_2);
        } else {
            void var1_1;
            var2_2 = var1_1;
            this.map.remove(var2_2);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static String quote(String string) {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            try {
                void var1_1;
                String string2;
                return JSONObject.quote(string2, (Writer)var1_1).toString();
            }
            catch (IOException iOException) {
                return "";
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Writer quote(String string, Writer w) throws IOException {
        void var1_1;
        if (string == null || string.length() == 0) {
            w.write("\"\"");
            return w;
        }
        char c = '\u0000';
        int len = string.length();
        w.write(34);
        int i = 0;
        while (i < len) {
            block12: {
                char b = c;
                c = string.charAt(i);
                switch (c) {
                    case '\"': 
                    case '\\': {
                        w.write(92);
                        break;
                    }
                    case '/': {
                        if (b == '<') {
                            w.write(92);
                        }
                        w.write(c);
                        break block12;
                    }
                    case '\b': {
                        w.write("\\b");
                        break block12;
                    }
                    case '\t': {
                        w.write("\\t");
                        break block12;
                    }
                    case '\n': {
                        w.write("\\n");
                        break block12;
                    }
                    case '\f': {
                        w.write("\\f");
                        break block12;
                    }
                    case '\r': {
                        w.write("\\r");
                        break block12;
                    }
                    default: {
                        void var2_6;
                        if (c >= ' ' && (c < '\u0080' || c >= '\u00a0') && (c < '\u2000' || c >= '\u2100')) break;
                        w.write("\\u");
                        String hhhh = Integer.toHexString(c);
                        w.write("0000", 0, 4 - hhhh.length());
                        w.write((String)var2_6);
                        break block12;
                    }
                }
                w.write(c);
            }
            ++i;
        }
        w.write(34);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Object stringToValue(String string) {
        String string2;
        if (string.equals("")) {
            return string;
        }
        if (string.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("null")) {
            return NULL;
        }
        char b = string.charAt(0);
        if (b >= '0' && b <= '9' || b == '-') {
            try {
                if (string.indexOf(46) >= 0 || string.indexOf(101) >= 0 || string.indexOf(69) >= 0) {
                    Double d = Double.valueOf(string);
                    if (!d.isInfinite() && !d.isNaN()) {
                        return d;
                    }
                } else {
                    Long myLong = new Long(string);
                    if (string.equals(myLong.toString())) {
                        void var1_3;
                        if (myLong == (long)myLong.intValue()) {
                            return myLong.intValue();
                        }
                        return var1_3;
                    }
                }
            }
            catch (Exception exception) {}
        }
        return string2;
    }

    private static void testValidity(Object o) throws JSONException {
        Object object;
        if (o != null && (o instanceof Double ? ((Double)o).isInfinite() || ((Double)o).isNaN() : o instanceof Float && (((Float)o).isInfinite() || ((Float)object).isNaN()))) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    public final String toString() {
        try {
            return this.toString(0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final String toString(int indentFactor) throws JSONException {
        StringWriter w = new StringWriter();
        StringBuffer stringBuffer = w.getBuffer();
        synchronized (stringBuffer) {
            void var1_1;
            void var2_2;
            return this.write((Writer)var2_2, (int)var1_1, 0).toString();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object wrap(Object object) {
        try {
            Object object2;
            void var1_1;
            if (object == null) {
                return NULL;
            }
            if (object instanceof JSONObject || object instanceof JSONArray || NULL.equals(object) || object instanceof JSONString || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String) {
                return object;
            }
            if (object instanceof Collection) {
                return new JSONArray((Collection)object);
            }
            if (object.getClass().isArray()) {
                return new JSONArray(object);
            }
            if (object instanceof Map) {
                return new JSONObject((Map)object);
            }
            Package objectPackage = object.getClass().getPackage();
            String objectPackageName = objectPackage != null ? objectPackage.getName() : "";
            if (objectPackageName.startsWith("java.") || var1_1.startsWith("javax.") || object.getClass().getClassLoader() == null) {
                return object.toString();
            }
            return new JSONObject(object2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final Writer writeValue(Writer writer, Object value, int indentFactor, int indent) throws JSONException, IOException {
        Writer writer2;
        if (value == null || value.equals(null)) {
            writer.write("null");
        } else if (value instanceof JSONObject) {
            ((JSONObject)value).write(writer, indentFactor, indent);
        } else if (value instanceof JSONArray) {
            ((JSONArray)value).write(writer, indentFactor, indent);
        } else if (value instanceof Map) {
            new JSONObject((Map)value).write(writer, indentFactor, indent);
        } else if (value instanceof Collection) {
            new JSONArray((Collection)value).write(writer, indentFactor, indent);
        } else if (value.getClass().isArray()) {
            void var3_5;
            new JSONArray(value).write(writer, indentFactor, (int)var3_5);
        } else if (value instanceof Number) {
            if ((value = (Number)value) == null) {
                throw new JSONException("Null pointer");
            }
            JSONObject.testValidity(value);
            value = value.toString();
            if (((String)value).indexOf(46) > 0 && ((String)value).indexOf(101) < 0 && ((String)value).indexOf(69) < 0) {
                while (((String)value).endsWith("0")) {
                    value = ((String)value).substring(0, ((String)value).length() - 1);
                }
                if (((String)value).endsWith(".")) {
                    value = ((String)value).substring(0, ((String)value).length() - 1);
                }
            }
            writer.write((String)value);
        } else if (value instanceof Boolean) {
            writer.write(value.toString());
        } else if (value instanceof JSONString) {
            void var2_4;
            String o;
            try {
                o = ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                void var0_1;
                throw new JSONException((Throwable)var0_1);
            }
            writer2.write(o != null ? var2_4.toString() : JSONObject.quote(value.toString()));
        } else {
            void var1_2;
            JSONObject.quote(var1_2.toString(), writer2);
        }
        return writer2;
    }

    static final void indent(Writer writer, int indent) throws IOException {
        int i = 0;
        while (i < indent) {
            writer.write(32);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        try {
            void var1_1;
            void key2;
            boolean commanate = false;
            int length = this.map.size();
            Iterator<String> keys = this.map.keySet().iterator();
            writer.write(123);
            if (length == 1) {
                String key2 = keys.next();
                writer.write(JSONObject.quote(key2.toString()));
                writer.write(58);
                if (indentFactor > 0) {
                    writer.write(32);
                }
                JSONObject.writeValue(writer, this.map.get(key2), indentFactor, indent);
            } else if (key2 != false) {
                void var3_3;
                void var2_2;
                int newindent = indent + indentFactor;
                while (keys.hasNext()) {
                    String key3 = keys.next();
                    if (commanate) {
                        writer.write(44);
                    }
                    if (indentFactor > 0) {
                        writer.write(10);
                    }
                    JSONObject.indent(writer, newindent);
                    writer.write(JSONObject.quote(key3.toString()));
                    writer.write(58);
                    if (indentFactor > 0) {
                        writer.write(32);
                    }
                    JSONObject.writeValue(writer, this.map.get(key3), indentFactor, newindent);
                    commanate = true;
                }
                if (var2_2 > 0) {
                    writer.write(10);
                }
                JSONObject.indent(writer, (int)var3_3);
            }
            writer.write(125);
            return var1_1;
        }
        catch (IOException exception) {
            throw new JSONException(exception);
        }
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object object) {
            void var1_1;
            return object == null || var1_1 == this;
        }

        public final String toString() {
            return "null";
        }

        /* synthetic */ Null(byte by) {
            this();
        }
    }
}

