/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JSONTokener {
    private long character;
    private boolean eof;
    private long index;
    private long line;
    private char previous;
    private Reader reader;
    private boolean usePrevious;

    /*
     * WARNING - void declaration
     */
    private JSONTokener(Reader reader) {
        void var1_1;
        this.reader = reader.markSupported() ? reader : new BufferedReader((Reader)var1_1);
        this.eof = false;
        this.usePrevious = false;
        this.previous = '\u0000';
        this.index = 0L;
        this.character = 1L;
        this.line = 1L;
    }

    /*
     * WARNING - void declaration
     */
    public JSONTokener(String s) {
        this(new StringReader((String)var1_1));
        void var1_1;
    }

    public final void back() throws JSONException {
        if (this.usePrevious || this.index <= 0L) {
            throw new JSONException("Stepping back two steps is not supported");
        }
        --this.index;
        --this.character;
        this.usePrevious = true;
        this.eof = false;
    }

    /*
     * WARNING - void declaration
     */
    private char next() throws JSONException {
        void var1_1;
        int c;
        if (this.usePrevious) {
            this.usePrevious = false;
            c = this.previous;
        } else {
            try {
                c = this.reader.read();
            }
            catch (IOException exception) {
                throw new JSONException(exception);
            }
            if (c <= 0) {
                this.eof = true;
                c = 0;
            }
        }
        ++this.index;
        if (this.previous == '\r') {
            ++this.line;
            this.character = c == 10 ? 0 : 1;
        } else if (c == 10) {
            ++this.line;
            this.character = 0L;
        } else {
            ++this.character;
        }
        this.previous = (char)var1_1;
        return this.previous;
    }

    /*
     * WARNING - void declaration
     */
    private String next$47921032() throws JSONException {
        void var1_1;
        char[] chars = new char[4];
        int pos = 0;
        while (pos < 4) {
            chars[pos] = this.next();
            JSONTokener jSONTokener = this;
            if (jSONTokener.eof && !jSONTokener.usePrevious) {
                throw this.syntaxError("Substring bounds error");
            }
            ++pos;
        }
        return new String((char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final char nextClean() throws JSONException {
        void var1_1;
        char c;
        while ((c = this.next()) != '\u0000' && c <= ' ') {
        }
        return (char)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Object nextValue() throws JSONException {
        void var1_3;
        void var2_5;
        char c3 = this.nextClean();
        switch (c3) {
            case '\"': 
            case '\'': {
                char c2 = c3;
                JSONTokener c3 = this;
                StringBuilder stringBuilder = new StringBuilder();
                block18: while (true) {
                    char c4 = c3.next();
                    switch (c4) {
                        case '\u0000': 
                        case '\n': 
                        case '\r': {
                            throw c3.syntaxError("Unterminated string");
                        }
                        case '\\': {
                            c4 = c3.next();
                            switch (c4) {
                                case 'b': {
                                    stringBuilder.append('\b');
                                    continue block18;
                                }
                                case 't': {
                                    stringBuilder.append('\t');
                                    continue block18;
                                }
                                case 'n': {
                                    stringBuilder.append('\n');
                                    continue block18;
                                }
                                case 'f': {
                                    stringBuilder.append('\f');
                                    continue block18;
                                }
                                case 'r': {
                                    stringBuilder.append('\r');
                                    continue block18;
                                }
                                case 'u': {
                                    stringBuilder.append((char)Integer.parseInt(c3.next$47921032(), 16));
                                    continue block18;
                                }
                                case '\"': 
                                case '\'': 
                                case '/': 
                                case '\\': {
                                    stringBuilder.append(c4);
                                    continue block18;
                                }
                            }
                            throw c3.syntaxError("Illegal escape.");
                        }
                    }
                    if (c4 == c2) {
                        return stringBuilder.toString();
                    }
                    stringBuilder.append(c4);
                }
            }
            case '{': {
                this.back();
                return new JSONObject(this);
            }
            case '[': {
                this.back();
                return new JSONArray(this);
            }
        }
        StringBuilder sb = new StringBuilder();
        while (c3 >= ' ' && ",:]}/\\\"[{;=#".indexOf(c3) < 0) {
            sb.append(c3);
            c3 = this.next();
        }
        this.back();
        String string = var2_5.toString().trim();
        if ("".equals(string)) {
            throw this.syntaxError("Missing value");
        }
        return JSONObject.stringToValue((String)var1_3);
    }

    /*
     * WARNING - void declaration
     */
    public final JSONException syntaxError(String message) {
        void var1_1;
        return new JSONException(String.valueOf(var1_1) + this.toString());
    }

    public final String toString() {
        return " at " + this.index + " [character " + this.character + " line " + this.line + "]";
    }
}

