/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft;

import cpw.mods.fml.common.event.FMLInterModComms;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.entities.DrugHelper;
import ivorius.psychedelicraft.entities.DrugInfluence;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;

public class PSCommunicationHandler {
    public void onIMCMessage(FMLInterModComms.IMCMessage message, boolean server, boolean runtime) {
        try {
            if (this.isMessage("drugAddValue", message, NBTTagCompound.class)) {
                NBTTagCompound cmp = message.getNBTValue();
                this.getDrugHelper(cmp, server).addToDrug(cmp.func_74779_i("drugName"), cmp.func_74760_g("drugValue"));
            } else if (this.isMessage("drugAddInfluence", message, NBTTagCompound.class)) {
                NBTTagCompound cmp = message.getNBTValue();
                DrugInfluence influence = new DrugInfluence(cmp.func_74779_i("drugName"), cmp.func_74762_e("drugInfluenceDelay"), cmp.func_74769_h("drugInfluenceSpeed"), cmp.func_74769_h("drugInfluenceSpeedAdd"), cmp.func_74769_h("drugTotalEffect"));
                this.getDrugHelper(cmp, server).addToDrug(influence);
            } else if (this.isMessage("drugSetValue", message, NBTTagCompound.class)) {
                NBTTagCompound cmp = message.getNBTValue();
                this.getDrugHelper(cmp, server).setDrugValue(cmp.func_74779_i("drugName"), cmp.func_74760_g("drugValue"));
            } else if (this.isMessage("drugSetLocked", message, NBTTagCompound.class)) {
                NBTTagCompound cmp = message.getNBTValue();
                this.getDrugHelper(cmp, server).getDrug(cmp.func_74779_i("drugName")).setLocked(cmp.func_74767_n("drugLocked"));
            } else if (this.isMessage("drugGetValue", message, NBTTagCompound.class)) {
                NBTTagCompound cmp = message.getNBTValue();
                NBTTagCompound response = (NBTTagCompound)cmp.func_74737_b();
                response.func_74776_a("drugValue", this.getDrugHelper(cmp, server).getDrugValue(cmp.func_74779_i("drugName")));
                this.sendReply(message, response);
            } else if (this.isMessage("drugIsLocked", message, NBTTagCompound.class)) {
                NBTTagCompound cmp = message.getNBTValue();
                NBTTagCompound response = (NBTTagCompound)cmp.func_74737_b();
                response.func_74757_a("drugLocked", this.getDrugHelper(cmp, server).getDrug(cmp.func_74779_i("drugName")).isLocked());
                this.sendReply(message, response);
            }
        }
        catch (Exception ex) {
            Psychedelicraft.logger.error("Message error! Exception on message with key '" + message.key + "' of type '" + message.getMessageType().getName() + "'");
            ex.printStackTrace();
        }
    }

    private boolean isMessage(String key, FMLInterModComms.IMCMessage message, Class expectedType) {
        if (key.equals(message.key)) {
            if (message.getMessageType().isAssignableFrom(expectedType)) {
                return true;
            }
            this.faultyMessage(message, expectedType);
        }
        return false;
    }

    private Entity getEntity(NBTTagCompound compound, boolean server) {
        return this.getEntity(compound, "worldID", "entityID", server);
    }

    private Entity getEntity(NBTTagCompound compound, String worldKey, String entityKey, boolean server) {
        if (!server) {
            return Minecraft.func_71410_x().field_71441_e.func_73045_a(compound.func_74762_e(entityKey));
        }
        return MinecraftServer.func_71276_C().func_71218_a(compound.func_74762_e(worldKey)).func_73045_a(compound.func_74762_e(entityKey));
    }

    private DrugHelper getDrugHelper(NBTTagCompound compound, boolean server) {
        return DrugHelper.getDrugHelper(this.getEntity(compound, server));
    }

    private boolean sendReply(FMLInterModComms.IMCMessage message, String value) {
        if (message.getSender() == null) {
            return false;
        }
        NBTTagCompound cmp = message.getNBTValue();
        FMLInterModComms.sendRuntimeMessage((Object)"psychedelicraft", (String)message.getSender(), (String)cmp.func_74779_i("replyKey"), (String)value);
        return true;
    }

    private boolean sendReply(FMLInterModComms.IMCMessage message, NBTTagCompound value) {
        if (message.getSender() == null) {
            return false;
        }
        NBTTagCompound cmp = message.getNBTValue();
        FMLInterModComms.sendRuntimeMessage((Object)"psychedelicraft", (String)message.getSender(), (String)cmp.func_74779_i("replyKey"), (NBTTagCompound)value);
        return true;
    }

    private boolean sendReply(FMLInterModComms.IMCMessage message, ItemStack value) {
        if (message.getSender() == null) {
            Psychedelicraft.logger.error("Message error! Could not reply to message with key '" + message.key + "' - No sender found");
            return false;
        }
        NBTTagCompound cmp = message.getNBTValue();
        FMLInterModComms.sendRuntimeMessage((Object)"psychedelicraft", (String)message.getSender(), (String)cmp.func_74779_i("replyKey"), (ItemStack)value);
        return true;
    }

    private void faultyMessage(FMLInterModComms.IMCMessage message, Class expectedType) {
        Psychedelicraft.logger.error("Message error! Got message with key '" + message.key + "' of type '" + message.getMessageType().getName() + "'; Expected type: '" + expectedType.getName() + "'");
    }
}

