/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ivorius.pscoreutils.events.GLActiveTextureEvent;
import ivorius.pscoreutils.events.GLBlendFuncEvent;
import ivorius.pscoreutils.events.GLClearEvent;
import ivorius.pscoreutils.events.GLFogiEvent;
import ivorius.pscoreutils.events.GLStateFixEvent;
import ivorius.pscoreutils.events.GLSwitchEvent;
import ivorius.pscoreutils.events.GetSoundVolumeEvent;
import ivorius.pscoreutils.events.ItemLightingEvent;
import ivorius.pscoreutils.events.LightmapSwitchEvent;
import ivorius.pscoreutils.events.OrientCameraEvent;
import ivorius.pscoreutils.events.RenderBlockOverlayEvent;
import ivorius.pscoreutils.events.RenderEntitiesEvent;
import ivorius.pscoreutils.events.RenderHandEvent;
import ivorius.pscoreutils.events.RenderHeldItemEvent;
import ivorius.pscoreutils.events.RenderWorldEvent;
import ivorius.pscoreutils.events.SetPlayerAnglesEvent;
import ivorius.pscoreutils.events.SetupCameraTransformEvent;
import ivorius.psychedelicraft.client.rendering.DrugEffectInterpreter;
import ivorius.psychedelicraft.client.rendering.SmoothCameraHelper;
import ivorius.psychedelicraft.client.rendering.shaders.DrugShaderHelper;
import ivorius.psychedelicraft.entities.DrugHelper;
import ivorius.psychedelicraftcore.PsycheCoreBusCommon;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class PSCoreHandlerClient {
    private final Vec3 field_82884_b = Vec3.func_72443_a((double)0.2f, (double)1.0, (double)-0.7f).func_72432_b();
    private final Vec3 field_82885_c = Vec3.func_72443_a((double)-0.2f, (double)1.0, (double)0.7f).func_72432_b();
    private int lastActiveTexture = OpenGlHelper.field_77478_a;

    public void register() {
        PsycheCoreBusCommon.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void renderWorld(RenderWorldEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        float partialTicks = event.partialTicks;
        float ticks = partialTicks + (float)mc.field_71456_v.func_73834_c();
        if (event instanceof RenderWorldEvent.Pre) {
            int rendererUpdateCount = Minecraft.func_71410_x().field_71456_v.func_73834_c();
            DrugShaderHelper.preRender(partialTicks + (float)rendererUpdateCount);
            for (String s : DrugShaderHelper.getRenderPasses(partialTicks)) {
                if (s.equals("Default") || !DrugShaderHelper.startRenderPass(s, partialTicks, ticks)) continue;
                Minecraft.func_71410_x().field_71460_t.func_78471_a(partialTicks, 0L);
                DrugShaderHelper.endRenderPass();
            }
            DrugShaderHelper.startRenderPass("Default", partialTicks, ticks);
            DrugShaderHelper.preRender3D(ticks);
        } else if (event instanceof RenderWorldEvent.Post) {
            DrugShaderHelper.endRenderPass();
            DrugHelper drugHelper = DrugHelper.getDrugHelper((Entity)mc.field_71451_h);
            if (drugHelper != null && drugHelper.drugRenderer != null) {
                drugHelper.drugRenderer.renderOverlaysBeforeShaders(event.partialTicks, mc.field_71451_h, mc.field_71456_v.func_73834_c(), mc.field_71443_c, mc.field_71440_d, drugHelper);
            }
            DrugShaderHelper.postRender(ticks, partialTicks);
        }
    }

    @SubscribeEvent
    public void orientCamera(OrientCameraEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityLivingBase renderEntity = mc.field_71451_h;
        DrugHelper drugHelper = DrugHelper.getDrugHelper((Entity)renderEntity);
        int rendererUpdateCount = renderEntity.field_70173_aa;
        if (drugHelper != null && drugHelper.drugRenderer != null) {
            drugHelper.drugRenderer.distortScreen(event.partialTicks, renderEntity, rendererUpdateCount, drugHelper);
        }
    }

    @SubscribeEvent
    public void psycheGLEnable(GLSwitchEvent event) {
        boolean enable = event instanceof GLSwitchEvent.Enable;
        if (event.cap == 3553) {
            if (this.getLastActiveTexture() == OpenGlHelper.field_77478_a) {
                DrugShaderHelper.setTexture2DEnabled(enable);
            } else if (this.getLastActiveTexture() == OpenGlHelper.field_77476_b) {
                DrugShaderHelper.setLightmapEnabled(enable);
            }
        } else if (event.cap == 2912) {
            DrugShaderHelper.setFogEnabled(enable);
        }
    }

    @SubscribeEvent
    public void psycheGLBlendFunc(GLBlendFuncEvent event) {
        if (event.sFactor == 770 && event.dFactor == 1) {
            DrugShaderHelper.setBlendFunc(1);
        } else {
            DrugShaderHelper.setBlendFunc(771);
        }
    }

    @SubscribeEvent
    public void psycheGLActiveTexture(GLActiveTextureEvent event) {
        this.lastActiveTexture = event.texture;
    }

    public int getLastActiveTexture() {
        return this.lastActiveTexture;
    }

    @SubscribeEvent
    public void standardItemLighting(ItemLightingEvent event) {
        if (event instanceof ItemLightingEvent.Enable) {
            float var0 = 0.4f;
            float var1 = 0.6f;
            float var2 = 0.0f;
            DrugShaderHelper.setGLLightEnabled(true);
            DrugShaderHelper.setGLLight(0, (float)this.field_82884_b.field_72450_a, (float)this.field_82884_b.field_72448_b, (float)this.field_82884_b.field_72449_c, var1, var2);
            DrugShaderHelper.setGLLight(1, (float)this.field_82885_c.field_72450_a, (float)this.field_82885_c.field_72448_b, (float)this.field_82885_c.field_72449_c, var1, var2);
            DrugShaderHelper.setGLLightAmbient(var0);
        } else {
            DrugShaderHelper.setGLLightEnabled(false);
        }
    }

    @SubscribeEvent
    public void renderHeldItem(RenderHeldItemEvent event) {
        float partialTicks = event.partialTicks;
        Minecraft mc = Minecraft.func_71410_x();
        int rendererUpdateCount = mc.field_71456_v.func_73834_c();
        if (mc.field_71451_h instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)mc.field_71451_h;
            DrugHelper drugHelper = DrugHelper.getDrugHelper((Entity)player);
            float shiftX = DrugEffectInterpreter.getHandShiftX(drugHelper, (float)rendererUpdateCount + partialTicks);
            float shiftY = DrugEffectInterpreter.getHandShiftY(drugHelper, (float)rendererUpdateCount + partialTicks);
            GL11.glTranslatef((float)shiftX, (float)shiftY, (float)0.0f);
        }
    }

    @SubscribeEvent
    public void renderEntities(RenderEntitiesEvent event) {
        int pass = MinecraftForgeClient.getRenderPass();
        if (pass == 1) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityLivingBase renderEntity = mc.field_71451_h;
            DrugHelper drugHelper = DrugHelper.getDrugHelper((Entity)renderEntity);
            if (drugHelper != null && drugHelper.drugRenderer != null) {
                drugHelper.drugRenderer.renderAllHallucinations(event.partialTicks, drugHelper);
            }
        }
    }

    @SubscribeEvent
    public void renderHand(RenderHandEvent event) {
        if (event instanceof RenderHandEvent.Pre) {
            if (!"Default".equals(DrugShaderHelper.currentRenderPass)) {
                DrugShaderHelper.setDepthMultiplier(0.0f);
                event.setCanceled(true);
            }
        } else if (event instanceof RenderHandEvent.Post && !"Default".equals(DrugShaderHelper.currentRenderPass)) {
            DrugShaderHelper.setDepthMultiplier(1.0f);
        }
    }

    @SubscribeEvent
    public void setPlayerAngles(SetPlayerAnglesEvent event) {
        float partialTicks = event.partialTicks;
        Minecraft mc = Minecraft.func_71410_x();
        EntityLivingBase renderEntity = mc.field_71451_h;
        DrugHelper drugHelper = DrugHelper.getDrugHelper((Entity)renderEntity);
        float smoothness = DrugEffectInterpreter.getSmoothVision(drugHelper);
        if (smoothness < 1.0f && mc.field_71415_G) {
            float deltaX = mc.field_71417_B.field_74377_a;
            float deltaY = mc.field_71417_B.field_74375_b;
            float[] angles = SmoothCameraHelper.instance.getAngles(mc.field_71474_y.field_74341_c, partialTicks, deltaX, deltaY, mc.field_71474_y.field_74338_d);
            if (!mc.field_71474_y.field_74326_T) {
                float[] originalAngles = SmoothCameraHelper.instance.getOriginalAngles(mc.field_71474_y.field_74341_c, partialTicks, deltaX, deltaY, mc.field_71474_y.field_74338_d);
                renderEntity.func_70082_c(angles[0] - originalAngles[0], angles[1] - originalAngles[1]);
            } else {
                renderEntity.func_70082_c(angles[0], angles[1]);
            }
        }
    }

    @SubscribeEvent
    public void psycheGLFogi(GLFogiEvent event) {
        if (event.pname == 2917) {
            DrugShaderHelper.setFogMode(event.param);
        }
    }

    @SubscribeEvent
    public void getSoundVolume(GetSoundVolumeEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        DrugHelper drugHelper = DrugHelper.getDrugHelper((Entity)mc.field_71451_h);
        if (drugHelper != null) {
            event.volume = MathHelper.func_76131_a((float)(event.volume * drugHelper.getSoundMultiplier()), (float)0.0f, (float)1.0f);
        }
    }

    @SubscribeEvent
    public void setupCameraTransform(SetupCameraTransformEvent event) {
        if (DrugShaderHelper.setupCameraTransform()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void renderBlockOverlay(RenderBlockOverlayEvent event) {
        if (!"Default".equals(DrugShaderHelper.currentRenderPass)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void fixGLState(GLStateFixEvent event) {
        DrugShaderHelper.setUseScreenTexCoords(false);
        DrugShaderHelper.setTexture2DEnabled(true);
    }

    @SubscribeEvent
    public void lightmapSwitched(LightmapSwitchEvent event) {
        if (event instanceof LightmapSwitchEvent.Enable) {
            DrugShaderHelper.setLightmapEnabled(true);
        } else {
            DrugShaderHelper.setLightmapEnabled(false);
        }
    }

    @SubscribeEvent
    public void glClear(GLClearEvent event) {
        event.currentMask &= DrugShaderHelper.getCurrentAllowedGLDataMask();
    }
}

