/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.blocks;

import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import io.netty.buffer.ByteBuf;
import ivorius.ivtoolkit.bezier.IvBezierPath3D;
import ivorius.ivtoolkit.blocks.IvTileEntityHelper;
import ivorius.ivtoolkit.math.IvMathHelper;
import ivorius.ivtoolkit.network.IvNetworkHelperServer;
import ivorius.ivtoolkit.network.PartialUpdateHandler;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.entities.DrugHelper;
import ivorius.psychedelicraft.entities.EntityRealityRift;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityRiftJar
extends TileEntity
implements PartialUpdateHandler {
    public float currentRiftFraction;
    public int ticksAliveVisual;
    public boolean isOpening;
    public float fractionOpen;
    public boolean jarBroken = false;
    public boolean suckingRifts = true;
    public float fractionHandleUp;
    public ArrayList<JarRiftConnection> riftConnections = new ArrayList();

    public void func_145845_h() {
        this.fractionOpen = IvMathHelper.nearValue((float)this.fractionOpen, (float)(this.isOpening ? 1.0f : 0.0f), (float)0.0f, (float)0.02f);
        this.fractionHandleUp = IvMathHelper.nearValue((float)this.fractionHandleUp, (float)(this.isSuckingRifts() ? 0.0f : 1.0f), (float)0.0f, (float)0.04f);
        if (this.isSuckingRifts()) {
            List<EntityRealityRift> rifts;
            if (this.fractionOpen > 0.0f && (rifts = this.getAffectedRifts()).size() > 0) {
                float minus = 1.0f / (float)rifts.size() * 0.001f * this.fractionOpen;
                for (EntityRealityRift rift : rifts) {
                    this.currentRiftFraction += rift.takeFromRift(minus);
                    JarRiftConnection connection = this.createAndGetRiftConnection(rift);
                    connection.fractionUp += 0.02f * this.fractionOpen;
                    if (!(connection.fractionUp > 1.0f)) continue;
                    connection.fractionUp = 1.0f;
                }
            }
        } else if (this.fractionOpen > 0.0f) {
            float minus = Math.min(4.0E-4f * this.fractionOpen * this.currentRiftFraction + 4.0E-4f, this.currentRiftFraction);
            List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - 5.0f), (double)((float)this.field_145848_d - 5.0f), (double)((float)this.field_145849_e - 2.0f), (double)((float)this.field_145851_c + 6.0f), (double)((float)this.field_145848_d + 6.0f), (double)((float)this.field_145849_e + 6.0f)));
            for (EntityLivingBase entity : entities) {
                double effect = (5.0 - entity.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5)) * (double)0.2f * (double)minus;
                DrugHelper drugHelper = DrugHelper.getDrugHelper((Entity)entity);
                if (drugHelper == null) continue;
                drugHelper.addToDrug("Zero", effect * 5.0);
                drugHelper.addToDrug("Power", effect * 35.0);
            }
            this.currentRiftFraction -= minus;
        }
        Iterator<JarRiftConnection> jarRiftConnectionIterator = this.riftConnections.iterator();
        while (jarRiftConnectionIterator.hasNext()) {
            JarRiftConnection connection = jarRiftConnectionIterator.next();
            connection.fractionUp -= 0.01f;
            if (!(connection.fractionUp <= 0.0f)) continue;
            jarRiftConnectionIterator.remove();
        }
        if (this.currentRiftFraction > 1.0f) {
            this.jarBroken = true;
            this.releaseRift();
            this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150350_a);
            this.field_145850_b.func_72876_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 1.0f, false);
        }
        ++this.ticksAliveVisual;
    }

    public JarRiftConnection createAndGetRiftConnection(EntityRealityRift rift) {
        for (JarRiftConnection connection : this.riftConnections) {
            if (connection.riftID != rift.func_145782_y()) continue;
            return connection;
        }
        JarRiftConnection newConnection = new JarRiftConnection();
        newConnection.riftID = rift.func_145782_y();
        newConnection.fractionUp = 0.0f;
        newConnection.entityX = rift.field_70165_t;
        newConnection.entityY = rift.field_70163_u + (double)rift.field_70131_O * 0.5;
        newConnection.entityZ = rift.field_70161_v;
        this.riftConnections.add(newConnection);
        return newConnection;
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74776_a("currentRiftFraction", this.currentRiftFraction);
        nbttagcompound.func_74757_a("isOpening", this.isOpening);
        nbttagcompound.func_74776_a("fractionOpen", this.fractionOpen);
        nbttagcompound.func_74757_a("jarBroken", this.jarBroken);
        nbttagcompound.func_74757_a("suckingRifts", this.suckingRifts);
        nbttagcompound.func_74776_a("fractionHandleUp", this.fractionHandleUp);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.currentRiftFraction = nbttagcompound.func_74760_g("currentRiftFraction");
        this.isOpening = nbttagcompound.func_74767_n("isOpening");
        this.fractionOpen = nbttagcompound.func_74760_g("fractionOpen");
        this.jarBroken = nbttagcompound.func_74767_n("jarBroken");
        this.suckingRifts = nbttagcompound.func_74767_n("suckingRifts");
        this.fractionHandleUp = nbttagcompound.func_74760_g("fractionHandleUp");
    }

    public int getBlockRotation() {
        return this.func_145832_p();
    }

    public void toggleRiftJarOpen() {
        if (!this.field_145850_b.field_72995_K) {
            this.isOpening = !this.isOpening;
            this.func_70296_d();
            IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"isOpening", (SimpleNetworkWrapper)Psychedelicraft.network, (Object[])new Object[0]);
        }
    }

    public void toggleSuckingRifts() {
        if (!this.field_145850_b.field_72995_K) {
            this.suckingRifts = !this.suckingRifts;
            this.func_70296_d();
            IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"suckingRifts", (SimpleNetworkWrapper)Psychedelicraft.network, (Object[])new Object[0]);
        }
    }

    public boolean isSuckingRifts() {
        return this.suckingRifts;
    }

    public void releaseRift() {
        if (this.currentRiftFraction > 0.0f) {
            List<EntityRealityRift> rifts = this.getAffectedRifts();
            if (rifts.size() > 0) {
                rifts.get(0).addToRift(this.currentRiftFraction);
            } else if (!this.field_145850_b.field_72995_K) {
                EntityRealityRift rift = new EntityRealityRift(this.field_145850_b);
                rift.func_70107_b((float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 3.0f, (float)this.field_145849_e + 0.5f);
                rift.setRiftSize(this.currentRiftFraction);
                this.field_145850_b.func_72838_d((Entity)rift);
            }
            this.currentRiftFraction = 0.0f;
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - 10.0f), (double)((float)this.field_145848_d - 5.0f), (double)((float)this.field_145849_e - 10.0f), (double)((float)this.field_145851_c + 11.0f), (double)((float)this.field_145848_d + 11.0f), (double)((float)this.field_145849_e + 11.0f));
    }

    public List<EntityRealityRift> getAffectedRifts() {
        return this.field_145850_b.func_72872_a(EntityRealityRift.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - 2.0f), (double)((float)this.field_145848_d + 0.0f), (double)((float)this.field_145849_e - 2.0f), (double)((float)this.field_145851_c + 3.0f), (double)((float)this.field_145848_d + 10.0f), (double)((float)this.field_145849_e + 3.0f)));
    }

    public Packet func_145844_m() {
        return IvTileEntityHelper.getStandardDescriptionPacket((TileEntity)this);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void writeUpdateData(ByteBuf buffer, String context, Object ... params) {
        if ("isOpening".equals(context)) {
            buffer.writeBoolean(this.isOpening);
        } else if ("suckingRifts".equals(context)) {
            buffer.writeBoolean(this.suckingRifts);
        }
    }

    public void readUpdateData(ByteBuf buffer, String context) {
        if ("isOpening".equals(context)) {
            this.isOpening = buffer.readBoolean();
        } else if ("suckingRifts".equals(context)) {
            this.suckingRifts = buffer.readBoolean();
        }
    }

    public static class JarRiftConnection {
        public int riftID;
        public double entityX;
        public double entityY;
        public double entityZ;
        public IvBezierPath3D bezierPath3D;
        public float fractionUp;
    }
}

