/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.rendering;

import ivorius.ivtoolkit.math.IvMathHelper;
import ivorius.ivtoolkit.rendering.IvOpenGLHelper;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.client.rendering.DrugEffectInterpreter;
import ivorius.psychedelicraft.client.rendering.EffectLensFlare;
import ivorius.psychedelicraft.client.rendering.IDrugRenderer;
import ivorius.psychedelicraft.client.rendering.shaders.DrugShaderHelper;
import ivorius.psychedelicraft.entities.DrugHallucination;
import ivorius.psychedelicraft.entities.DrugHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class DrugRenderer
implements IDrugRenderer {
    public ResourceLocation hurtOverlay = new ResourceLocation("psychedelicraft", Psychedelicraft.filePathTextures + "hurtOverlay.png");
    public ResourceLocation coffeeOverlay = new ResourceLocation("psychedelicraft", Psychedelicraft.filePathTextures + "coffeeOverlayBlend.png");
    public ResourceLocation powerParticle = new ResourceLocation("psychedelicraft", Psychedelicraft.filePathTextures + "powerParticle.png");
    public ResourceLocation[] lightningTextures = new ResourceLocation[4];
    public float experiencedHealth = 5.0f;
    public int timeScreenWet;
    public boolean wasInWater;
    public boolean wasInRain;
    public float currentHeat;
    public EffectLensFlare effectLensFlare;

    public DrugRenderer() {
        int i;
        for (i = 0; i < this.lightningTextures.length; ++i) {
            this.lightningTextures[i] = new ResourceLocation("psychedelicraft", Psychedelicraft.filePathTextures + "lightning" + i + ".png");
        }
        this.effectLensFlare = new EffectLensFlare();
        this.effectLensFlare.sunFlareSizes = new float[]{0.15f, 0.24f, 0.12f, 0.036f, 0.06f, 0.048f, 0.006f, 0.012f, 0.5f, 0.09f, 0.036f, 0.09f, 0.06f, 0.05f, 0.6f};
        this.effectLensFlare.sunFlareInfluences = new float[]{-1.3f, -2.0f, 0.2f, 0.4f, 0.25f, -0.25f, -0.7f, -1.0f, 1.0f, 1.4f, -1.31f, -1.2f, -1.5f, -1.55f, -3.0f};
        this.effectLensFlare.sunBlindnessTexture = new ResourceLocation("psychedelicraft", Psychedelicraft.filePathTextures + "sunBlindness.png");
        this.effectLensFlare.sunFlareTextures = new ResourceLocation[this.effectLensFlare.sunFlareSizes.length];
        for (i = 0; i < this.effectLensFlare.sunFlareTextures.length; ++i) {
            this.effectLensFlare.sunFlareTextures[i] = new ResourceLocation("psychedelicraft", Psychedelicraft.filePathTextures + "flare" + i + ".png");
        }
    }

    @Override
    public void update(DrugHelper drugHelper, EntityLivingBase entity) {
        Block bID;
        if (DrugHelper.hurtOverlayEnabled) {
            this.experiencedHealth = IvMathHelper.nearValue((float)this.experiencedHealth, (float)entity.func_110143_aJ(), (float)0.01f, (float)0.01f);
        }
        if (DrugShaderHelper.sunFlareIntensity > 0.0f) {
            this.effectLensFlare.updateLensFlares();
        }
        boolean bl = this.wasInWater = (bID = ActiveRenderInfo.func_151460_a((World)entity.field_70170_p, (EntityLivingBase)entity, (float)1.0f)).func_149688_o() == Material.field_151586_h;
        if (DrugHelper.waterOverlayEnabled) {
            --this.timeScreenWet;
            if (this.wasInWater) {
                this.timeScreenWet += 20;
            }
            if (this.wasInRain) {
                this.timeScreenWet += 4;
            }
            this.timeScreenWet = MathHelper.func_76125_a((int)this.timeScreenWet, (int)0, (int)100);
        }
        int playerX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int playerY = MathHelper.func_76128_c((double)entity.field_70163_u);
        int playerZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        float newHeat = entity.field_70170_p.getBiomeGenForCoordsBody(playerX, playerZ).func_150564_a(playerX, playerY, playerZ);
        this.currentHeat = IvMathHelper.nearValue((float)this.currentHeat, (float)newHeat, (float)0.01f, (float)0.01f);
    }

    @Override
    public void distortScreen(float par1, EntityLivingBase entity, int rendererUpdateCount, DrugHelper drugHelper) {
        float wobblyness = drugHelper.getDrugValue("Alcohol") * 0.5f + drugHelper.getDrugValue("Cannabis") * 0.02f + drugHelper.getDrugValue("BrownShrooms") * 0.03f + drugHelper.getDrugValue("RedShrooms") * 0.03f;
        if (wobblyness > 1.0f) {
            wobblyness = 1.0f;
        }
        if (wobblyness > 0.0f) {
            float f4 = 5.0f / (wobblyness * wobblyness + 5.0f) - wobblyness * 0.04f;
            f4 *= f4;
            float sin1 = MathHelper.func_76126_a((float)(((float)rendererUpdateCount + par1) / 150.0f * (float)Math.PI));
            float sin2 = MathHelper.func_76126_a((float)(((float)rendererUpdateCount + par1) / 170.0f * (float)Math.PI));
            float sin3 = MathHelper.func_76126_a((float)(((float)rendererUpdateCount + par1) / 190.0f * (float)Math.PI));
            GL11.glRotatef((float)(((float)rendererUpdateCount + par1) * 3.0f), (float)0.0f, (float)1.0f, (float)1.0f);
            GL11.glScalef((float)(1.0f / (f4 + wobblyness * sin1 / 2.0f)), (float)(1.0f / (f4 + wobblyness * sin2 / 2.0f)), (float)(1.0f / (f4 + wobblyness * sin3 / 2.0f)));
            GL11.glRotatef((float)(-((float)rendererUpdateCount + par1) * 3.0f), (float)0.0f, (float)1.0f, (float)1.0f);
        }
        float shiftX = DrugEffectInterpreter.getCameraShiftX(drugHelper, (float)rendererUpdateCount + par1);
        float shiftY = DrugEffectInterpreter.getCameraShiftY(drugHelper, (float)rendererUpdateCount + par1);
        GL11.glTranslatef((float)shiftX, (float)shiftY, (float)0.0f);
    }

    @Override
    public void renderOverlaysBeforeShaders(float partialTicks, EntityLivingBase entity, int updateCounter, int width, int height, DrugHelper drugHelper) {
        IvOpenGLHelper.setUpOpenGLStandard2D((int)width, (int)height);
        this.effectLensFlare.sunFlareIntensity = DrugShaderHelper.sunFlareIntensity;
        if (this.effectLensFlare.shouldApply((float)updateCounter + partialTicks)) {
            this.effectLensFlare.renderLensFlares(width, height, partialTicks);
        }
    }

    @Override
    public void renderOverlaysAfterShaders(float partialTicks, EntityLivingBase entity, int updateCounter, int width, int height, DrugHelper drugHelper) {
        int powerLightnings;
        float warmth;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        float alcohol = drugHelper.getDrugValue("Alcohol");
        if (alcohol > 0.0f) {
            float d = MathHelper.func_76126_a((float)((float)updateCounter / 80.0f)) * alcohol * 0.5f + alcohol;
            if (d > 0.8f) {
                d = 0.8f;
            }
            this.renderOverlay(d * 0.25f, width, height, TextureMap.field_110575_b, Blocks.field_150427_aO.func_149691_a(0, 0).func_94209_e(), Blocks.field_150427_aO.func_149691_a(0, 0).func_94206_g(), Blocks.field_150427_aO.func_149691_a(0, 0).func_94212_f(), Blocks.field_150427_aO.func_149691_a(0, 0).func_94210_h(), 0);
        }
        if ((warmth = drugHelper.getDrugValue("Warmth")) > 0.0f) {
            this.renderWarmthOverlay(warmth * 0.5f, width, height, updateCounter);
        }
        float power = drugHelper.getDrugValue("Power");
        Random powerR = new Random(entity.field_70173_aa);
        int powerParticles = MathHelper.func_76141_d((float)(powerR.nextFloat() * 200.0f * power));
        if (powerParticles > 0) {
            this.bindTexture(this.powerParticle);
            this.renderRandomParticles(powerParticles, height / 10, MathHelper.func_76123_f((float)((float)(height / 10) * power)), width, height, powerR);
        }
        Random powerLR = new Random((long)(entity.field_70173_aa / 2) * 21124871824L);
        float lightningChance = (power - 0.5f) * 0.1f;
        for (powerLightnings = 0; powerLR.nextFloat() < lightningChance && powerLightnings < 3; ++powerLightnings) {
        }
        if (powerLightnings > 0) {
            int lightningW = height;
            OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
            for (int i = 0; i < powerLightnings; ++i) {
                float lX = powerLR.nextInt(width + lightningW) - lightningW;
                lX += (powerLR.nextFloat() - 0.5f) * (float)lightningW * partialTicks * 2.0f;
                int lIndex = powerLR.nextInt(this.lightningTextures.length);
                boolean upsideDown = powerLR.nextBoolean();
                float lightningTime = ((float)(entity.field_70173_aa % 2) + partialTicks) * 0.5f;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((0.05f + power * 0.1f) * (1.0f - lightningTime)));
                this.bindTexture(this.lightningTextures[lIndex]);
                tessellator.func_78382_b();
                tessellator.func_78374_a((double)lX, (double)height, -90.0, 0.0, upsideDown ? 0.0 : 1.0);
                tessellator.func_78374_a((double)(lX + (float)lightningW), (double)height, -90.0, 1.0, upsideDown ? 0.0 : 1.0);
                tessellator.func_78374_a((double)(lX + (float)lightningW), 0.0, -90.0, 1.0, upsideDown ? 1.0 : 0.0);
                tessellator.func_78374_a((double)lX, 0.0, -90.0, 0.0, upsideDown ? 1.0 : 0.0);
                tessellator.func_78381_a();
            }
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        }
        if (DrugHelper.hurtOverlayEnabled && (entity.field_70737_aN > 0 || this.experiencedHealth < 5.0f)) {
            float p1 = (float)entity.field_70737_aN / (float)entity.field_70738_aO;
            float p2 = (5.0f - this.experiencedHealth) / 6.0f;
            float p = p1 > 0.0f ? p1 : (0.0f + p2 > 0.0f ? p2 : 0.0f);
            this.renderOverlay(p, width, height, this.hurtOverlay, 0.0f, 0.0f, 1.0f, 1.0f, (int)((1.0f - p) * 40.0f));
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
    }

    private void renderOverlay(float alpha, int width, int height, ResourceLocation texture, float x0, float y0, float x1, float y1, int offset) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        this.bindTexture(texture);
        Tessellator var8 = Tessellator.field_78398_a;
        var8.func_78382_b();
        var8.func_78374_a((double)(-offset), (double)(height + offset), -90.0, (double)x0, (double)y1);
        var8.func_78374_a((double)(width + offset), (double)(height + offset), -90.0, (double)x1, (double)y1);
        var8.func_78374_a((double)(width + offset), (double)(-offset), -90.0, (double)x1, (double)y0);
        var8.func_78374_a((double)(-offset), (double)(-offset), -90.0, (double)x0, (double)y0);
        var8.func_78381_a();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderWarmthOverlay(float alpha, int width, int height, int ticks) {
        this.bindTexture(this.coffeeOverlay);
        Tessellator var8 = Tessellator.field_78398_a;
        for (int i = 0; i < 3; ++i) {
            int steps = 30;
            float prevXL = -1.0f;
            float prevXR = -1.0f;
            float prevY = -1.0f;
            boolean init = false;
            for (int y = 0; y < steps; ++y) {
                float prog = (float)(steps - y) / (float)steps;
                GL11.glColor4f((float)1.0f, (float)(0.5f + prog * 0.3f), (float)(0.35f + prog * 0.1f), (float)(alpha - prog * 0.4f));
                int segWidth = width / 9;
                int xM = (int)((float)segWidth * ((float)(i * 3) + 1.5f));
                float xShift = MathHelper.func_76126_a((float)((float)y / (float)steps * 5.0f + (float)ticks / 10.0f));
                float mXL = (float)(xM - segWidth) + xShift * (float)segWidth * 0.25f;
                float mXR = (float)(xM + segWidth) + xShift * (float)segWidth * 0.25f;
                float mY = (float)y / (float)steps * (float)height / 7.0f * 5.0f + (float)(height / 7);
                if (init) {
                    var8.func_78382_b();
                    var8.func_78374_a((double)mXL, (double)mY, -90.0, 0.0, (double)((float)y / (float)steps));
                    var8.func_78374_a((double)mXR, (double)mY, -90.0, 1.0, (double)((float)y / (float)steps));
                    var8.func_78374_a((double)prevXR, (double)prevY, -90.0, 1.0, (double)((float)(y - 1) / (float)steps));
                    var8.func_78374_a((double)prevXL, (double)prevY, -90.0, 0.0, (double)((float)(y - 1) / (float)steps));
                    var8.func_78381_a();
                } else {
                    init = true;
                }
                prevY = mY;
                prevXL = mXL;
                prevXR = mXR;
            }
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderRandomParticles(int number, int width, int height, int screenWidth, int screenHeight, Random rand) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        for (int i = 0; i < number; ++i) {
            int x = rand.nextInt(screenWidth + width) - width;
            int y = rand.nextInt(screenHeight + height) - height;
            tessellator.func_78374_a((double)x, (double)(y + height), -90.0, 0.0, 1.0);
            tessellator.func_78374_a((double)(x + width), (double)(y + height), -90.0, 1.0, 1.0);
            tessellator.func_78374_a((double)(x + width), (double)y, -90.0, 1.0, 0.0);
            tessellator.func_78374_a((double)x, (double)y, -90.0, 0.0, 0.0);
        }
        tessellator.func_78381_a();
    }

    @Override
    public void renderAllHallucinations(float par1, DrugHelper drugHelper) {
        for (DrugHallucination h : drugHelper.hallucinations) {
            h.render(par1, MathHelper.func_76131_a((float)0.0f, (float)(DrugEffectInterpreter.getHallucinationStrength(drugHelper, par1) * 15.0f), (float)1.0f));
        }
    }

    @Override
    public float getCurrentHeatDistortion() {
        if (this.wasInWater) {
            return 0.0f;
        }
        return IvMathHelper.clamp((float)0.0f, (float)((this.currentHeat - 1.0f) * 0.0015f), (float)0.01f);
    }

    @Override
    public float getCurrentWaterDistortion() {
        return this.wasInWater ? 0.025f : 0.0f;
    }

    @Override
    public float getCurrentWaterScreenDistortion() {
        if (this.timeScreenWet > 0 && !this.wasInWater) {
            float p = (float)this.timeScreenWet / 80.0f;
            if (p > 1.0f) {
                p = 1.0f;
            }
            return p;
        }
        return 0.0f;
    }

    private void bindTexture(ResourceLocation resourceLocation) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocation);
    }
}

