/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.rendering;

import ivorius.ivtoolkit.math.IvMathHelper;
import ivorius.ivtoolkit.rendering.Iv2DScreenEffect;
import ivorius.ivtoolkit.rendering.IvOpenGLTexturePingPong;
import ivorius.ivtoolkit.rendering.IvRenderHelper;
import ivorius.psychedelicraft.client.rendering.PsycheMatrixHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class EffectLensFlare
implements Iv2DScreenEffect {
    public float[] sunFlareSizes;
    public float[] sunFlareInfluences;
    public ResourceLocation[] sunFlareTextures;
    public ResourceLocation sunBlindnessTexture;
    public float sunFlareIntensity;
    public float actualSunAlpha = 0.0f;

    public void updateLensFlares() {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        EntityLivingBase renderEntity = mc.field_71451_h;
        if (renderEntity != null && world != null) {
            float sunSizeRadians = -0.08698868f;
            float sunWidth = 20.0f;
            float sunRadians = world.func_72929_e(1.0f);
            Vec3 sunVecTopLeft = Vec3.func_72443_a((double)(-MathHelper.func_76126_a((float)(sunRadians - sunSizeRadians)) * 120.0f), (double)(MathHelper.func_76134_b((float)(sunRadians - sunSizeRadians)) * 120.0f), (double)(-sunWidth));
            Vec3 sunVecTopRight = Vec3.func_72443_a((double)(-MathHelper.func_76126_a((float)(sunRadians - sunSizeRadians)) * 120.0f), (double)(MathHelper.func_76134_b((float)(sunRadians - sunSizeRadians)) * 120.0f), (double)sunWidth);
            Vec3 sunVecBottomLeft = Vec3.func_72443_a((double)(-MathHelper.func_76126_a((float)(sunRadians + sunSizeRadians)) * 120.0f), (double)(MathHelper.func_76134_b((float)(sunRadians + sunSizeRadians)) * 120.0f), (double)(-sunWidth));
            Vec3 sunVecBottomRight = Vec3.func_72443_a((double)(-MathHelper.func_76126_a((float)(sunRadians + sunSizeRadians)) * 120.0f), (double)(MathHelper.func_76134_b((float)(sunRadians + sunSizeRadians)) * 120.0f), (double)sunWidth);
            Vec3 playerPos = renderEntity.func_70666_h(1.0f);
            Vec3 playerPositionLT = Vec3.func_72443_a((double)playerPos.field_72450_a, (double)playerPos.field_72448_b, (double)playerPos.field_72449_c);
            Vec3 playerPositionLB = Vec3.func_72443_a((double)playerPos.field_72450_a, (double)playerPos.field_72448_b, (double)playerPos.field_72449_c);
            Vec3 playerPositionRT = Vec3.func_72443_a((double)playerPos.field_72450_a, (double)playerPos.field_72448_b, (double)playerPos.field_72449_c);
            Vec3 playerPositionRB = Vec3.func_72443_a((double)playerPos.field_72450_a, (double)playerPos.field_72448_b, (double)playerPos.field_72449_c);
            Vec3 sunPosTopLeft = playerPositionLT.func_72441_c(sunVecTopLeft.field_72450_a, sunVecTopLeft.field_72448_b, sunVecTopLeft.field_72449_c);
            Vec3 sunPosTopRight = playerPositionRT.func_72441_c(sunVecTopRight.field_72450_a, sunVecTopRight.field_72448_b, sunVecTopRight.field_72449_c);
            Vec3 sunPosBottomLeft = playerPositionLB.func_72441_c(sunVecBottomLeft.field_72450_a, sunVecBottomLeft.field_72448_b, sunVecBottomLeft.field_72449_c);
            Vec3 sunPosBottomRight = playerPositionRB.func_72441_c(sunVecBottomRight.field_72450_a, sunVecBottomRight.field_72448_b, sunVecBottomRight.field_72449_c);
            MovingObjectPosition sunTopLeft = world.func_147447_a(playerPositionLT, sunPosTopLeft, true, true, true);
            MovingObjectPosition sunTopRight = world.func_147447_a(playerPositionRT, sunPosTopRight, true, true, true);
            MovingObjectPosition sunBottomLeft = world.func_147447_a(playerPositionLB, sunPosBottomLeft, true, true, true);
            MovingObjectPosition sunBottomRight = world.func_147447_a(playerPositionRB, sunPosBottomRight, true, true, true);
            float newSunAlpha = (1.0f - world.func_72867_j(1.0f)) * ((sunTopLeft == null ? 0.25f : 0.0f) + (sunTopRight == null ? 0.25f : 0.0f) + (sunBottomLeft == null ? 0.25f : 0.0f) + (sunBottomRight == null ? 0.25f : 0.0f));
            this.actualSunAlpha = IvMathHelper.nearValue((float)this.actualSunAlpha, (float)newSunAlpha, (float)0.1f, (float)0.01f);
            if (this.actualSunAlpha > 1.0f) {
                this.actualSunAlpha = 1.0f;
            }
        }
    }

    public void renderLensFlares(int screenWidth, int screenHeight, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        EntityLivingBase renderEntity = mc.field_71451_h;
        float sunRadians = world.func_72929_e(partialTicks);
        Vector3f sunVecCenter = new Vector3f(-MathHelper.func_76126_a((float)sunRadians) * 120.0f, MathHelper.func_76134_b((float)sunRadians) * 120.0f, 0.0f);
        if (this.actualSunAlpha > 0.0f) {
            float genSize = screenWidth > screenHeight ? (float)screenWidth : (float)screenHeight;
            Vector3f sunPositionOnScreen = PsycheMatrixHelper.projectPointCurrentView(sunVecCenter, partialTicks);
            Vector3f normSunPos = new Vector3f();
            sunPositionOnScreen.normalise(normSunPos);
            float xDist = normSunPos.x * (float)screenWidth;
            float yDist = normSunPos.y * (float)screenHeight;
            Vec3 color = world.func_72948_g(1.0f);
            if (sunPositionOnScreen.z > 0.0f) {
                float alpha = sunPositionOnScreen.z;
                if (alpha > 1.0f) {
                    alpha = 1.0f;
                }
                GL11.glDisable((int)2929);
                GL11.glDepthMask((boolean)false);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
                GL11.glDisable((int)3008);
                Tessellator var3 = Tessellator.field_78398_a;
                float screenCenterX = (float)screenWidth * 0.5f;
                float screenCenterY = (float)screenHeight * 0.5f;
                for (int i = 0; i < this.sunFlareSizes.length; ++i) {
                    float flareSizeHalf = this.sunFlareSizes[i] * genSize * 0.5f;
                    float flareCenterX = screenCenterX + xDist * this.sunFlareInfluences[i];
                    float flareCenterY = screenCenterY + yDist * this.sunFlareInfluences[i];
                    GL11.glColor4f((float)((float)color.field_72450_a - 0.1f), (float)((float)color.field_72448_b - 0.1f), (float)((float)color.field_72449_c - 0.1f), (float)((alpha * (float)i == 8.0f ? 1.0f : 0.5f) * this.actualSunAlpha * this.sunFlareIntensity));
                    mc.field_71446_o.func_110577_a(this.sunFlareTextures[i]);
                    var3.func_78382_b();
                    var3.func_78374_a((double)(flareCenterX - flareSizeHalf), (double)(flareCenterY + flareSizeHalf), -90.0, 0.0, 1.0);
                    var3.func_78374_a((double)(flareCenterX + flareSizeHalf), (double)(flareCenterY + flareSizeHalf), -90.0, 1.0, 1.0);
                    var3.func_78374_a((double)(flareCenterX + flareSizeHalf), (double)(flareCenterY - flareSizeHalf), -90.0, 1.0, 0.0);
                    var3.func_78374_a((double)(flareCenterX - flareSizeHalf), (double)(flareCenterY - flareSizeHalf), -90.0, 0.0, 0.0);
                    var3.func_78381_a();
                }
                float genDist = 1.0f - (normSunPos.x * normSunPos.x + normSunPos.y * normSunPos.y);
                float blendingSize = (genDist - 0.1f) * this.sunFlareIntensity * 250.0f * genSize;
                if (blendingSize > 0.0f) {
                    float blendingSizeHalf = blendingSize * 0.5f;
                    float blendCenterX = screenCenterX + xDist;
                    float blendCenterY = screenCenterY + yDist;
                    float blendAlpha = blendingSize / genSize / 150.0f;
                    if (blendAlpha > 1.0f) {
                        blendAlpha = 1.0f;
                    }
                    GL11.glColor4f((float)((float)color.field_72450_a - 0.1f), (float)((float)color.field_72448_b - 0.1f), (float)((float)color.field_72449_c - 0.1f), (float)(blendAlpha * this.actualSunAlpha));
                    GL11.glEnable((int)3042);
                    OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
                    mc.field_71446_o.func_110577_a(this.sunBlindnessTexture);
                    var3.func_78382_b();
                    var3.func_78374_a((double)(blendCenterX - blendingSizeHalf), (double)(blendCenterY + blendingSizeHalf), -90.0, 0.0, 1.0);
                    var3.func_78374_a((double)(blendCenterX + blendingSizeHalf), (double)(blendCenterY + blendingSizeHalf), -90.0, 1.0, 1.0);
                    var3.func_78374_a((double)(blendCenterX + blendingSizeHalf), (double)(blendCenterY - blendingSizeHalf), -90.0, 1.0, 0.0);
                    var3.func_78374_a((double)(blendCenterX - blendingSizeHalf), (double)(blendCenterY - blendingSizeHalf), -90.0, 0.0, 0.0);
                    var3.func_78381_a();
                }
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2929);
                GL11.glEnable((int)3008);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        GL11.glDisable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
    }

    public boolean shouldApply(float ticks) {
        return this.sunFlareIntensity > 0.0f;
    }

    public void apply(int screenWidth, int screenHeight, float ticks, IvOpenGLTexturePingPong pingPong) {
        pingPong.pingPong();
        IvRenderHelper.drawRectFullScreen((int)screenWidth, (int)screenHeight);
        this.renderLensFlares(screenWidth, screenHeight, 1.0f);
    }

    public void destruct() {
    }
}

