/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.rendering;

import ivorius.ivtoolkit.rendering.Iv2DScreenEffect;
import ivorius.ivtoolkit.rendering.IvOpenGLHelper;
import ivorius.ivtoolkit.rendering.IvOpenGLTexturePingPong;
import ivorius.ivtoolkit.rendering.IvRenderHelper;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL11;

public class EffectMotionBlur
implements Iv2DScreenEffect {
    public int[] motionBlurCacheTextures;
    public boolean[] motionBlurCacheTexturesInitialized;
    public float sampleFrequency = 0.5f;
    public int motionBlurCacheTextureIndex;
    private float previousTicks;
    public float motionBlur;
    private int currentTexturesWidth = -1;
    private int currentTexturesHeight = -1;

    public boolean shouldApply(float ticks) {
        return true;
    }

    public void apply(int screenWidth, int screenHeight, float ticks, IvOpenGLTexturePingPong pingPong) {
        if (this.motionBlur > 0.0f) {
            if (screenWidth != this.currentTexturesWidth || screenHeight != this.currentTexturesHeight) {
                this.setUp(screenWidth, screenHeight, 30);
            }
            if (this.previousTicks > ticks) {
                this.previousTicks = ticks;
            } else if (this.previousTicks + this.sampleFrequency * (float)this.motionBlurCacheTextures.length < ticks) {
                this.previousTicks = ticks - this.sampleFrequency * (float)this.motionBlurCacheTextures.length;
            }
            while (this.previousTicks + this.sampleFrequency <= ticks) {
                ++this.motionBlurCacheTextureIndex;
                this.motionBlurCacheTextureIndex %= this.motionBlurCacheTextures.length;
                GL11.glBindTexture((int)3553, (int)this.motionBlurCacheTextures[this.motionBlurCacheTextureIndex]);
                GL11.glCopyTexImage2D((int)3553, (int)0, (int)6407, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)0);
                this.motionBlurCacheTexturesInitialized[this.motionBlurCacheTextureIndex] = true;
                this.previousTicks += this.sampleFrequency;
            }
            pingPong.pingPong();
            IvRenderHelper.drawRectFullScreen((int)screenWidth, (int)screenHeight);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            for (int i = 0; i < this.motionBlurCacheTextures.length; ++i) {
                int index = (i + this.motionBlurCacheTextureIndex) % this.motionBlurCacheTextures.length;
                if (!this.motionBlurCacheTexturesInitialized[index]) continue;
                float alpha = (float)i * 0.02f * this.motionBlur;
                if (alpha > 0.1f) {
                    alpha = 0.1f;
                }
                if (!(alpha > 0.0f)) continue;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GL11.glBindTexture((int)3553, (int)this.motionBlurCacheTextures[index]);
                IvRenderHelper.drawRectFullScreen((int)screenWidth, (int)screenHeight);
            }
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else if (this.motionBlurCacheTexturesInitialized != null) {
            ++this.motionBlurCacheTextureIndex;
            this.motionBlurCacheTextureIndex %= this.motionBlurCacheTextures.length;
            this.motionBlurCacheTexturesInitialized[this.motionBlurCacheTextureIndex] = false;
        }
    }

    public void destruct() {
        this.destructMotionBlur();
    }

    public void setUp(int width, int height, int samples) {
        this.destructMotionBlur();
        this.motionBlurCacheTextures = new int[samples];
        this.motionBlurCacheTexturesInitialized = new boolean[this.motionBlurCacheTextures.length];
        for (int i = 0; i < this.motionBlurCacheTextures.length; ++i) {
            this.motionBlurCacheTextures[i] = IvOpenGLHelper.genStandardTexture();
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
        }
        this.currentTexturesWidth = width;
        this.currentTexturesHeight = height;
    }

    public void destructMotionBlur() {
        if (this.motionBlurCacheTextures != null) {
            for (int i = 0; i < this.motionBlurCacheTextures.length; ++i) {
                if (this.motionBlurCacheTextures[i] <= 0) continue;
                GL11.glDeleteTextures((int)this.motionBlurCacheTextures[i]);
                this.motionBlurCacheTextures[i] = 0;
            }
        }
        this.motionBlurCacheTextureIndex = 0;
        this.currentTexturesWidth = -1;
        this.currentTexturesHeight = -1;
    }
}

