/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.rendering;

import cpw.mods.fml.relauncher.ReflectionHelper;
import ivorius.ivtoolkit.math.IvMatrixHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class PsycheMatrixHelper {
    private static Method getFOVMethod;

    public static Matrix4f getCurrentProjectionMatrix(float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        float degToRad = (float)Math.PI / 180;
        float farPlaneDistance = mc.field_71474_y.field_151451_c * 16;
        return IvMatrixHelper.getProjectionMatrix((float)(PsycheMatrixHelper.getCurrentFOV(partialTicks, true) * degToRad), (float)((float)mc.field_71443_c / (float)mc.field_71440_d), (float)0.05f, (float)(farPlaneDistance * 2.0f));
    }

    public static Matrix4f getLookProjectionMatrix(Matrix4f projectionMatrix, Entity entity) {
        float degToRad = (float)Math.PI / 180;
        float roll = 0.0f;
        return IvMatrixHelper.lookFrom((float)0.0f, (float)0.0f, (float)0.0f, (float)((entity.field_70177_z + 180.0f) * degToRad), (float)(entity.field_70125_A * degToRad), (float)(roll * degToRad), (Matrix4f)projectionMatrix, (Matrix4f)projectionMatrix);
    }

    public static Vector3f projectPoint(Entity entity, Vector3f point, float partialTicks) {
        Matrix4f projectionMatrix = PsycheMatrixHelper.getLookProjectionMatrix(PsycheMatrixHelper.getCurrentProjectionMatrix(partialTicks), entity);
        Vector4f clippedPoint = new Vector4f(point.x, point.y, point.z, 1.0f);
        Matrix4f.transform((Matrix4f)projectionMatrix, (Vector4f)clippedPoint, (Vector4f)clippedPoint);
        return new Vector3f(clippedPoint.x, -clippedPoint.y, clippedPoint.z);
    }

    public static Vector3f projectPointCurrentView(Vector3f point, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityLivingBase renderViewEntity = mc.field_71451_h;
        Matrix4f transformMatrix = PsycheMatrixHelper.getCurrentProjectionMatrix(partialTicks);
        if (mc.field_71474_y.field_74320_O > 0) {
            float f1 = renderViewEntity.field_70129_M - 1.62f;
            double d0 = renderViewEntity.field_70169_q + (renderViewEntity.field_70165_t - renderViewEntity.field_70169_q) * (double)partialTicks;
            double d1 = renderViewEntity.field_70167_r + (renderViewEntity.field_70163_u - renderViewEntity.field_70167_r) * (double)partialTicks - (double)f1;
            double d2 = renderViewEntity.field_70166_s + (renderViewEntity.field_70161_v - renderViewEntity.field_70166_s) * (double)partialTicks;
            double d7 = 4.0;
            float f6 = renderViewEntity.field_70177_z;
            float f2 = renderViewEntity.field_70125_A;
            if (mc.field_71474_y.field_74320_O == 2) {
                f2 += 180.0f;
            }
            double d3 = (double)(-MathHelper.func_76126_a((float)(f6 / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(f2 / 180.0f * (float)Math.PI))) * d7;
            double d4 = (double)(MathHelper.func_76134_b((float)(f6 / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(f2 / 180.0f * (float)Math.PI))) * d7;
            double d5 = (double)(-MathHelper.func_76126_a((float)(f2 / 180.0f * (float)Math.PI))) * d7;
            for (int k = 0; k < 8; ++k) {
                double d6;
                MovingObjectPosition movingobjectposition;
                float f3 = (k & 1) * 2 - 1;
                float f4 = (k >> 1 & 1) * 2 - 1;
                float f5 = (k >> 2 & 1) * 2 - 1;
                if ((movingobjectposition = mc.field_71441_e.func_72933_a(Vec3.func_72443_a((double)(d0 + (double)(f3 *= 0.1f)), (double)(d1 + (double)(f4 *= 0.1f)), (double)(d2 + (double)(f5 *= 0.1f))), Vec3.func_72443_a((double)(d0 - d3 + (double)f3 + (double)f5), (double)(d1 - d5 + (double)f4), (double)(d2 - d4 + (double)f5)))) == null || !((d6 = movingobjectposition.field_72307_f.func_72438_d(Vec3.func_72443_a((double)d0, (double)d1, (double)d2))) < d7)) continue;
                d7 = d6;
            }
            if (mc.field_71474_y.field_74320_O == 2) {
                Matrix4f.rotate((float)180.0f, (Vector3f)new Vector3f(0.0f, 1.0f, 0.0f), (Matrix4f)transformMatrix, (Matrix4f)transformMatrix);
            }
            Matrix4f.rotate((float)(renderViewEntity.field_70125_A - f2), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)transformMatrix, (Matrix4f)transformMatrix);
            Matrix4f.rotate((float)(renderViewEntity.field_70177_z - f6), (Vector3f)new Vector3f(0.0f, 1.0f, 0.0f), (Matrix4f)transformMatrix, (Matrix4f)transformMatrix);
            Matrix4f.translate((Vector3f)new Vector3f(0.0f, 0.0f, (float)(-d7)), (Matrix4f)transformMatrix, (Matrix4f)transformMatrix);
            Matrix4f.rotate((float)(f6 - renderViewEntity.field_70177_z), (Vector3f)new Vector3f(0.0f, 1.0f, 0.0f), (Matrix4f)transformMatrix, (Matrix4f)transformMatrix);
            Matrix4f.rotate((float)(f2 - renderViewEntity.field_70125_A), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)transformMatrix, (Matrix4f)transformMatrix);
        }
        transformMatrix = PsycheMatrixHelper.getLookProjectionMatrix(transformMatrix, (Entity)renderViewEntity);
        Vector4f clippedPoint = new Vector4f(point.x, point.y, point.z, 1.0f);
        Matrix4f.transform((Matrix4f)transformMatrix, (Vector4f)clippedPoint, (Vector4f)clippedPoint);
        return new Vector3f(clippedPoint.x, -clippedPoint.y, clippedPoint.z);
    }

    public static float getCurrentFOV(float partialTicks, boolean isWorld) {
        EntityRenderer instance = Minecraft.func_71410_x().field_71460_t;
        if (getFOVMethod == null) {
            getFOVMethod = ReflectionHelper.findMethod(EntityRenderer.class, (Object)instance, (String[])new String[]{"func_78481_a", "getFOVModifier"}, (Class[])new Class[]{Float.TYPE, Boolean.TYPE});
        }
        try {
            return ((Float)getFOVMethod.invoke((Object)instance, Float.valueOf(partialTicks), isWorld)).floatValue();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return 90.0f;
        }
    }
}

