/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.rendering;

import ivorius.ivtoolkit.math.IvMatrixHelper;
import ivorius.psychedelicraft.client.rendering.PsycheMatrixHelper;
import ivorius.psychedelicraft.client.rendering.shaders.ShaderShadows;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public class PsycheShadowHelper {
    public static void setupSunGLTransform() {
        Minecraft mc = Minecraft.func_71410_x();
        float farPlaneDistance = mc.field_71474_y.field_151451_c * 16;
        int shadowPixels = ShaderShadows.getShadowPixels();
        GL11.glViewport((int)0, (int)0, (int)shadowPixels, (int)shadowPixels);
        GL11.glMatrixMode((int)5889);
        FloatBuffer floatBufferProj = BufferUtils.createFloatBuffer((int)16);
        PsycheShadowHelper.getSunProjectionMatrix().store(floatBufferProj);
        floatBufferProj.position(0);
        GL11.glLoadMatrix((FloatBuffer)floatBufferProj);
        GL11.glMatrixMode((int)5888);
        FloatBuffer floatBufferCam = BufferUtils.createFloatBuffer((int)16);
        PsycheShadowHelper.getSunViewMatrix().store(floatBufferCam);
        floatBufferCam.position(0);
        GL11.glLoadMatrix((FloatBuffer)floatBufferCam);
    }

    public static Matrix4f getSunMatrix() {
        Matrix4f projMatrix = PsycheShadowHelper.getSunProjectionMatrix();
        Matrix4f sunMatrix = PsycheShadowHelper.getSunViewMatrix();
        Matrix4f.mul((Matrix4f)projMatrix, (Matrix4f)sunMatrix, (Matrix4f)sunMatrix);
        return sunMatrix;
    }

    public static Matrix4f getSunProjectionMatrix() {
        float farPlaneDistance = Minecraft.func_71410_x().field_71474_y.field_151451_c * 16;
        return IvMatrixHelper.getOrthographicMatrix((float)(-farPlaneDistance), (float)farPlaneDistance, (float)(-farPlaneDistance), (float)farPlaneDistance, (float)PsycheShadowHelper.getSunZNear(), (float)PsycheShadowHelper.getSunZFar());
    }

    public static Matrix4f getSunViewMatrix() {
        Matrix4f sunMatrix = new Matrix4f();
        Matrix4f.setIdentity((Matrix4f)sunMatrix);
        float sunRadians = Minecraft.func_71410_x().field_71441_e.func_72929_e(1.0f);
        Matrix4f.translate((Vector3f)new Vector3f(0.0f, 0.0f, -300.0f), (Matrix4f)sunMatrix, (Matrix4f)sunMatrix);
        Matrix4f.rotate((float)(-sunRadians + 1.5707963f), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)sunMatrix, (Matrix4f)sunMatrix);
        Matrix4f.rotate((float)1.5707963f, (Vector3f)new Vector3f(0.0f, 1.0f, 0.0f), (Matrix4f)sunMatrix, (Matrix4f)sunMatrix);
        return sunMatrix;
    }

    public static Matrix4f getInverseViewMatrix(float partialTicks) {
        EntityLivingBase renderEntity = Minecraft.func_71410_x().field_71451_h;
        return (Matrix4f)PsycheMatrixHelper.getLookProjectionMatrix(PsycheMatrixHelper.getCurrentProjectionMatrix(partialTicks), (Entity)renderEntity).invert();
    }

    public static float getSunZFar() {
        float farPlaneDistance = Minecraft.func_71410_x().field_71474_y.field_151451_c * 16;
        return farPlaneDistance + 300.0f;
    }

    public static float getSunZNear() {
        return 10.0f;
    }

    public static float getShadowBias() {
        return 0.001f;
    }
}

