/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.rendering;

import net.minecraft.util.MouseFilter;

public class SmoothCameraHelper {
    public static SmoothCameraHelper instance = new SmoothCameraHelper();
    public float smoothCamFilterX;
    public float smoothCamFilterY;
    public float smoothCamPartialTicks;
    public float smoothCamYaw;
    public float smoothCamPitch;
    public MouseFilter mouseFilterXAxis = new MouseFilter();
    public MouseFilter mouseFilterYAxis = new MouseFilter();

    public void update(float mouseSensitivity, float multiplier) {
        float f = mouseSensitivity * 0.6f + 0.2f;
        float f1 = f * f * f * 8.0f;
        this.smoothCamFilterX = this.mouseFilterXAxis.func_76333_a(this.smoothCamYaw, multiplier * f1);
        this.smoothCamFilterY = this.mouseFilterYAxis.func_76333_a(this.smoothCamPitch, multiplier * f1);
        this.smoothCamPartialTicks = 0.0f;
        this.smoothCamYaw = 0.0f;
        this.smoothCamPitch = 0.0f;
    }

    public float[] getAngles(float mouseSensitivity, float partialTicks, float deltaX, float deltaY, boolean invertMouse) {
        int b0 = invertMouse ? -1 : 1;
        float f1 = mouseSensitivity * 0.6f + 0.2f;
        float f2 = f1 * f1 * f1 * 8.0f;
        float f3 = deltaX * f2;
        float f4 = deltaY * f2;
        this.smoothCamYaw += f3;
        this.smoothCamPitch += f4;
        float f5 = partialTicks - this.smoothCamPartialTicks;
        this.smoothCamPartialTicks = partialTicks;
        float nf3 = this.smoothCamFilterX * f5;
        float nf4 = this.smoothCamFilterY * f5;
        return new float[]{nf3, nf4 * (float)b0};
    }

    public float[] getOriginalAngles(float mouseSensitivity, float partialTicks, float deltaX, float deltaY, boolean invertMouse) {
        int b0 = invertMouse ? -1 : 1;
        float f1 = mouseSensitivity * 0.6f + 0.2f;
        float f2 = f1 * f1 * f1 * 8.0f;
        float f3 = deltaX * f2;
        float f4 = deltaY * f2;
        return new float[]{f3, f4 * (float)b0};
    }
}

