/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.rendering;

import ivorius.ivtoolkit.bezier.IvBezierPath3D;
import ivorius.ivtoolkit.bezier.IvBezierPath3DCreator;
import ivorius.ivtoolkit.bezier.IvBezierPath3DRendererText;
import ivorius.ivtoolkit.rendering.IvRenderHelper;
import ivorius.ivtoolkit.tools.IvStringHelper;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.blocks.TileEntityRiftJar;
import ivorius.psychedelicraft.client.rendering.ModelMystJar;
import ivorius.psychedelicraft.client.rendering.shaders.DrugShaderHelper;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TileEntityRendererRiftJar
extends TileEntitySpecialRenderer {
    public ModelBase model = new ModelMystJar();
    public ResourceLocation texture = new ResourceLocation("psychedelicraft", Psychedelicraft.filePathTextures + "riftJar.png");
    public ResourceLocation crackedTexture = new ResourceLocation("psychedelicraft", Psychedelicraft.filePathTextures + "riftJarCracked.png");
    public ResourceLocation[] zeroScreenTexture = new ResourceLocation[8];
    public IvBezierPath3D sphereBezierPath;
    public IvBezierPath3D outgoingBezierPath;
    public IvBezierPath3DRendererText bezierPath3DRendererText;

    public TileEntityRendererRiftJar() {
        for (int i = 0; i < this.zeroScreenTexture.length; ++i) {
            this.zeroScreenTexture[i] = new ResourceLocation("psychedelicraft", Psychedelicraft.filePathTextures + "zeroScreen" + i + ".png");
        }
        this.sphereBezierPath = IvBezierPath3DCreator.createSpiraledSphere((double)3.0, (double)8.0, (double)0.2);
        this.outgoingBezierPath = IvBezierPath3DCreator.createSpiraledBezierPath((double)0.06, (double)6.0, (double)6.0, (double)1.0, (double)0.2, (double)0.0, (boolean)false);
        this.bezierPath3DRendererText = new IvBezierPath3DRendererText();
        this.bezierPath3DRendererText.setFontRenderer(Minecraft.func_71410_x().field_71464_q);
    }

    public void func_147500_a(TileEntity tileentity, double d, double d1, double d2, float f) {
        this.renderTileEntityRiftJarAt((TileEntityRiftJar)tileentity, d, d1, d2, f);
    }

    public void renderTileEntityRiftJarAt(TileEntityRiftJar tileEntity, double d, double d1, double d2, float f) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float ticks = (float)tileEntity.ticksAliveVisual + f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d + 0.5f), (float)((float)d1 + 0.5f), (float)((float)d2 + 0.5f));
        EntityArrow emptyEntity = new EntityArrow(tileEntity.func_145831_w());
        emptyEntity.field_70177_z = tileEntity.fractionOpen;
        emptyEntity.field_70125_A = tileEntity.fractionHandleUp * (1.0f + MathHelper.func_76126_a((float)((float)tileEntity.ticksAliveVisual * 0.1f)) * 0.1f);
        GL11.glPushMatrix();
        GL11.glRotatef((float)(-90.0f * (float)tileEntity.getBlockRotation() + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        if (tileEntity.currentRiftFraction > 0.0f) {
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3008);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            this.renderZeroInsides(f, ticks, Math.min(tileEntity.currentRiftFraction * 2.0f, 1.0f));
            GL11.glEnable((int)3008);
            GL11.glDisable((int)3042);
        }
        GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.func_147499_a(this.texture);
        this.model.func_78088_a((Entity)emptyEntity, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        float crackedVisibility = Math.min((tileEntity.currentRiftFraction - 0.5f) * 2.0f, 1.0f);
        if (crackedVisibility > 0.0f) {
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3008);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)crackedVisibility);
            this.func_147499_a(this.crackedTexture);
            this.model.func_78088_a((Entity)emptyEntity, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            GL11.glEnable((int)3008);
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d + 0.5f), (float)((float)d1 + 0.6f), (float)((float)d2 + 0.5f));
        GL11.glDisable((int)2884);
        for (TileEntityRiftJar.JarRiftConnection connection : tileEntity.riftConnections) {
            if (connection.bezierPath3D == null) {
                connection.bezierPath3D = IvBezierPath3DCreator.createSpiraledBezierPath((double)0.1, (double)0.5, (double)8.0, (double[])new double[]{connection.entityX - ((double)tileEntity.field_145851_c + 0.5), connection.entityY - ((double)tileEntity.field_145848_d + 0.6), connection.entityZ - ((double)tileEntity.field_145849_e + 0.5)}, (double)0.2, (double)0.0, (boolean)false);
            }
            this.bezierPath3DRendererText.setText("This is a small spiral.");
            this.bezierPath3DRendererText.setSpreadToFill(true);
            this.bezierPath3DRendererText.setShift((double)((float)tileEntity.ticksAliveVisual + f) * -0.002);
            this.bezierPath3DRendererText.setInwards(false);
            this.bezierPath3DRendererText.setCapBottom(0.0);
            this.bezierPath3DRendererText.setCapTop((double)connection.fractionUp);
            this.bezierPath3DRendererText.render(connection.bezierPath3D);
            if (!(connection.fractionUp > 0.0f)) continue;
            GL11.glPushMatrix();
            GL11.glTranslated((double)(connection.entityX - ((double)tileEntity.field_145851_c + 0.5)), (double)(connection.entityY - ((double)tileEntity.field_145848_d + 0.6)), (double)(connection.entityZ - ((double)tileEntity.field_145849_e + 0.5)));
            this.bezierPath3DRendererText.setText(IvStringHelper.cheeseString((String)"This is a small circle.", (float)(1.0f - connection.fractionUp), (long)42L));
            this.bezierPath3DRendererText.setSpreadToFill(true);
            this.bezierPath3DRendererText.setShift((double)((float)tileEntity.ticksAliveVisual + f) * -0.002);
            this.bezierPath3DRendererText.setInwards(false);
            this.bezierPath3DRendererText.setCapBottom(0.0);
            this.bezierPath3DRendererText.setCapTop(1.0);
            this.bezierPath3DRendererText.render(this.sphereBezierPath);
            GL11.glPopMatrix();
        }
        float outgoingStrength = tileEntity.fractionHandleUp * tileEntity.fractionOpen;
        if (outgoingStrength > 0.0f) {
            this.bezierPath3DRendererText.setText("This is a small spiral.");
            this.bezierPath3DRendererText.setSpreadToFill(true);
            this.bezierPath3DRendererText.setShift((double)((float)tileEntity.ticksAliveVisual + f) * 0.002);
            this.bezierPath3DRendererText.setInwards(false);
            this.bezierPath3DRendererText.setCapBottom(0.0);
            this.bezierPath3DRendererText.setCapTop((double)outgoingStrength);
            this.bezierPath3DRendererText.render(this.outgoingBezierPath);
        }
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
    }

    public void renderZeroInsides(float partialTicks, float ticks, float alpha) {
        int textureChosen = MathHelper.func_76128_c((double)(ticks * 0.5f));
        Random thisTextureMov = new Random(textureChosen);
        this.func_147499_a(this.zeroScreenTexture[textureChosen % 8]);
        DrugShaderHelper.setUseScreenTexCoords(true);
        float pixelsX = 70.0f;
        float pixelsY = 112.0f;
        DrugShaderHelper.setPixelSize(1.0f / pixelsX, -1.0f / pixelsY);
        GL11.glTexCoord2f((float)((float)thisTextureMov.nextInt(10) * 0.1f * pixelsX), (float)((float)thisTextureMov.nextInt(8) * 0.125f * pixelsY));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        this.renderJarInside(partialTicks, alpha);
        DrugShaderHelper.setScreenSizeDefault();
        DrugShaderHelper.setUseScreenTexCoords(false);
    }

    public void renderJarInside(float partialTicks, float alpha) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float in = 0.001f;
        float in2 = in * 2.0f;
        tessellator.func_78382_b();
        IvRenderHelper.drawModelCuboid((Tessellator)tessellator, (float)(-4.0f + in), (float)(0.0f + in), (float)(-4.0f + in), (float)(8.0f - in2), (float)(5.0f - in2), (float)(8.0f - in2));
        IvRenderHelper.drawModelCuboid((Tessellator)tessellator, (float)(-3.0f + in), (float)(5.0f - in), (float)(-3.0f + in), (float)(6.0f - in2), (float)(2.0f + in2), (float)(6.0f - in2));
        IvRenderHelper.drawModelCuboid((Tessellator)tessellator, (float)(-4.0f + in), (float)(7.0f + in), (float)(-4.0f + in), (float)(8.0f - in2), (float)(5.0f - in2), (float)(8.0f - in2));
        tessellator.func_78381_a();
    }
}

