/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.rendering.shaders;

import com.google.common.base.Charsets;
import ivorius.ivtoolkit.rendering.Iv2DScreenEffect;
import ivorius.ivtoolkit.rendering.IvDepthBuffer;
import ivorius.ivtoolkit.rendering.IvOpenGLHelper;
import ivorius.ivtoolkit.rendering.IvOpenGLTexturePingPong;
import ivorius.ivtoolkit.rendering.IvShaderInstance;
import ivorius.ivtoolkit.rendering.IvShaderInstanceMC;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.client.rendering.EntityFakeSun;
import ivorius.psychedelicraft.client.rendering.PsycheShadowHelper;
import ivorius.psychedelicraft.client.rendering.effectWrappers.IEffectWrapper;
import ivorius.psychedelicraft.client.rendering.effectWrappers.WrapperBloom;
import ivorius.psychedelicraft.client.rendering.effectWrappers.WrapperBlur;
import ivorius.psychedelicraft.client.rendering.effectWrappers.WrapperBlurNoise;
import ivorius.psychedelicraft.client.rendering.effectWrappers.WrapperColorBloom;
import ivorius.psychedelicraft.client.rendering.effectWrappers.WrapperDigital;
import ivorius.psychedelicraft.client.rendering.effectWrappers.WrapperDoF;
import ivorius.psychedelicraft.client.rendering.effectWrappers.WrapperDoubleVision;
import ivorius.psychedelicraft.client.rendering.effectWrappers.WrapperHeatDistortion;
import ivorius.psychedelicraft.client.rendering.effectWrappers.WrapperMotionBlur;
import ivorius.psychedelicraft.client.rendering.effectWrappers.WrapperRadialBlur;
import ivorius.psychedelicraft.client.rendering.effectWrappers.WrapperSimpleEffects;
import ivorius.psychedelicraft.client.rendering.effectWrappers.WrapperUnderwaterDistortion;
import ivorius.psychedelicraft.client.rendering.effectWrappers.WrapperWaterOverlay;
import ivorius.psychedelicraft.client.rendering.shaders.ShaderMain;
import ivorius.psychedelicraft.client.rendering.shaders.ShaderMainDepth;
import ivorius.psychedelicraft.client.rendering.shaders.ShaderShadows;
import ivorius.psychedelicraft.client.rendering.shaders.ShaderWorld;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class DrugShaderHelper {
    public static ShaderWorld currentShader;
    public static ArrayList<ShaderWorld> worldShaders;
    public static ShaderMain shaderInstance;
    public static ShaderMainDepth shaderInstanceDepth;
    public static ShaderShadows shaderInstanceShadows;
    public static List<IEffectWrapper> effectWrappers;
    public static IvOpenGLTexturePingPong realtimePingPong;
    public static IvDepthBuffer depthBuffer;
    public static boolean disableDepthBuffer;
    public static boolean bypassPingPongBuffer;
    public static boolean shaderEnabled;
    public static boolean shader2DEnabled;
    public static boolean doShadows;
    public static boolean doHeatDistortion;
    public static boolean doWaterDistortion;
    public static float sunFlareIntensity;
    public static int shadowPixelsPerChunk;
    public static String currentRenderPass;
    public static float currentRenderPassTicks;

    public static void preRender(float ticks) {
    }

    public static void preRender3D(float ticks) {
    }

    public static ArrayList<String> getRenderPasses(float partialTicks) {
        ArrayList<String> passes = new ArrayList<String>();
        passes.add("Default");
        if (depthBuffer.isAllocated() && shaderInstanceDepth.getShaderID() > 0) {
            boolean addDepth = false;
            for (IEffectWrapper wrapper : effectWrappers) {
                if (!wrapper.wantsDepthBuffer(partialTicks)) continue;
                addDepth = true;
            }
            if (addDepth) {
                passes.add("Depth");
            }
        }
        if (DrugShaderHelper.shaderInstanceShadows.depthBuffer.isAllocated() && shaderInstanceShadows.getShaderID() > 0 && doShadows) {
            passes.add("Shadows");
        }
        return passes;
    }

    public static boolean startRenderPass(String pass, float partialTicks, float ticks) {
        Minecraft mc = Minecraft.func_71410_x();
        if (currentRenderPass != null) {
            DrugShaderHelper.endRenderPass();
        }
        currentRenderPass = pass;
        currentRenderPassTicks = ticks;
        if ("Default".equals(pass)) {
            DrugShaderHelper.shaderInstance.shouldDoShadows = doShadows;
            DrugShaderHelper.shaderInstance.shadowDepthTextureIndex = DrugShaderHelper.shaderInstanceShadows.depthBuffer.getDepthTextureIndex();
            return DrugShaderHelper.useShader(partialTicks, ticks, shaderInstance);
        }
        if ("Depth".equals(pass)) {
            depthBuffer.setParentFB(DrugShaderHelper.getMCFBO());
            depthBuffer.setSize(mc.field_71443_c, mc.field_71440_d);
            depthBuffer.bind();
            return DrugShaderHelper.useShader(partialTicks, ticks, shaderInstanceDepth);
        }
        if ("Shadows".equals(pass)) {
            Minecraft.func_71410_x().field_71451_h = new EntityFakeSun(mc.field_71451_h);
            return DrugShaderHelper.useShader(partialTicks, ticks, shaderInstanceShadows);
        }
        return true;
    }

    public static void endRenderPass() {
        if (!"Default".equals(currentRenderPass)) {
            if ("Depth".equals(currentRenderPass)) {
                depthBuffer.unbind();
            } else if ("Shadows".equals(currentRenderPass)) {
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71451_h instanceof EntityFakeSun) {
                    mc.field_71451_h = ((EntityFakeSun)mc.field_71451_h).prevViewEntity;
                }
            }
        }
        if (currentShader != null) {
            currentShader.deactivate();
            currentShader = null;
        }
        IvOpenGLHelper.checkGLError((Logger)Psychedelicraft.logger, (String)("Post render pass '" + currentRenderPass + "'"));
        currentRenderPass = null;
    }

    public static boolean setupCameraTransform() {
        if ("Shadows".equals(currentRenderPass)) {
            PsycheShadowHelper.setupSunGLTransform();
            return true;
        }
        return false;
    }

    public static void setShaderEnabled(boolean enabled) {
        shaderEnabled = enabled;
    }

    public static void setShader2DEnabled(boolean enabled) {
        shader2DEnabled = enabled;
    }

    public static void allocate() {
        Minecraft mc = Minecraft.func_71410_x();
        DrugShaderHelper.delete3DShaders();
        String utils = null;
        try {
            IResource utilsResource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("psychedelicraft", Psychedelicraft.filePathShaders + "shaderUtils.frag"));
            utils = IOUtils.toString((InputStream)utilsResource.func_110527_b(), (Charset)Charsets.UTF_8);
        }
        catch (Exception ex) {
            Psychedelicraft.logger.error("Could not load shader utils!", new Object[]{utils});
        }
        shaderInstance = new ShaderMain(Psychedelicraft.logger);
        DrugShaderHelper.setUpShader((IvShaderInstance)shaderInstance, "shader3D.vert", "shader3D.frag", utils);
        worldShaders.add(shaderInstance);
        shaderInstanceDepth = new ShaderMainDepth(Psychedelicraft.logger);
        DrugShaderHelper.setUpShader((IvShaderInstance)shaderInstanceDepth, "shader3D.vert", "shader3DDepth.frag", utils);
        worldShaders.add(shaderInstanceDepth);
        shaderInstanceShadows = new ShaderShadows(Psychedelicraft.logger);
        DrugShaderHelper.setUpShader((IvShaderInstance)shaderInstanceShadows, "shader3D.vert", "shader3DDepth.frag", utils);
        worldShaders.add(shaderInstanceShadows);
        effectWrappers.add(new WrapperHeatDistortion(utils));
        effectWrappers.add(new WrapperUnderwaterDistortion(utils));
        effectWrappers.add(new WrapperWaterOverlay(utils));
        effectWrappers.add(new WrapperSimpleEffects(utils));
        effectWrappers.add(new WrapperMotionBlur());
        effectWrappers.add(new WrapperBlur(utils));
        effectWrappers.add(new WrapperDoF(utils));
        effectWrappers.add(new WrapperRadialBlur(utils));
        effectWrappers.add(new WrapperBloom(utils));
        effectWrappers.add(new WrapperColorBloom(utils));
        effectWrappers.add(new WrapperDoubleVision(utils));
        effectWrappers.add(new WrapperBlurNoise(utils));
        effectWrappers.add(new WrapperDigital(utils));
        for (IEffectWrapper effectWrapper : effectWrappers) {
            effectWrapper.alloc();
        }
        DrugShaderHelper.setUpRealtimeCacheTexture();
        depthBuffer = new IvDepthBuffer(mc.field_71443_c, mc.field_71440_d, Psychedelicraft.logger);
        if (!disableDepthBuffer) {
            depthBuffer.allocate();
        }
        IvOpenGLHelper.checkGLError((Logger)Psychedelicraft.logger, (String)"Allocation");
    }

    public static void setUpShader(IvShaderInstance shader, String vertexFile, String fragmentFile, String utils) {
        IvShaderInstanceMC.trySettingUpShader((IvShaderInstance)shader, (ResourceLocation)new ResourceLocation("psychedelicraft", Psychedelicraft.filePathShaders + vertexFile), (ResourceLocation)new ResourceLocation("psychedelicraft", Psychedelicraft.filePathShaders + fragmentFile), (String)utils);
    }

    public static void setUpRealtimeCacheTexture() {
        DrugShaderHelper.deleteRealtimeCacheTexture();
        realtimePingPong = new IvOpenGLTexturePingPong(Psychedelicraft.logger);
        realtimePingPong.setScreenSize(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        realtimePingPong.initialize(!bypassPingPongBuffer);
    }

    public static void update() {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            for (IEffectWrapper effectWrapper : effectWrappers) {
                effectWrapper.update();
            }
        }
    }

    public static boolean useShader(float partialTicks, float ticks, ShaderWorld shader) {
        currentShader = null;
        if (shader != null && shaderEnabled) {
            if (shader.isShaderActive()) {
                return true;
            }
            if (shader.activate(partialTicks, ticks)) {
                currentShader = shader;
                return true;
            }
        }
        return false;
    }

    public static void setTexture2DEnabled(boolean enabled) {
        for (ShaderWorld shaderWorld : worldShaders) {
            shaderWorld.setTexture2DEnabled(enabled);
        }
    }

    public static void setLightmapEnabled(boolean enabled) {
        for (ShaderWorld shaderWorld : worldShaders) {
            shaderWorld.setLightmapEnabled(enabled);
        }
    }

    public static void setBlendFunc(int func) {
        for (ShaderWorld shaderWorld : worldShaders) {
            shaderWorld.setBlendFunc(func);
        }
    }

    public static void setOverrideColor(float ... color) {
        if (color != null && color.length != 4) {
            throw new IllegalArgumentException("Color must be a length-4 float array");
        }
        for (ShaderWorld shaderWorld : worldShaders) {
            shaderWorld.setOverrideColor(color);
        }
    }

    public static void setGLLightEnabled(boolean enabled) {
        for (ShaderWorld shaderWorld : worldShaders) {
            shaderWorld.setGLLightEnabled(enabled);
        }
    }

    public static void setGLLight(int number, float x, float y, float z, float strength, float specular) {
        for (ShaderWorld shaderWorld : worldShaders) {
            shaderWorld.setGLLight(number, x, y, z, strength, specular);
        }
    }

    public static void setGLLightAmbient(float strength) {
        for (ShaderWorld shaderWorld : worldShaders) {
            shaderWorld.setGLLightAmbient(strength);
        }
    }

    public static void setFogMode(int mode) {
        for (ShaderWorld shaderWorld : worldShaders) {
            shaderWorld.setFogMode(mode);
        }
    }

    public static void setFogEnabled(boolean enabled) {
        for (ShaderWorld shaderWorld : worldShaders) {
            shaderWorld.setFogEnabled(enabled);
        }
    }

    public static void setDepthMultiplier(float depthMultiplier) {
        for (ShaderWorld shaderWorld : worldShaders) {
            shaderWorld.setDepthMultiplier(depthMultiplier);
        }
    }

    public static void setUseScreenTexCoords(boolean enabled) {
        for (ShaderWorld shaderWorld : worldShaders) {
            shaderWorld.setUseScreenTexCoords(enabled);
        }
    }

    public static void setScreenSizeDefault() {
        Minecraft mc = Minecraft.func_71410_x();
        DrugShaderHelper.setScreenSize(mc.field_71443_c, mc.field_71440_d);
    }

    public static void setScreenSize(float screenWidth, float screenHeight) {
        DrugShaderHelper.setPixelSize(1.0f / screenWidth, 1.0f / screenHeight);
    }

    public static void setPixelSize(float pixelWidth, float pixelHeight) {
        for (ShaderWorld shaderWorld : worldShaders) {
            shaderWorld.setPixelSize(pixelWidth, pixelHeight);
        }
    }

    public static void setProjectShadows(boolean projectShadows) {
        for (ShaderWorld shaderWorld : worldShaders) {
            shaderWorld.setProjectShadows(projectShadows);
        }
    }

    public static int getCurrentAllowedGLDataMask() {
        if ("Depth".equals(currentRenderPass)) {
            return 256;
        }
        if ("Shadows".equals(currentRenderPass)) {
            return 256;
        }
        return -1;
    }

    public static int getMCFBO() {
        Minecraft mc = Minecraft.func_71410_x();
        Framebuffer framebuffer = mc.func_147110_a();
        return framebuffer != null && framebuffer.field_147616_f >= 0 ? framebuffer.field_147616_f : 0;
    }

    public static void postRender(float ticks, float partialTicks) {
        DrugShaderHelper.apply2DShaders(ticks, partialTicks);
    }

    public static void apply2DShaders(float ticks, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        int screenWidth = mc.field_71443_c;
        int screenHeight = mc.field_71440_d;
        IvOpenGLHelper.setUpOpenGLStandard2D((int)screenWidth, (int)screenHeight);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        realtimePingPong.setParentFrameBuffer(DrugShaderHelper.getMCFBO());
        realtimePingPong.preTick(screenWidth, screenHeight);
        for (IEffectWrapper effectWrapper : effectWrappers) {
            effectWrapper.apply(partialTicks, realtimePingPong);
        }
        realtimePingPong.postTick();
        IvOpenGLHelper.checkGLError((Logger)Psychedelicraft.logger, (String)"2D Shaders");
    }

    public static int getTextureIndex(ResourceLocation loc) {
        TextureManager tm = Minecraft.func_71410_x().field_71446_o;
        tm.func_110577_a(loc);
        ITextureObject texture = tm.func_110581_b(loc);
        return texture.func_110552_b();
    }

    public static void delete3DShaders() {
        if (shaderInstance != null) {
            shaderInstance.deleteShader();
        }
        shaderInstance = null;
        if (shaderInstanceDepth != null) {
            shaderInstanceDepth.deleteShader();
        }
        shaderInstanceDepth = null;
        if (shaderInstanceShadows != null) {
            shaderInstanceShadows.deleteShader();
        }
        shaderInstanceShadows = null;
    }

    private static void deleteEffect(Iv2DScreenEffect instance) {
        if (instance != null) {
            instance.destruct();
        }
    }

    public static void deleteRealtimeCacheTexture() {
        if (realtimePingPong != null) {
            realtimePingPong.destroy();
            realtimePingPong = null;
        }
    }

    public static void deallocate() {
        DrugShaderHelper.delete3DShaders();
        DrugShaderHelper.deleteRealtimeCacheTexture();
        for (IEffectWrapper effectWrapper : effectWrappers) {
            effectWrapper.dealloc();
        }
        effectWrappers.clear();
        if (depthBuffer != null) {
            depthBuffer.deallocate();
        }
        depthBuffer = null;
        worldShaders.clear();
    }

    public static void outputShaderInfo() {
        Psychedelicraft.logger.info("Graphics card info: ");
        IvShaderInstance.outputShaderInfo((Logger)Psychedelicraft.logger);
    }

    static {
        worldShaders = new ArrayList();
        effectWrappers = new ArrayList<IEffectWrapper>();
        disableDepthBuffer = false;
        bypassPingPongBuffer = false;
        shaderEnabled = true;
        shader2DEnabled = true;
        doShadows = true;
        doHeatDistortion = false;
        doWaterDistortion = false;
        shadowPixelsPerChunk = 256;
    }
}

