/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.rendering.shaders;

import ivorius.ivtoolkit.rendering.IvOpenGLTexturePingPong;
import ivorius.ivtoolkit.rendering.IvShaderInstance2D;
import net.minecraft.util.MathHelper;
import org.apache.logging.log4j.Logger;

public class ShaderBloom
extends IvShaderInstance2D {
    public float bloom;

    public ShaderBloom(Logger logger) {
        super(logger);
    }

    public boolean shouldApply(float ticks) {
        return this.bloom > 0.0f && super.shouldApply(ticks);
    }

    public void apply(int screenWidth, int screenHeight, float ticks, IvOpenGLTexturePingPong pingPong) {
        this.useShader();
        for (int i = 0; i < 1; ++i) {
            this.setUniformInts("tex" + i, new int[]{i});
        }
        this.setUniformFloats("pixelSize", new float[]{1.0f / (float)screenWidth * 2.0f, 1.0f / (float)screenHeight * 2.0f});
        for (int n = 0; n < MathHelper.func_76128_c((double)this.bloom) + 1; ++n) {
            int i = 0;
            while (i < 2) {
                float activeBloom = this.bloom - (float)n;
                if (activeBloom > 1.0f) {
                    activeBloom = 1.0f;
                }
                this.setUniformInts("vertical", new int[]{i++});
                this.setUniformFloats("totalAlpha", new float[]{activeBloom});
                this.drawFullScreen(screenWidth, screenHeight, pingPong);
            }
        }
        this.stopUsingShader();
    }
}

