/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.rendering.shaders;

import ivorius.ivtoolkit.rendering.IvOpenGLTexturePingPong;
import ivorius.ivtoolkit.rendering.IvShaderInstance2D;
import net.minecraft.util.MathHelper;
import org.apache.logging.log4j.Logger;

public class ShaderBlur
extends IvShaderInstance2D {
    public float vBlur;
    public float hBlur;

    public ShaderBlur(Logger logger) {
        super(logger);
    }

    public boolean shouldApply(float ticks) {
        return (this.vBlur > 0.0f || this.hBlur > 0.0f) && super.shouldApply(ticks);
    }

    public void apply(int screenWidth, int screenHeight, float ticks, IvOpenGLTexturePingPong pingPong) {
        this.useShader();
        for (int i = 0; i < 1; ++i) {
            this.setUniformInts("tex" + i, new int[]{i});
        }
        this.setUniformFloats("pixelSize", new float[]{1.0f / (float)screenWidth, 1.0f / (float)screenHeight});
        for (int n = 0; n < MathHelper.func_76128_c((double)Math.max(this.hBlur, this.vBlur)) + 1; ++n) {
            for (int i = 0; i < 2; ++i) {
                float activeBlur = (i == 0 ? this.hBlur : this.vBlur) - (float)n;
                if (activeBlur > 1.0f) {
                    activeBlur = 1.0f;
                }
                if (!(activeBlur > 0.0f)) continue;
                this.setUniformInts("vertical", new int[]{i});
                this.setUniformFloats("totalAlpha", new float[]{activeBlur});
                this.drawFullScreen(screenWidth, screenHeight, pingPong);
            }
        }
        this.stopUsingShader();
    }
}

