/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.rendering.shaders;

import ivorius.ivtoolkit.rendering.IvOpenGLTexturePingPong;
import ivorius.ivtoolkit.rendering.IvShaderInstance2D;
import net.minecraft.util.MathHelper;
import org.apache.logging.log4j.Logger;

public class ShaderColorBloom
extends IvShaderInstance2D {
    public float[] coloredBloom;

    public ShaderColorBloom(Logger logger) {
        super(logger);
    }

    public boolean shouldApply(float ticks) {
        return this.coloredBloom[3] > 0.0f && super.shouldApply(ticks);
    }

    public void apply(int screenWidth, int screenHeight, float ticks, IvOpenGLTexturePingPong pingPong) {
        this.useShader();
        for (int i = 0; i < 1; ++i) {
            this.setUniformInts("tex" + i, new int[]{i});
        }
        this.setUniformFloats("pixelSize", new float[]{1.0f / (float)screenWidth, 1.0f / (float)screenHeight});
        this.setUniformFloats("bloomColor", new float[]{this.coloredBloom[0], this.coloredBloom[1], this.coloredBloom[2]});
        for (int n = 0; n < MathHelper.func_76128_c((double)this.coloredBloom[3]) + 1; ++n) {
            int i = 0;
            while (i < 2) {
                float activeBloom = this.coloredBloom[3] - (float)n;
                if (activeBloom > 1.0f) {
                    activeBloom = 1.0f;
                }
                this.setUniformInts("vertical", new int[]{i++});
                this.setUniformFloats("totalAlpha", new float[]{activeBloom});
                this.drawFullScreen(screenWidth, screenHeight, pingPong);
            }
        }
        this.stopUsingShader();
    }
}

