/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.rendering.shaders;

import ivorius.ivtoolkit.math.IvMathHelper;
import ivorius.ivtoolkit.rendering.IvOpenGLTexturePingPong;
import ivorius.ivtoolkit.rendering.IvShaderInstance2D;
import net.minecraft.client.renderer.OpenGlHelper;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class ShaderDigital
extends IvShaderInstance2D {
    public float digital;
    public float[] maxDownscale;
    public int digitalTextTexture;

    public ShaderDigital(Logger logger) {
        super(logger);
    }

    public boolean shouldApply(float ticks) {
        return this.digital > 0.0f && this.digitalTextTexture > 0 && super.shouldApply(ticks);
    }

    public void apply(int screenWidth, int screenHeight, float ticks, IvOpenGLTexturePingPong pingPong) {
        this.useShader();
        OpenGlHelper.func_77473_a((int)(OpenGlHelper.field_77476_b + 1));
        GL11.glBindTexture((int)3553, (int)this.digitalTextTexture);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        for (int i = 0; i < 3; ++i) {
            this.setUniformInts("tex" + i, new int[]{i});
        }
        this.setUniformFloats("totalAlpha", new float[]{1.0f});
        float downscale = (float)IvMathHelper.mixEaseInOut((double)0.0, (double)0.95, (double)Math.min((double)this.digital * 3.0, 1.0));
        float textProgress = (float)IvMathHelper.easeZeroToOne((double)((this.digital - 0.2f) * 5.0f));
        float maxColors = this.digital > 0.4f ? Math.max(256.0f / ((this.digital - 0.4f) * 640.0f + 1.0f), 2.0f) : -1.0f;
        float saturation = 1.0f - (float)IvMathHelper.easeZeroToOne((double)((this.digital - 0.6f) * 5.0f));
        float binaryProgress = (float)IvMathHelper.easeZeroToOne((double)((this.digital - 0.8f) * 10.0f));
        float[] newResolution = new float[]{(float)screenWidth * (1.0f + (this.maxDownscale[0] - 1.0f) * (downscale += this.digital * 0.05f)), (float)screenHeight * (1.0f + (this.maxDownscale[1] - 1.0f) * downscale)};
        this.setUniformFloats("newResolution", newResolution);
        this.setUniformFloats("textProgress", new float[]{textProgress += binaryProgress});
        this.setUniformFloats("maxColors", new float[]{maxColors});
        this.setUniformFloats("saturation", new float[]{saturation});
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.drawFullScreen(screenWidth, screenHeight, pingPong);
        this.stopUsingShader();
    }
}

