/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.rendering.shaders;

import ivorius.ivtoolkit.rendering.IvDepthBuffer;
import ivorius.ivtoolkit.rendering.IvShaderInstance;
import ivorius.ivtoolkit.rendering.IvShaderInstance3D;
import ivorius.psychedelicraft.client.rendering.DrugEffectInterpreter;
import ivorius.psychedelicraft.client.rendering.PsycheShadowHelper;
import ivorius.psychedelicraft.client.rendering.shaders.DrugShaderHelper;
import ivorius.psychedelicraft.client.rendering.shaders.ShaderWorld;
import ivorius.psychedelicraft.entities.DrugHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import org.apache.logging.log4j.Logger;
import org.lwjgl.util.vector.Matrix;

public class ShaderMain
extends IvShaderInstance3D
implements ShaderWorld {
    public boolean shouldDoShadows;
    public int shadowDepthTextureIndex;

    public ShaderMain(Logger logger) {
        super(logger);
    }

    @Override
    public boolean activate(float partialTicks, float ticks) {
        if (this.useShader()) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityLivingBase renderEntity = mc.field_71451_h;
            DrugHelper drugHelper = DrugHelper.getDrugHelper((Entity)renderEntity);
            if (DrugEffectInterpreter.shouldRegisterFractalTextures(drugHelper)) {
                this.registerFractals();
            }
            this.setUniformInts("texture", new int[]{0});
            this.setUniformInts("lightmapTex", new int[]{1});
            this.setUniformFloats("ticks", new float[]{ticks});
            this.setUniformInts("worldTime", new int[]{(int)mc.field_71441_e.func_72820_D()});
            this.setUniformInts("uses2DShaders", new int[]{DrugShaderHelper.shader2DEnabled ? 1 : 0});
            this.setUniformFloats("playerPos", new float[]{(float)renderEntity.field_70165_t, (float)renderEntity.field_70163_u, (float)renderEntity.field_70161_v});
            this.setTexture2DEnabled(true);
            this.setLightmapEnabled(true);
            this.setBlendFunc(771);
            this.setDepthMultiplier(1.0f);
            this.setUseScreenTexCoords(false);
            this.setPixelSize(1.0f / (float)mc.field_71443_c, 1.0f / (float)mc.field_71440_d);
            this.setFogMode(9729);
            this.setOverrideColor(null);
            this.setUniformFloats("desaturation", new float[]{DrugEffectInterpreter.getDesaturation(drugHelper, partialTicks)});
            this.setUniformFloats("colorIntensification", new float[]{DrugEffectInterpreter.getColorIntensification(drugHelper, partialTicks)});
            for (String key : drugHelper.getAllVisibleDrugNames()) {
                drugHelper.getDrug(key).applyToShader((IvShaderInstance)this, key, mc, drugHelper);
            }
            if (this.shouldDoShadows) {
                this.setUniformMatrix("inverseViewMatrix", (Matrix)PsycheShadowHelper.getInverseViewMatrix(partialTicks));
                this.setUniformMatrix("sunMatrix", (Matrix)PsycheShadowHelper.getSunMatrix());
                this.setUniformInts("texShadow", new int[]{3});
                this.setUniformFloats("sunDepthRange", new float[]{PsycheShadowHelper.getSunZNear(), PsycheShadowHelper.getSunZFar()});
                this.setUniformFloats("shadowBias", new float[]{PsycheShadowHelper.getShadowBias()});
                IvDepthBuffer.bindTextureForSource((int)(OpenGlHelper.field_77476_b + 2), (int)this.shadowDepthTextureIndex);
            }
            this.setUniformInts("doShadows", new int[]{this.shouldDoShadows ? 1 : 0});
            return true;
        }
        return false;
    }

    @Override
    public void deactivate() {
        this.stopUsingShader();
    }

    public void registerFractals() {
        OpenGlHelper.func_77473_a((int)(OpenGlHelper.field_77476_b + 1));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        IIcon icon = Blocks.field_150427_aO.func_149691_a(0, 0);
        float var4 = icon.func_94209_e();
        float var5 = icon.func_94206_g();
        float var6 = icon.func_94212_f();
        float var7 = icon.func_94210_h();
        this.setUniformFloats("fractal0TexCoords", new float[]{var4, var5, var6, var7});
    }

    @Override
    public void setTexture2DEnabled(boolean enabled) {
        this.setUniformInts("texture2DEnabled", new int[]{enabled ? 1 : 0});
    }

    @Override
    public void setLightmapEnabled(boolean enabled) {
        this.setUniformInts("lightmapEnabled", new int[]{enabled ? 1 : 0});
    }

    @Override
    public void setBlendFunc(int func) {
    }

    @Override
    public void setOverrideColor(float[] color) {
        if (color != null) {
            this.setUniformFloats("overrideColor", color);
        } else {
            this.setUniformFloats("overrideColor", new float[]{1.0f, 1.0f, 1.0f, 1.0f});
        }
    }

    @Override
    public void setGLLightEnabled(boolean enabled) {
        this.setUniformInts("glLightEnabled", new int[]{enabled ? 1 : 0});
    }

    @Override
    public void setGLLight(int number, float x, float y, float z, float strength, float specular) {
        this.setUniformFloats("glLightPos" + number, new float[]{x, y, z});
        this.setUniformFloats("glLightStrength" + number, new float[]{strength, specular});
    }

    @Override
    public void setGLLightAmbient(float strength) {
        this.setUniformFloats("glLightAmbient", new float[]{strength});
    }

    @Override
    public void setFogMode(int mode) {
        this.setUniformInts("fogMode", new int[]{mode});
    }

    @Override
    public void setFogEnabled(boolean enabled) {
        this.setUniformInts("fogEnabled", new int[]{enabled ? 1 : 0});
    }

    @Override
    public void setDepthMultiplier(float depthMultiplier) {
        this.setUniformFloats("depthMultiplier", new float[]{depthMultiplier});
    }

    @Override
    public void setUseScreenTexCoords(boolean enabled) {
        this.setUniformInts("useScreenTexCoords", new int[]{enabled ? 1 : 0});
    }

    @Override
    public void setPixelSize(float pixelWidth, float pixelHeight) {
        this.setUniformFloats("pixelSize", new float[]{pixelWidth, pixelHeight});
    }

    @Override
    public void setProjectShadows(boolean projectShadows) {
        if (this.shouldDoShadows) {
            this.setUniformInts("doShadows", new int[]{projectShadows ? 1 : 0});
        }
    }
}

