/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.rendering.shaders;

import ivorius.ivtoolkit.rendering.IvDepthBuffer;
import ivorius.ivtoolkit.rendering.IvShaderInstance3D;
import ivorius.psychedelicraft.client.rendering.shaders.DrugShaderHelper;
import ivorius.psychedelicraft.client.rendering.shaders.ShaderWorld;
import ivorius.psychedelicraft.entities.DrugHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import org.apache.logging.log4j.Logger;

public class ShaderShadows
extends IvShaderInstance3D
implements ShaderWorld {
    public IvDepthBuffer depthBuffer;

    public ShaderShadows(Logger logger) {
        super(logger);
        Minecraft mc = Minecraft.func_71410_x();
        int pixels = ShaderShadows.getShadowPixels();
        this.depthBuffer = new IvDepthBuffer(pixels, pixels, logger);
    }

    public void trySettingUpShader(String vertexShaderFile, String fragmentShaderFile) {
        super.trySettingUpShader(vertexShaderFile, fragmentShaderFile);
        this.depthBuffer.allocate();
    }

    @Override
    public boolean activate(float partialTicks, float ticks) {
        if (this.depthBuffer.isAllocated() && this.useShader()) {
            int pixels = ShaderShadows.getShadowPixels();
            this.depthBuffer.setSize(pixels, pixels);
            Minecraft mc = Minecraft.func_71410_x();
            EntityLivingBase renderEntity = mc.field_71451_h;
            DrugHelper drugHelper = DrugHelper.getDrugHelper((Entity)renderEntity);
            this.setUniformFloats("ticks", new float[]{ticks});
            this.setUniformInts("worldTime", new int[]{(int)mc.field_71441_e.func_72820_D()});
            this.setTexture2DEnabled(true);
            this.setUniformFloats("playerPos", new float[]{(float)renderEntity.field_70165_t, (float)renderEntity.field_70163_u, (float)renderEntity.field_70161_v});
            this.setUniformFloats("depthMultiplier", new float[]{1.0f});
            this.setUniformFloats("pixelSize", new float[]{1.0f / (float)this.depthBuffer.getTextureWidth(), 1.0f / (float)this.depthBuffer.getTextureHeight()});
            this.setUniformInts("useScreenTexCoords", new int[]{0});
            this.setOverrideColor(null);
            this.depthBuffer.setParentFB(DrugShaderHelper.getMCFBO());
            this.depthBuffer.bind();
            return true;
        }
        return false;
    }

    @Override
    public void deactivate() {
        if (this.isShaderActive()) {
            this.depthBuffer.unbind();
        }
        this.stopUsingShader();
    }

    @Override
    public void setTexture2DEnabled(boolean enabled) {
        this.setUniformInts("texture2DEnabled", new int[]{enabled ? 1 : 0});
    }

    @Override
    public void setLightmapEnabled(boolean enabled) {
    }

    @Override
    public void setBlendFunc(int func) {
    }

    @Override
    public void setOverrideColor(float[] color) {
        if (color != null) {
            this.setUniformFloats("overrideColor", color);
        } else {
            this.setUniformFloats("overrideColor", new float[]{1.0f, 1.0f, 1.0f, 1.0f});
        }
    }

    @Override
    public void setGLLightEnabled(boolean enabled) {
    }

    @Override
    public void setGLLight(int number, float x, float y, float z, float strength, float specular) {
    }

    @Override
    public void setGLLightAmbient(float strength) {
    }

    @Override
    public void setFogMode(int mode) {
    }

    @Override
    public void setFogEnabled(boolean enabled) {
    }

    @Override
    public void setDepthMultiplier(float depthMultiplier) {
    }

    @Override
    public void setUseScreenTexCoords(boolean enabled) {
    }

    @Override
    public void setPixelSize(float pixelWidth, float pixelHeight) {
    }

    @Override
    public void setProjectShadows(boolean projectShadows) {
    }

    public static int getShadowPixels() {
        return Minecraft.func_71410_x().field_71474_y.field_151451_c * DrugShaderHelper.shadowPixelsPerChunk;
    }
}

