/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entities;

import ivorius.ivtoolkit.math.IvMathHelper;
import ivorius.ivtoolkit.rendering.IvShaderInstance;
import ivorius.psychedelicraft.entities.DrugHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;

public class Drug {
    private double effect;
    private double effectActive;
    private boolean locked = false;
    private final double decreaseSpeed;
    private final double decreaseSpeedPlus;
    private final boolean invisible;
    private boolean shouldApplyToShader;

    public Drug(double decSpeed, double decSpeedPlus) {
        this(decSpeed, decSpeedPlus, false);
    }

    public Drug(double decSpeed, double decSpeedPlus, boolean invisible) {
        this.decreaseSpeed = decSpeed;
        this.decreaseSpeedPlus = decSpeedPlus;
        this.invisible = invisible;
    }

    public void updateValues() {
        if (!this.locked) {
            this.effect *= this.decreaseSpeed;
            this.effect -= this.decreaseSpeedPlus;
        }
        this.effect = IvMathHelper.clamp((double)0.0, (double)this.effect, (double)1.0);
        this.effectActive = IvMathHelper.nearValue((double)this.effectActive, (double)this.effect, (double)0.05, (double)0.005);
    }

    public void setActiveValue(double value) {
        this.effectActive = value;
    }

    public double getActiveValue() {
        return this.effectActive;
    }

    public double getDesiredValue() {
        return this.effect;
    }

    public void setDesiredValue(double value) {
        this.effect = value;
    }

    public void addToDesiredValue(double value) {
        if (!this.locked) {
            this.effect += value;
        }
    }

    public void resetDrugValue() {
        if (!this.locked) {
            this.effect = 0.0;
        }
    }

    public void applyToShader(IvShaderInstance shaderInstance, String key, Minecraft mc, DrugHelper drugHelper) {
        if (this.shouldApplyToShader()) {
            shaderInstance.setUniformFloats(key.toLowerCase(), new float[]{(float)this.getActiveValue()});
        }
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isVisible() {
        return !this.invisible;
    }

    public boolean shouldApplyToShader() {
        return this.shouldApplyToShader;
    }

    public Drug setShouldApplyToShader(boolean apply) {
        this.shouldApplyToShader = apply;
        return this;
    }

    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74780_a("effect", this.getDesiredValue());
        par1NBTTagCompound.func_74780_a("effectActive", this.getActiveValue());
        par1NBTTagCompound.func_74757_a("locked", this.isLocked());
    }

    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        this.setDesiredValue(par1NBTTagCompound.func_74769_h("effect"));
        this.setActiveValue(par1NBTTagCompound.func_74769_h("effectActive"));
        this.setLocked(par1NBTTagCompound.func_74767_n("locked"));
    }
}

