/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entities;

import ivorius.psychedelicraft.client.rendering.shaders.DrugShaderHelper;
import ivorius.psychedelicraft.entities.DrugHallucination;
import java.util.Random;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class DrugHallucinationEntity
extends DrugHallucination {
    public static String[] hEntities = new String[]{"Creeper", "Zombie", "Blaze", "Enderman", "Cow", "Sheep", "Pig", "Ozelot", "Wolf", "Silverfish", "Villager", "VillagerGolem", "SnowMan", "EntityHorse"};
    public Entity entity;
    public int entityMaxTicks;
    public float rotationYawPlus;
    public float[] color;
    public float scale;

    public DrugHallucinationEntity(EntityPlayer playerEntity) {
        super(playerEntity);
        Random rand = playerEntity.func_70681_au();
        String entityName = hEntities[playerEntity.field_70170_p.field_73012_v.nextInt(hEntities.length)];
        this.entity = EntityList.func_75620_a((String)entityName, (World)playerEntity.field_70170_p);
        this.entity.func_70107_b(playerEntity.field_70165_t + rand.nextDouble() * 50.0 - 25.0, playerEntity.field_70163_u + rand.nextDouble() * 10.0 - 5.0, playerEntity.field_70161_v + rand.nextDouble() * 50.0 - 25.0);
        this.entity.field_70159_w = (rand.nextDouble() - 0.5) / 10.0;
        this.entity.field_70181_x = (rand.nextDouble() - 0.5) / 10.0;
        this.entity.field_70179_y = (rand.nextDouble() - 0.5) / 10.0;
        this.entity.field_70177_z = rand.nextInt(360);
        this.entityMaxTicks = (rand.nextInt(59) + 3) * 20;
        this.rotationYawPlus = rand.nextFloat() * 10.0f;
        if (rand.nextBoolean()) {
            this.rotationYawPlus = 0.0f;
        }
        this.color = new float[]{rand.nextFloat(), rand.nextFloat(), rand.nextFloat()};
        this.scale = 1.0f;
        while (rand.nextFloat() < 0.3f) {
            this.scale *= rand.nextFloat() * 2.7f + 0.3f;
        }
        if (this.scale > 20.0f) {
            this.scale = 20.0f;
        }
    }

    @Override
    public void update() {
        super.update();
        this.entity.field_70142_S = this.entity.field_70165_t;
        this.entity.field_70137_T = this.entity.field_70163_u;
        this.entity.field_70136_U = this.entity.field_70161_v;
        this.entity.field_70126_B = this.entity.field_70177_z;
        this.entity.field_70127_C = this.entity.field_70125_A;
        this.entity.field_70165_t += this.entity.field_70159_w;
        this.entity.field_70163_u += this.entity.field_70181_x;
        this.entity.field_70161_v += this.entity.field_70179_y;
        this.entity.field_70177_z += this.rotationYawPlus;
        while (this.entity.field_70177_z > 360.0f) {
            this.entity.field_70177_z -= 360.0f;
            this.entity.field_70126_B -= 360.0f;
        }
        while (this.entity.field_70177_z < 360.0f) {
            this.entity.field_70177_z += 360.0f;
            this.entity.field_70126_B += 360.0f;
        }
        if (this.entity instanceof EntityLivingBase) {
            EntityLiving entityliving = (EntityLiving)this.entity;
            double var9 = this.entity.field_70165_t - this.entity.field_70169_q;
            double var12 = this.entity.field_70161_v - this.entity.field_70166_s;
            float var11 = MathHelper.func_76133_a((double)(var9 * var9 + var12 * var12)) * 4.0f;
            if (var11 > 1.0f) {
                var11 = 1.0f;
            }
            entityliving.field_70721_aZ += (var11 / 3.0f - entityliving.field_70721_aZ) * 0.4f;
            entityliving.field_70754_ba += entityliving.field_70721_aZ;
        }
    }

    @Override
    public boolean isDead() {
        return this.entityTicksAlive >= this.entityMaxTicks;
    }

    @Override
    public void render(float par1, float dAlpha) {
        float alpha = MathHelper.func_76126_a((float)((float)Math.min(this.entityTicksAlive, this.entityMaxTicks - 2) / (float)(this.entityMaxTicks - 2) * 3.1415f)) * 18.0f;
        if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        if (alpha > 0.0f) {
            double var3 = this.entity.field_70142_S + (this.entity.field_70165_t - this.entity.field_70142_S) * (double)par1;
            double var5 = this.entity.field_70137_T + (this.entity.field_70163_u - this.entity.field_70137_T) * (double)par1;
            double var7 = this.entity.field_70136_U + (this.entity.field_70161_v - this.entity.field_70136_U) * (double)par1;
            float var9 = this.entity.field_70126_B + (this.entity.field_70177_z - this.entity.field_70126_B) * par1;
            GL11.glPushMatrix();
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3042);
            DrugShaderHelper.setOverrideColor(this.color[0], this.color[1], this.color[2], alpha * dAlpha);
            DrugShaderHelper.setLightmapEnabled(false);
            Render var10 = RenderManager.field_78727_a.func_78713_a(this.entity);
            GL11.glTranslated((double)(var3 - RenderManager.field_78725_b), (double)(var5 - RenderManager.field_78726_c), (double)(var7 - RenderManager.field_78723_d));
            GL11.glRotatef((float)var9, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScaled((double)this.scale, (double)this.scale, (double)this.scale);
            var10.func_76986_a(this.entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
            DrugShaderHelper.setLightmapEnabled(true);
            DrugShaderHelper.setOverrideColor((float[])null);
            GL11.glPopMatrix();
        }
    }

    @Override
    public int getMaxHallucinations() {
        return -1;
    }

    @Override
    public void receiveChatMessage(String message, EntityLivingBase player) {
    }
}

