/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entities;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import ivorius.ivtoolkit.network.PartialUpdateHandler;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.client.rendering.DrugEffectInterpreter;
import ivorius.psychedelicraft.client.rendering.IDrugRenderer;
import ivorius.psychedelicraft.entities.Drug;
import ivorius.psychedelicraft.entities.DrugHallucination;
import ivorius.psychedelicraft.entities.DrugHallucinationEntity;
import ivorius.psychedelicraft.entities.DrugHallucinationRastaHead;
import ivorius.psychedelicraft.entities.DrugHarmonium;
import ivorius.psychedelicraft.entities.DrugInfluence;
import ivorius.psychedelicraft.entities.DrugMessageDistorter;
import ivorius.psychedelicraft.network.PSNetworkHelperServer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class DrugHelper
implements IExtendedEntityProperties,
PartialUpdateHandler {
    public static final UUID drugUUID = UUID.fromString("2da054e7-0fe0-4fb4-bf2c-a185a5f72aa1");
    public static boolean waterOverlayEnabled;
    public static boolean hurtOverlayEnabled;
    public static float[] digitalEffectPixelRescale;
    private Hashtable<String, Drug> drugs;
    public ArrayList<DrugInfluence> influences;
    public boolean hasChanges;
    public ArrayList<DrugHallucination> hallucinations = new ArrayList();
    public IDrugRenderer drugRenderer;
    public DrugMessageDistorter drugMessageDistorter;
    public int ticksExisted = 0;
    public int timeBreathingSmoke;
    public float[] breathSmokeColor;
    public int delayUntilHeartbeat;
    public int delayUntilBreath;
    public boolean breathDeep;

    public DrugHelper() {
        this.drugs = new Hashtable();
        this.influences = new ArrayList();
        this.drugMessageDistorter = new DrugMessageDistorter();
        this.addDrug("Alcohol", new Drug(1.0, 2.0E-4));
        this.addDrug("Cannabis", new Drug(1.0, 2.0E-4));
        this.addDrug("BrownShrooms", new Drug(1.0, 2.0E-4).setShouldApplyToShader(true));
        this.addDrug("RedShrooms", new Drug(1.0, 2.0E-4).setShouldApplyToShader(true));
        this.addDrug("Tobacco", new Drug(1.0, 0.003));
        this.addDrug("Cocaine", new Drug(1.0, 3.0E-4));
        this.addDrug("Caffeine", new Drug(1.0, 2.0E-4));
        this.addDrug("Warmth", new Drug(1.0, 0.004, true));
        this.addDrug("Peyote", new Drug(1.0, 2.0E-4).setShouldApplyToShader(true));
        this.addDrug("Zero", new Drug(1.0, 1.0E-4));
        this.addDrug("Power", new Drug(0.95, 1.0E-4, true));
        this.addDrug("Harmonium", new DrugHarmonium(1.0, 3.0E-4));
    }

    public static DrugHelper getDrugHelper(Entity entity) {
        if (entity != null) {
            return (DrugHelper)entity.getExtendedProperties("DrugHelper");
        }
        return null;
    }

    public static void initInEntity(Entity entity) {
        entity.registerExtendedProperties("DrugHelper", (IExtendedEntityProperties)new DrugHelper());
        DrugHelper drugHelper = DrugHelper.getDrugHelper(entity);
        if (drugHelper != null) {
            Psychedelicraft.proxy.createDrugRender(drugHelper);
        }
    }

    public void addDrug(String drugName, Drug drug) {
        this.drugs.put(drugName, drug);
    }

    public Drug getDrug(String drugName) {
        if (!this.drugs.containsKey(drugName)) {
            return null;
        }
        return this.drugs.get(drugName);
    }

    public float getDrugValue(String drugName) {
        return (float)this.drugs.get(drugName).getActiveValue();
    }

    public float getDrugClamped(String drugName, float min, float max) {
        return MathHelper.func_76131_a((float)((this.getDrugValue(drugName) - min) / (max - min)), (float)0.0f, (float)1.0f);
    }

    public void addToDrug(String drugName, double effect) {
        if (!this.drugs.containsKey(drugName)) {
            Psychedelicraft.logger.warn("Tried to add to drug " + drugName);
            return;
        }
        this.hasChanges = true;
        this.drugs.get(drugName).addToDesiredValue(effect);
    }

    public void setDrugValue(String drugName, double effect) {
        if (!this.drugs.containsKey(drugName)) {
            Psychedelicraft.logger.warn("Tried to set drug value " + drugName);
            return;
        }
        this.hasChanges = true;
        this.drugs.get(drugName).setDesiredValue(effect);
    }

    public void addToDrug(DrugInfluence influence) {
        this.hasChanges = true;
        this.influences.add(influence);
    }

    public Collection<Drug> getAllDrugs() {
        return this.drugs.values();
    }

    public String[] getAllVisibleDrugNames() {
        ArrayList<String> visibleDrugs = new ArrayList<String>();
        for (String s : this.drugs.keySet()) {
            if (!this.drugs.get(s).isVisible()) continue;
            visibleDrugs.add(s);
        }
        String[] returnArray = new String[visibleDrugs.size()];
        visibleDrugs.toArray(returnArray);
        return returnArray;
    }

    public boolean doesDrugExist(String name) {
        return this.drugs.containsKey(name);
    }

    public void addRandomHallucination(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            return;
        }
        if (this.getNumberOfHallucinations(DrugHallucinationRastaHead.class) == 0 && player.func_70681_au().nextFloat() < 0.1f && this.getDrugValue("Cannabis") > 0.4f) {
            this.hallucinations.add(new DrugHallucinationRastaHead(player));
        } else {
            this.hallucinations.add(new DrugHallucinationEntity(player));
        }
    }

    public int getNumberOfHallucinations(Class aClass) {
        int count = 0;
        for (DrugHallucination hallucination : this.hallucinations) {
            if (!aClass.isAssignableFrom(hallucination.getClass())) continue;
            ++count;
        }
        return count;
    }

    public void startBreathingSmoke(int time, float[] color) {
        this.breathSmokeColor = color != null ? color : new float[]{1.0f, 1.0f, 1.0f};
        this.timeBreathingSmoke = time + 10;
    }

    public void updateDrugEffects(EntityLivingBase entity) {
        if (this.ticksExisted % 5 == 0) {
            Iterator<DrugInfluence> influenceIterator = this.influences.iterator();
            while (influenceIterator.hasNext()) {
                DrugInfluence influence = influenceIterator.next();
                influence.update(this);
                if (!influence.isDone()) continue;
                influenceIterator.remove();
            }
        }
        for (String key : this.drugs.keySet()) {
            Drug drug = this.drugs.get(key);
            drug.updateValues();
        }
        if (this.getDrugValue("Alcohol") > 0.0f) {
            float d;
            if (this.ticksExisted % 20 == 0 && this.getDrugValue("Alcohol") > 0.8f) {
                entity.func_70097_a(DamageSource.field_76366_f, (float)((int)((this.getDrugValue("Alcohol") - 0.8f) * 25.0f + 1.0f)));
            }
            if ((d = this.getDrugValue("Alcohol")) > 0.8f) {
                d = 0.8f;
            }
            entity.field_70125_A += MathHelper.func_76126_a((float)((float)this.ticksExisted / 600.0f * (float)Math.PI)) / 2.0f * d * (entity.field_70170_p.field_73012_v.nextFloat() + 0.5f);
            entity.field_70177_z += MathHelper.func_76134_b((float)((float)this.ticksExisted / 500.0f * (float)Math.PI)) / 1.3f * d * (entity.field_70170_p.field_73012_v.nextFloat() + 0.5f);
            entity.field_70125_A += MathHelper.func_76126_a((float)((float)this.ticksExisted / 180.0f * (float)Math.PI)) / 3.0f * d * (entity.field_70170_p.field_73012_v.nextFloat() + 0.5f);
            entity.field_70177_z += MathHelper.func_76134_b((float)((float)this.ticksExisted / 150.0f * (float)Math.PI)) / 2.0f * d * (entity.field_70170_p.field_73012_v.nextFloat() + 0.5f);
        }
        if (this.getDrugValue("Cannabis") > 0.0f && entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_71020_j(0.03f * this.getDrugValue("Cannabis"));
        }
        if (this.getDrugValue("Cocaine") > 0.0f && !entity.field_70170_p.field_72995_K) {
            float chance = (this.getDrugValue("Cocaine") - 0.8f) * 0.1f;
            if (this.ticksExisted % 20 == 0 && entity.func_70681_au().nextFloat() < chance) {
                entity.func_70097_a(DamageSource.field_76376_m, 1000.0f);
            }
        }
        if (entity.field_70170_p.field_72995_K) {
            this.updateHallucinations(entity);
            if (this.delayUntilHeartbeat > 0) {
                --this.delayUntilHeartbeat;
            }
            if (this.delayUntilBreath > 0) {
                --this.delayUntilBreath;
            }
            if (this.delayUntilHeartbeat == 0) {
                float heartbeatVolume = 0.0f;
                if (this.getDrugValue("Cocaine") > 0.4f) {
                    heartbeatVolume += (this.getDrugValue("Cocaine") - 0.4f) * 2.0f;
                }
                if (this.getDrugValue("Caffeine") > 0.6f) {
                    heartbeatVolume += (this.getDrugValue("Caffeine") - 0.6f) * 0.5f;
                }
                if (heartbeatVolume > 0.0f) {
                    float speed = 1.0f;
                    speed += this.getDrugValue("Cocaine") * 0.1f;
                    this.delayUntilHeartbeat = (int)(35.0f - ((speed += this.getDrugValue("Caffeine") * 0.2f) - 1.0f) * 80.0f);
                    entity.field_70170_p.func_72980_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, Psychedelicraft.soundBase + "heartBeat", heartbeatVolume, speed, false);
                }
            }
            if (this.getDrugValue("Cocaine") > 0.4f && this.delayUntilBreath == 0) {
                this.delayUntilBreath = (int)(30.0f - this.getDrugValue("Cocaine") * 10.0f);
                this.breathDeep = !this.breathDeep;
                entity.field_70170_p.func_72980_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, Psychedelicraft.soundBase + "breath", (this.getDrugValue("Cocaine") - 0.4f) * 1.5f, 1.0f + this.getDrugValue("Cocaine") * 0.1f + (this.breathDeep ? 0.15f : 0.0f), false);
            }
            if (this.getDrugValue("Caffeine") > 0.0f) {
                if (entity.field_70122_E) {
                    float jumpChance = 0.0f;
                    if (this.getDrugValue("Cocaine") > 0.6f) {
                        jumpChance += (this.getDrugValue("Cocaine") - 0.6f) * 0.03f;
                    }
                    if (this.getDrugValue("Caffeine") > 0.6f) {
                        jumpChance += (this.getDrugValue("Caffeine") - 0.6f) * 0.07f;
                    }
                    if (entity instanceof EntityPlayer && entity.func_70681_au().nextFloat() < jumpChance) {
                        ((EntityPlayer)entity).func_70664_aZ();
                    }
                }
                if (!entity.field_82175_bq) {
                    float punchChance = 0.0f;
                    if (this.getDrugValue("Cocaine") > 0.3f) {
                        punchChance += (this.getDrugValue("Cocaine") - 0.5f) * 0.02f;
                    }
                    if (this.getDrugValue("Caffeine") > 0.3f) {
                        punchChance += (this.getDrugValue("Caffeine") - 0.3f) * 0.05f;
                    }
                    if (entity.func_70681_au().nextFloat() < punchChance) {
                        entity.func_71038_i();
                    }
                }
            }
        }
        if (this.timeBreathingSmoke > 0) {
            --this.timeBreathingSmoke;
            if (this.timeBreathingSmoke > 10 && entity.field_70170_p.field_72995_K) {
                Vec3 look = entity.func_70040_Z();
                if (entity.func_70681_au().nextInt(2) == 0) {
                    float s = entity.func_70681_au().nextFloat() * 0.05f + 0.1f;
                    Psychedelicraft.proxy.spawnColoredParticle((Entity)entity, this.breathSmokeColor, look, s, 1.0f);
                }
                if (entity.func_70681_au().nextInt(5) == 0) {
                    float s = entity.func_70681_au().nextFloat() * 0.05f + 0.1f;
                    Psychedelicraft.proxy.spawnColoredParticle((Entity)entity, this.breathSmokeColor, look, s, 2.5f);
                }
            }
        }
        if (this.drugRenderer != null && entity.field_70170_p.field_72995_K) {
            this.drugRenderer.update(this, entity);
        }
        this.changeDrugModifierMultiply(entity, SharedMonsterAttributes.field_111263_d, this.getSpeedModifier(entity));
        ++this.ticksExisted;
        if (this.hasChanges) {
            this.hasChanges = false;
            if (!entity.field_70170_p.field_72995_K) {
                PSNetworkHelperServer.sendEEPUpdatePacket((Entity)entity, "DrugHelper", "DrugData", Psychedelicraft.network, new Object[0]);
            }
        }
    }

    public void updateHallucinations(EntityLivingBase entity) {
        float hallucinationChance = DrugEffectInterpreter.getHallucinationStrength(this, 1.0f) * 0.05f;
        if (hallucinationChance > 0.0f && entity.func_70681_au().nextInt((int)(1.0f / hallucinationChance)) == 0 && entity instanceof EntityPlayer) {
            this.addRandomHallucination((EntityPlayer)entity);
        }
        ArrayList<DrugHallucination> toRemove = null;
        for (DrugHallucination h : this.hallucinations) {
            h.update();
            if (!h.isDead()) continue;
            if (toRemove == null) {
                toRemove = new ArrayList<DrugHallucination>();
            }
            toRemove.add(h);
        }
        if (toRemove != null) {
            this.hallucinations.removeAll(toRemove);
        }
    }

    public void readFromNBT(NBTTagCompound par1NBTTagCompound, boolean fromPacket) {
        for (String key : this.drugs.keySet()) {
            NBTTagCompound cmp = par1NBTTagCompound.func_74775_l(key);
            if (cmp == null) continue;
            this.drugs.get(key).readFromNBT(cmp);
        }
        this.influences.clear();
        NBTTagList influenceTagList = par1NBTTagCompound.func_150295_c("drugInfluences", 10);
        for (int i = 0; i < influenceTagList.func_74745_c(); ++i) {
            NBTTagCompound compound = influenceTagList.func_150305_b(i);
            Class<? extends DrugInfluence> influenceClass = DrugInfluence.keyToClass.get(compound.func_74779_i("influenceClass"));
            if (influenceClass == null) continue;
            DrugInfluence inf = null;
            try {
                inf = influenceClass.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (inf == null) continue;
            inf.readFromNBT(compound);
            this.addToDrug(inf);
        }
        this.ticksExisted = par1NBTTagCompound.func_74762_e("drugsTicksExisted");
        if (fromPacket) {
            this.hasChanges = true;
        }
    }

    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        for (String key : this.drugs.keySet()) {
            NBTTagCompound cmp = new NBTTagCompound();
            this.drugs.get(key).writeToNBT(cmp);
            par1NBTTagCompound.func_74782_a(key, (NBTBase)cmp);
        }
        NBTTagList influenceTagList = new NBTTagList();
        for (DrugInfluence influence : this.influences) {
            NBTTagCompound compound = new NBTTagCompound();
            influence.writeToNBT(compound);
            compound.func_74778_a("influenceClass", DrugInfluence.classToKey.get(influence.getClass()));
            influenceTagList.func_74742_a((NBTBase)compound);
        }
        par1NBTTagCompound.func_74782_a("drugInfluences", (NBTBase)influenceTagList);
        par1NBTTagCompound.func_74768_a("drugsTicksExisted", this.ticksExisted);
    }

    public NBTTagCompound createNBTTagCompound() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.writeToNBT(tagCompound);
        return tagCompound;
    }

    public void wakeUp(EntityLivingBase entity) {
        for (String key : this.drugs.keySet()) {
            this.drugs.get(key).resetDrugValue();
        }
    }

    public void receiveChatMessage(EntityLivingBase entity, String message) {
        for (DrugHallucination h : this.hallucinations) {
            h.receiveChatMessage(message, entity);
        }
    }

    public float getSpeedModifier(EntityLivingBase entity) {
        float modifier = 1.0f;
        modifier *= (1.0f - this.getDrugValue("Cannabis")) * 0.5f + 0.5f;
        modifier *= 1.0f + this.getDrugValue("Cocaine") * 0.15f;
        return modifier *= 1.0f + this.getDrugValue("Caffeine") * 0.2f;
    }

    public float getDigSpeedModifier(EntityLivingBase entity) {
        float modifier = 1.0f;
        modifier *= (1.0f - this.getDrugValue("Cannabis")) * 0.5f + 0.5f;
        modifier *= 1.0f + this.getDrugValue("Cocaine") * 0.15f;
        return modifier *= 1.0f + this.getDrugValue("Caffeine") * 0.2f;
    }

    public EntityPlayer.EnumStatus getDrugSleepStatus() {
        if (this.getDrugValue("Cocaine") > 0.4f) {
            return Psychedelicraft.sleepStatusDrugs;
        }
        if (this.getDrugValue("Caffeine") > 0.1f) {
            return Psychedelicraft.sleepStatusDrugs;
        }
        return null;
    }

    public float getSoundMultiplier() {
        return 1.0f - this.getDrugValue("Power");
    }

    public float[] getDigitalEffectPixelResize() {
        return digitalEffectPixelRescale;
    }

    public void changeDrugModifierMultiply(EntityLivingBase entity, IAttribute attribute, double value) {
        this.changeDrugModifier(entity, attribute, value - 1.0, 2);
    }

    public void changeDrugModifier(EntityLivingBase entity, IAttribute attribute, double value, int mode) {
        IAttributeInstance speedInstance = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
        AttributeModifier oldModifier = speedInstance.func_111127_a(drugUUID);
        if (oldModifier != null) {
            speedInstance.func_111124_b(oldModifier);
        }
        AttributeModifier newModifier = new AttributeModifier(drugUUID, "Drug Effects", value, mode);
        speedInstance.func_111121_a(newModifier);
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74782_a("drugData", (NBTBase)this.createNBTTagCompound());
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.readFromNBT(compound.func_74775_l("drugData"), true);
    }

    public void init(Entity entity, World world) {
    }

    public void writeUpdateData(ByteBuf buffer, String context, Object ... params) {
        if ("DrugData".equals(context)) {
            NBTTagCompound compound = new NBTTagCompound();
            this.writeToNBT(compound);
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)compound);
        }
    }

    public void readUpdateData(ByteBuf buffer, String context) {
        if ("DrugData".equals(context)) {
            this.readFromNBT(ByteBufUtils.readTag((ByteBuf)buffer), true);
        }
    }
}

