/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entities;

import ivorius.psychedelicraft.entities.DrugHelper;
import java.util.Hashtable;
import net.minecraft.nbt.NBTTagCompound;

public class DrugInfluence {
    public static Hashtable<String, Class<? extends DrugInfluence>> keyToClass = new Hashtable();
    public static Hashtable<Class<? extends DrugInfluence>, String> classToKey = new Hashtable();
    public String drugName;
    public int delay;
    public double influenceSpeed;
    public double influenceSpeedPlus;
    public double maxInfluence;

    public static void registerInfluence(Class<? extends DrugInfluence> clazz, String key) {
        keyToClass.put(key, clazz);
        classToKey.put(clazz, key);
    }

    public DrugInfluence(String drugName, int delay, double influenceSpeed, double influenceSpeedPlus, double maxInfluence) {
        this.drugName = drugName;
        this.delay = delay;
        this.influenceSpeed = influenceSpeed;
        this.influenceSpeedPlus = influenceSpeedPlus;
        this.maxInfluence = maxInfluence;
    }

    public DrugInfluence() {
    }

    public void update(DrugHelper drugHelper) {
        if (this.delay > 0) {
            --this.delay;
        }
        if (this.delay == 0 && this.maxInfluence > 0.0) {
            double addition = Math.min(this.maxInfluence, this.influenceSpeedPlus + this.maxInfluence * this.influenceSpeed);
            this.addToDrug(drugHelper, addition);
            this.maxInfluence -= addition;
        }
    }

    public void addToDrug(DrugHelper drugHelper, double value) {
        drugHelper.addToDrug(this.drugName, value);
    }

    public boolean isDone() {
        return this.maxInfluence <= 0.0;
    }

    public DrugInfluence clone() {
        DrugInfluence inf = null;
        try {
            inf = (DrugInfluence)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (inf != null) {
            NBTTagCompound cmp = new NBTTagCompound();
            this.writeToNBT(cmp);
            inf.readFromNBT(cmp);
        }
        return inf;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.drugName = compound.func_74779_i("drugName");
        this.delay = compound.func_74762_e("delay");
        this.influenceSpeed = compound.func_74769_h("influenceSpeed");
        this.influenceSpeedPlus = compound.func_74769_h("influenceSpeedPlus");
        this.maxInfluence = compound.func_74769_h("maxInfluence");
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("drugName", this.drugName);
        compound.func_74768_a("delay", this.delay);
        compound.func_74780_a("influenceSpeed", this.influenceSpeed);
        compound.func_74780_a("influenceSpeedPlus", this.influenceSpeedPlus);
        compound.func_74780_a("maxInfluence", this.maxInfluence);
    }
}

