/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entities;

import ivorius.ivtoolkit.math.IvMathHelper;
import ivorius.psychedelicraft.entities.Drug;
import ivorius.psychedelicraft.entities.DrugHarmonium;
import ivorius.psychedelicraft.entities.DrugHelper;
import ivorius.psychedelicraft.entities.DrugInfluence;
import net.minecraft.nbt.NBTTagCompound;

public class DrugInfluenceHarmonium
extends DrugInfluence {
    public float[] color;

    public DrugInfluenceHarmonium(String drugName, int delay, double influenceSpeed, double influenceSpeedPlus, double maxInfluence, float[] color) {
        super(drugName, delay, influenceSpeed, influenceSpeedPlus, maxInfluence);
        this.color = color;
    }

    public DrugInfluenceHarmonium() {
        this.color = new float[3];
    }

    @Override
    public void addToDrug(DrugHelper drugHelper, double value) {
        super.addToDrug(drugHelper, value);
        Drug drug = drugHelper.getDrug(this.drugName);
        if (drug instanceof DrugHarmonium) {
            DrugHarmonium harmonium = (DrugHarmonium)drug;
            double inf = value + (1.0 - value) * (1.0 - harmonium.getActiveValue());
            harmonium.currentColor[0] = (float)IvMathHelper.mix((double)harmonium.currentColor[0], (double)this.color[0], (double)inf);
            harmonium.currentColor[1] = (float)IvMathHelper.mix((double)harmonium.currentColor[1], (double)this.color[1], (double)inf);
            harmonium.currentColor[2] = (float)IvMathHelper.mix((double)harmonium.currentColor[2], (double)this.color[2], (double)inf);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74776_a("color[0]", this.color[0]);
        compound.func_74776_a("color[1]", this.color[1]);
        compound.func_74776_a("color[2]", this.color[2]);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.color[0] = compound.func_74760_g("color[0]");
        this.color[1] = compound.func_74760_g("color[1]");
        this.color[2] = compound.func_74760_g("color[2]");
    }
}

