/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entities;

import ivorius.ivtoolkit.math.IvMathHelper;
import ivorius.psychedelicraft.entities.DrugHelper;
import java.util.Random;
import net.minecraft.entity.Entity;

public class DrugMessageDistorter {
    public static String[] fillerWords = new String[]{", like, ", "... like, ", ", uhm, ", ", uhhhh, "};
    public static String[] startFillerWords = new String[]{"Dude, ", "Dood, ", "Dewd, ", "Dude, like, ", "Dood, like, ", "Dewd, like, ", "Yeah... ", "And, "};

    public String distortIncomingMessage(DrugHelper drugHelper, Entity entity, Random random, String message) {
        return message;
    }

    public String distortOutgoingMessage(DrugHelper drugHelper, Entity entity, Random random, String message) {
        if (message.indexOf("/") == 0) {
            return message;
        }
        float alcohol = drugHelper.getDrugValue("Alcohol");
        float zero = drugHelper.getDrugValue("Zero");
        float cannabis = drugHelper.getDrugValue("Cannabis");
        if (alcohol > 0.0f || zero > 0.0f || cannabis > 0.0f) {
            return this.distortIncomingMessage(message, random, alcohol, zero, cannabis);
        }
        return message;
    }

    public String distortIncomingMessage(String message, Random random, float alcohol, float zero, float cannabis) {
        StringBuilder builder = new StringBuilder();
        float randomCaseChance = IvMathHelper.zeroToOne((float)alcohol, (float)0.3f, (float)1.0f) * 0.06f + IvMathHelper.zeroToOne((float)zero, (float)0.0f, (float)0.3f);
        float randomLetterChance = IvMathHelper.zeroToOne((float)alcohol, (float)0.5f, (float)1.0f) * 0.015f;
        float sToShChance = IvMathHelper.zeroToOne((float)alcohol, (float)0.2f, (float)0.6f);
        float longShChance = alcohol * 0.8f;
        float hicChance = IvMathHelper.zeroToOne((float)alcohol, (float)0.5f, (float)1.0f) * 0.04f;
        float rewindChance = IvMathHelper.zeroToOne((float)alcohol, (float)0.4f, (float)0.9f) * 0.03f;
        float longCharChance = IvMathHelper.zeroToOne((float)alcohol, (float)0.3f, (float)1.0f) * 0.025f;
        float oneZeroChance = IvMathHelper.zeroToOne((float)zero, (float)0.6f, (float)0.95f);
        float randomCharChance = IvMathHelper.zeroToOne((float)zero, (float)0.2f, (float)0.95f);
        float fillerWordChance = IvMathHelper.zeroToOne((float)cannabis, (float)0.2f, (float)0.95f) * 0.1f;
        float startFillerWordChance = IvMathHelper.zeroToOne((float)cannabis, (float)0.2f, (float)0.95f) * 0.7f;
        boolean wasPoint = true;
        for (int i = 0; i < message.length(); ++i) {
            char origChar;
            char curChar = origChar = message.charAt(i);
            if (random.nextFloat() < oneZeroChance) {
                curChar = random.nextBoolean() ? (char)'0' : '1';
            } else if (random.nextFloat() < randomCharChance) {
                curChar = (char)(32 + random.nextInt(95));
            } else if (random.nextFloat() < randomLetterChance) {
                curChar = (char)((random.nextBoolean() ? 97 : 65) + random.nextInt(26));
            } else if (random.nextFloat() < randomCaseChance && random.nextBoolean()) {
                curChar = Character.isUpperCase(curChar) ? Character.toLowerCase(curChar) : Character.toUpperCase(curChar);
            }
            if ((curChar == 's' || curChar == 'S') && random.nextFloat() < sToShChance) {
                builder.append(curChar).append(random.nextFloat() < longShChance ? "hh" : "h");
            } else if (curChar == ' ' && random.nextFloat() < fillerWordChance) {
                builder.append(fillerWords[random.nextInt(fillerWords.length)]);
            } else if (wasPoint && random.nextFloat() < startFillerWordChance) {
                builder.append(startFillerWords[random.nextInt(startFillerWords.length)]).append(curChar);
            } else {
                builder.append(curChar);
            }
            wasPoint = false;
            if (random.nextFloat() < longCharChance) {
                float moreChance = 1.2f;
                do {
                    builder.append(curChar);
                } while (random.nextFloat() < (moreChance *= 0.5f));
            }
            if (random.nextFloat() < hicChance) {
                builder.append("*hic*");
            }
            if (!(random.nextFloat() < rewindChance)) continue;
            builder.append("... ");
            int wordsRewind = random.nextInt(5) + 1;
            for (int j = 0; j < wordsRewind; ++j) {
                i = message.lastIndexOf(" ", i - 1);
            }
            if (i >= 0) continue;
            i = 0;
        }
        return builder.toString();
    }
}

