/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entities;

import ivorius.ivtoolkit.math.IvMathHelper;
import ivorius.psychedelicraft.blocks.PSBlocks;
import ivorius.psychedelicraft.entities.DrugHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityRealityRift
extends Entity {
    public float visualRiftSize;

    public EntityRealityRift(World par1World) {
        super(par1World);
        this.func_70105_a(2.0f, 2.0f);
        this.field_70158_ak = true;
        this.field_70129_M = this.field_70131_O / 2.0f;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(15, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(14, (Object)0);
        this.field_70180_af.func_75682_a(13, (Object)Float.valueOf(0.0f));
        this.setRiftSize(this.field_70170_p.field_73012_v.nextFloat() * 0.5f + 0.5f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        boolean critical = this.isCritical();
        if (this.field_70170_p.field_72995_K) {
            double zP;
            double yP;
            double xP;
            int smokeParticles = this.field_70146_Z.nextInt(3);
            for (int i = 0; i < smokeParticles; ++i) {
                float distance = this.field_70146_Z.nextFloat() * this.field_70146_Z.nextFloat();
                double xP2 = ((double)this.field_70146_Z.nextFloat() * 8.0 - 4.0) * (double)distance;
                double yP2 = ((double)this.field_70146_Z.nextFloat() * 8.0 - 4.0) * (double)distance;
                double zP2 = ((double)this.field_70146_Z.nextFloat() * 8.0 - 4.0) * (double)distance;
                this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t + xP2, this.field_70163_u + yP2 + (double)(this.field_70131_O / 2.0f), this.field_70161_v + zP2, 0.0, 0.0, 0.0);
            }
            int stationarySmoke = this.field_70146_Z.nextInt(2);
            for (int i = 0; i < stationarySmoke; ++i) {
                float distance = this.field_70146_Z.nextFloat() * this.field_70146_Z.nextFloat();
                xP = ((double)this.field_70146_Z.nextFloat() * 8.0 - 4.0) * (double)distance;
                yP = ((double)this.field_70146_Z.nextFloat() * 8.0 - 4.0) * (double)distance;
                zP = ((double)this.field_70146_Z.nextFloat() * 8.0 - 4.0) * (double)distance;
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t + xP, this.field_70163_u + yP + (double)(this.field_70131_O / 2.0f), this.field_70161_v + zP, -10.0, -10.0, -10.0);
            }
            int textParticles = 1;
            for (int i = 0; i < textParticles; ++i) {
                xP = (double)this.field_70146_Z.nextFloat() * 8.0 - 4.0;
                yP = (double)this.field_70146_Z.nextFloat() * 8.0 - 4.0;
                zP = (double)this.field_70146_Z.nextFloat() * 8.0 - 4.0;
                this.field_70170_p.func_72869_a("enchantmenttable", this.field_70165_t, this.field_70163_u + 1.0 + (double)(this.field_70131_O / 2.0f), this.field_70161_v, xP, yP, zP);
            }
        }
        float searchDistance = 5.0f + this.getCriticalStatus() * 50.0f;
        List entityList = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b((double)searchDistance, (double)searchDistance, (double)searchDistance));
        for (EntityLivingBase entityLivingBase : entityList) {
            DrugHelper drugHelper = DrugHelper.getDrugHelper((Entity)entityLivingBase);
            double dist = entityLivingBase.func_70032_d((Entity)this);
            double effect = ((double)searchDistance - dist) * 5.0E-4 * (double)this.getRiftSize();
            if (!(effect > 0.0)) continue;
            if (drugHelper != null) {
                drugHelper.addToDrug("Zero", effect * 20.0);
                drugHelper.addToDrug("Power", effect * 200.0);
                continue;
            }
            if (!critical) continue;
            entityLivingBase.func_70097_a(DamageSource.field_76376_m, (float)effect * 20.0f);
        }
        if (critical) {
            float prevS = this.getCriticalStatus();
            float newS = Math.min(prevS + 0.001f, 1.0f);
            this.setCriticalStatus(newS);
            float prevDesRange = prevS * 50.0f;
            float newDesRange = newS * 50.0f;
            int desRange = MathHelper.func_76123_f((float)newDesRange);
            if (prevDesRange < newDesRange) {
                int nX = MathHelper.func_76128_c((double)this.field_70165_t);
                int nY = MathHelper.func_76128_c((double)this.field_70163_u);
                int nZ = MathHelper.func_76128_c((double)this.field_70161_v);
                for (int x = -desRange; x <= desRange; ++x) {
                    for (int y = -desRange; y <= desRange; ++y) {
                        for (int z = -desRange; z <= desRange; ++z) {
                            Block b;
                            float acRange = x * x + y * y + z * z;
                            if (!(acRange <= newDesRange * newDesRange) || !(acRange > prevDesRange * prevDesRange) || !((b = this.field_70170_p.func_147439_a(nX + x, nY + y, nZ + z)).func_149712_f(this.field_70170_p, nX + x, nY + y, nZ + z) >= 0.0f) || b.func_149688_o() == Material.field_151579_a) continue;
                            this.field_70170_p.func_147449_b(nX + x, nY + y, nZ + z, PSBlocks.glitched);
                        }
                    }
                }
            }
        }
        if (this.isRiftClosing()) {
            this.setRiftSize(this.getRiftSize() - 0.05f);
        } else if (!critical) {
            this.setRiftSize(this.getRiftSize() - 4.1666666E-5f);
        }
        this.visualRiftSize = IvMathHelper.nearValue((float)this.visualRiftSize, (float)this.getRiftSize(), (float)0.05f, (float)0.005f);
        if (!this.field_70170_p.field_72995_K) {
            if (this.getCriticalStatus() >= 0.9f) {
                this.setRiftClosing(true);
            }
            if (this.visualRiftSize <= 0.0f && this.getRiftSize() <= 0.0f) {
                this.func_70106_y();
            }
        }
    }

    protected void func_70037_a(NBTTagCompound var1) {
        this.setRiftSize(var1.func_74760_g("riftSize"));
        this.setRiftClosing(var1.func_74767_n("isRiftClosing"));
        this.setCriticalStatus(var1.func_74760_g("criticalStatus"));
    }

    protected void func_70014_b(NBTTagCompound var1) {
        var1.func_74776_a("riftSize", this.getRiftSize());
        var1.func_74757_a("isRiftClosing", this.isRiftClosing());
        var1.func_74776_a("criticalStatus", this.getCriticalStatus());
    }

    public float getRiftSize() {
        return this.field_70180_af.func_111145_d(15);
    }

    public void setRiftSize(float size) {
        this.field_70180_af.func_75692_b(15, (Object)Float.valueOf(size > 0.0f ? size : 0.0f));
    }

    public float getCriticalStatus() {
        return this.field_70180_af.func_111145_d(13);
    }

    public void setCriticalStatus(float status) {
        this.field_70180_af.func_75692_b(13, (Object)Float.valueOf(status > 0.0f ? status : 0.0f));
    }

    public void addToRift(float size) {
        this.setRiftSize(this.getRiftSize() + size);
    }

    public float takeFromRift(float size) {
        if (this.isCritical()) {
            return 0.2f;
        }
        float riftSize = this.getRiftSize();
        float newVal = Math.max(riftSize - size, 0.0f);
        this.setRiftSize(newVal);
        return riftSize - newVal;
    }

    public boolean isRiftClosing() {
        return this.field_70180_af.func_75683_a(14) == 1;
    }

    public void setRiftClosing(boolean closing) {
        this.field_70180_af.func_75692_b(14, (Object)(closing ? (byte)1 : 0));
    }

    public boolean isCritical() {
        return (this.getCriticalStatus() > 0.0f || this.getRiftSize() > 3.0f) && !this.isRiftClosing();
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }
}

