/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ivorius.psychedelicraft.entities.DrugHelper;
import ivorius.psychedelicraft.entities.EntityRealityRift;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;

public class PSEventForgeHandler {
    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void spawnRiftAtPlayer(EntityPlayer player) {
        EntityRealityRift rift = new EntityRealityRift(player.func_130014_f_());
        double xP = (player.func_70681_au().nextDouble() - 0.5) * 100.0;
        double yP = (player.func_70681_au().nextDouble() - 0.5) * 100.0;
        double zP = (player.func_70681_au().nextDouble() - 0.5) * 100.0;
        rift.func_70107_b(player.field_70165_t + xP, player.field_70163_u + yP, player.field_70161_v + zP);
        player.func_130014_f_().func_72838_d((Entity)rift);
    }

    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        DrugHelper drugHelper;
        Object[] args = event.component.func_150271_j();
        if (args.length > 1 && (drugHelper = DrugHelper.getDrugHelper((Entity)event.player)) != null) {
            String modified = drugHelper.drugMessageDistorter.distortOutgoingMessage(drugHelper, (Entity)event.player, event.player.func_70681_au(), event.message);
            args[1] = modified;
        }
    }

    @SubscribeEvent
    public void onClientChatReceived(ClientChatReceivedEvent event) {
        if (event.message instanceof ChatComponentText) {
            ChatComponentText text = (ChatComponentText)event.message;
            EntityLivingBase renderEntity = Minecraft.func_71410_x().field_71451_h;
            DrugHelper drugHelper = DrugHelper.getDrugHelper((Entity)renderEntity);
            if (drugHelper != null) {
                String message = text.func_150261_e();
                drugHelper.receiveChatMessage(renderEntity, message);
                String modified = drugHelper.drugMessageDistorter.distortIncomingMessage(drugHelper, (Entity)renderEntity, renderEntity.func_70681_au(), message);
                event.message = new ChatComponentText(modified);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerSleep(PlayerSleepInBedEvent event) {
        DrugHelper drugHelper = DrugHelper.getDrugHelper((Entity)event.entityLiving);
        EntityPlayer.EnumStatus status = drugHelper.getDrugSleepStatus();
        if (status != null) {
            event.result = status;
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        DrugHelper.getDrugHelper(event.entity);
    }

    @SubscribeEvent
    public void onEntityConstruction(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer) {
            DrugHelper.initInEntity(event.entity);
        }
    }

    @SubscribeEvent
    public void getBreakSpeed(PlayerEvent.BreakSpeed event) {
        DrugHelper drugHelper = DrugHelper.getDrugHelper(event.entity);
        if (drugHelper != null) {
            event.newSpeed *= drugHelper.getDigSpeedModifier(event.entityLiving);
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.PORTAL) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityLivingBase renderEntity = mc.field_71451_h;
            DrugHelper drugHelper = DrugHelper.getDrugHelper((Entity)renderEntity);
            if (drugHelper != null && drugHelper.drugRenderer != null) {
                drugHelper.drugRenderer.renderOverlaysAfterShaders(event.partialTicks, renderEntity, renderEntity.field_70173_aa, event.resolution.func_78326_a(), event.resolution.func_78328_b(), drugHelper);
            }
        }
    }
}

