/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.items;

import ivorius.psychedelicraft.items.IDrink;
import ivorius.psychedelicraft.items.ItemDrinkHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;

public class DrinkRegistry {
    private static List<ItemDrinkHolder> registeredDrinkHolders = new ArrayList<ItemDrinkHolder>();
    private static Hashtable<String, IDrink> registeredDrinks = new Hashtable();
    private static Hashtable<Item, Hashtable<String, String>> registeredDrinkSpecialIcons = new Hashtable();

    public static void registerDrink(String id, IDrink drink) {
        registeredDrinks.put(id, drink);
    }

    public static void registerSpecialIcon(String drinkID, Item item, String iconName) {
        if (!registeredDrinkSpecialIcons.containsKey(item)) {
            registeredDrinkSpecialIcons.put(item, new Hashtable());
        }
        registeredDrinkSpecialIcons.get(item).put(drinkID, iconName);
    }

    public static void registerDrinkHolder(ItemDrinkHolder item) {
        registeredDrinkHolders.add(item);
    }

    public Collection<String> getAllDrinkIDs() {
        return registeredDrinks.keySet();
    }

    public static String getDrinkIDFromStack(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        return stack.func_77978_p().func_74779_i("drinkID");
    }

    public static IDrink getDrinkFromStack(ItemStack stack) {
        String drinkID = DrinkRegistry.getDrinkIDFromStack(stack);
        if (drinkID != null) {
            return registeredDrinks.get(drinkID);
        }
        return null;
    }

    public static String getDrinkTranslationKey(ItemStack stack) {
        IDrink drink;
        String drinkKey = DrinkRegistry.getDrinkIDFromStack(stack);
        if (drinkKey != null && (drink = registeredDrinks.get(drinkKey)) != null) {
            String specialKey = drink.getSpecialTranslationKey(stack);
            return "psDrink." + drinkKey + (specialKey != null ? "." + specialKey : "");
        }
        return null;
    }

    public static String getDrinkSpecialIcon(ItemStack stack) {
        Hashtable<String, String> iconsForItem;
        String drinkID = DrinkRegistry.getDrinkIDFromStack(stack);
        if (drinkID != null && (iconsForItem = registeredDrinkSpecialIcons.get(stack.func_77973_b())) != null) {
            return iconsForItem.get(drinkID);
        }
        return null;
    }

    public static Collection<String> getSpecialIcons(Item item) {
        return registeredDrinkSpecialIcons.get(item).values();
    }

    public static List<ItemDrinkHolder> getAllDrinkHolders() {
        return registeredDrinkHolders;
    }

    public static Collection<String> getAllDrinks() {
        return registeredDrinks.keySet();
    }

    public static ItemStack createDrinkStack(Item item, int stackSize, String drinkID) {
        ItemStack stack = new ItemStack(item, stackSize);
        stack.func_77983_a("drinkID", (NBTBase)new NBTTagString(drinkID));
        return stack;
    }
}

