/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.items;

import ivorius.psychedelicraft.entities.DrugInfluence;
import ivorius.psychedelicraft.items.DrinkRegistry;
import ivorius.psychedelicraft.items.IDrink;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DrinkWine
implements IDrink {
    public static ItemStack createWineStack(Item item, int stackSize, int wineStrength) {
        ItemStack stack = DrinkRegistry.createDrinkStack(item, stackSize, "wine");
        stack.func_77983_a("wineStrength", (NBTBase)new NBTTagInt(wineStrength));
        return stack;
    }

    @Override
    public List<DrugInfluence> getDrugInfluences(ItemStack stack) {
        int wineStrength = stack.func_77978_p().func_74762_e("wineStrength");
        if (wineStrength < 14 && wineStrength > 2) {
            return Arrays.asList(new DrugInfluence("Alcohol", 20, 0.002, 0.001, 0.02 * (double)(stack.func_77960_j() - 2)));
        }
        return Arrays.asList(new Object[0]);
    }

    @Override
    public Pair<Integer, Float> getFoodLevel(ItemStack stack) {
        int wineStrength = stack.func_77978_p().func_74762_e("wineStrength");
        if (wineStrength < 14) {
            int foodLevel = wineStrength < 5 ? 1 : 0;
            return new MutablePair((Object)foodLevel, (Object)Float.valueOf((float)foodLevel * 0.1f));
        }
        return null;
    }

    @Override
    public void applyToEntity(ItemStack stack, World world, EntityLivingBase entityLivingBase) {
    }

    @Override
    public String getSpecialTranslationKey(ItemStack stack) {
        int wineStrength = stack.func_77978_p().func_74762_e("wineStrength");
        return "" + wineStrength;
    }
}

