/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.items;

import ivorius.psychedelicraft.entities.DrugHelper;
import ivorius.psychedelicraft.entities.DrugInfluence;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemSmokeable
extends Item {
    DrugInfluence[] drugEffects;
    String[] textureNames;
    String[] inUseTextureNames;
    IIcon[] textures;
    IIcon[] inUseTextures;
    public float[] smokeColor;

    public ItemSmokeable(DrugInfluence[] drugEffects, String[] textureNames, String[] inUseTextures) {
        this.drugEffects = drugEffects;
        this.textureNames = textureNames;
        this.inUseTextureNames = inUseTextures;
        this.textures = new IIcon[textureNames.length];
        this.inUseTextures = new IIcon[this.inUseTextureNames.length];
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(this.textures.length < 2 ? 64 : 1);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.bow;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        for (DrugInfluence drugInfluence : this.drugEffects) {
            DrugHelper.getDrugHelper((Entity)player).addToDrug(drugInfluence.clone());
        }
        if (stack.func_77960_j() < this.textures.length - 1) {
            stack.func_77964_b(stack.func_77960_j() + 1);
        } else {
            --stack.field_77994_a;
        }
        DrugHelper.getDrugHelper((Entity)player).startBreathingSmoke(10 + world.field_73012_v.nextInt(10), this.smokeColor);
        return super.func_77654_b(stack, world, player);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (DrugHelper.getDrugHelper((Entity)player).timeBreathingSmoke == 0) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 25;
    }

    public boolean func_77629_n_() {
        return true;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        int i;
        for (i = 0; i < this.textureNames.length; ++i) {
            this.textures[i] = iconRegister.func_94245_a(this.func_111208_A() + "_" + this.textureNames[i]);
        }
        for (i = 0; i < this.inUseTextureNames.length; ++i) {
            if (this.inUseTextureNames[i] == null) continue;
            this.inUseTextures[i] = iconRegister.func_94245_a(this.func_111208_A() + "_" + this.inUseTextureNames[i]);
        }
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        int damage = stack.func_77960_j();
        if (damage < this.inUseTextures.length && this.inUseTextures[damage] != null) {
            return this.inUseTextures[damage];
        }
        return super.getIcon(stack, renderPass, player, usingItem, useRemaining);
    }

    public IIcon func_77617_a(int damage) {
        if (damage < this.textures.length) {
            return this.textures[damage];
        }
        return this.textures[0];
    }
}

